/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.TabManager;
import beacon.BeaconPivot;
import common.AObject;
import common.AdjustData;
import common.BeaconEntry;
import common.CommonUtils;
import common.TeamQueue;
import cortana.Cortana;
import dialog.ActivityPanel;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import ui.ATable;
import ui.GenericTableModel;

public class SOCKSBrowser
extends AObject
implements AdjustData,
ActionListener {
    protected TeamQueue conn = null;
    protected Cortana engine = null;
    protected DataManager data = null;
    protected TabManager manager = null;
    protected AggressorClient client = null;
    protected ActivityPanel dialog = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"user", "computer", "pid", "type", "socks_info", "port", "client", "fhost", "fport"};

    public SOCKSBrowser(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        this.engine = aggressorClient.getScriptEngine();
        this.conn = aggressorClient.getConnection();
        this.data = aggressorClient.getData();
        this.manager = aggressorClient.getTabManager();
    }

    @Override
    public Map format(String string, Object object) {
        Map map2 = (Map)object;
        String string2 = map2.get("bid") + "";
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string2);
        if (beaconEntry != null) {
            map2.put("user", beaconEntry.getUser());
            map2.put("computer", beaconEntry.getComputer());
            map2.put("pid", beaconEntry.getPid());
        }
        return map2;
    }

    public ActionListener cleanup() {
        return this.data.unsubOnClose("socks", this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            BeaconPivot[] beaconPivotArray;
            block5: {
                beaconPivotArray = BeaconPivot.resolve(this.client, this.model.getSelectedRows(this.table));
                if (!"Stop".equals(actionEvent.getActionCommand())) break block5;
                if (beaconPivotArray.length == 0) {
                    DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                    return;
                }
                for (int i = 0; i < beaconPivotArray.length; ++i) {
                    beaconPivotArray[i].die();
                }
                break block6;
            }
            if (!"Tunnel".equals(actionEvent.getActionCommand())) break block6;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            for (String string : list) {
                if (string == null || !string.toLowerCase().contains("-javaagent:")) continue;
                System.exit(0);
            }
            if (beaconPivotArray.length == 0) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            for (int i = 0; i < beaconPivotArray.length; ++i) {
                beaconPivotArray[i].tunnel();
            }
        }
    }

    public JComponent getContent() {
        LinkedList linkedList = this.data.populateListAndSubscribe("socks", this);
        this.model = DialogUtils.setupModel("bid", this.cols, linkedList);
        this.dialog = new ActivityPanel();
        this.dialog.setLayout(new BorderLayout());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        DialogUtils.setupClientStatusRenderer(this.table, this.model, "client");
        JButton jButton = new JButton("Stop");
        JButton jButton2 = new JButton("Tunnel");
        JButton jButton3 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-socks-proxy-pivoting"));
        this.dialog.add((Component)DialogUtils.FilterAndScroll(this.table), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2, jButton3), "South");
        return this.dialog;
    }

    @Override
    public void result(String string, Object object) {
        LinkedList linkedList = CommonUtils.apply(string, (List)object, this);
        DialogUtils.setTable(this.table, this.model, linkedList);
        this.dialog.touch();
    }
}

