/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.TranscriptEditor;
import common.AObject;
import common.AdjustData;
import common.DownloadFile;
import common.DownloadNotify;
import common.Helper;
import common.MudgeSanity;
import common.Screenshot;
import common.ScriptUtils;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import sleep.runtime.Scalar;
import ui.ATextField;
import ui.DataBrowser;
import ui.DataSelectionListener;
import ui.TablePopup;
import ui.ZoomableImage;

public class ScreenshotBrowser
extends AObject
implements AdjustData,
DataSelectionListener,
TablePopup,
DownloadNotify {
    protected AggressorClient client = null;
    protected DataBrowser browser = null;
    protected ZoomableImage viewer = null;
    protected JTextField title = null;
    protected TranscriptEditor editor = new TranscriptEditor();
    protected ByteArrayOutputStream out = null;

    public ScreenshotBrowser(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        aggressorClient.getData().populateAndSubscribe("accents", this);
        aggressorClient.getData().populateAndSubscribe("screenshot.delete", this);
        Helper helper = new Helper();
        if (!helper.startHelper(this.getClass())) {
            System.exit(0);
        }
    }

    public ActionListener cleanup() {
        return this.client.getData().unsubOnClose("screenshots, accents", this);
    }

    public JComponent getContent() {
        LinkedList linkedList = this.client.getData().populateAndSubscribe("screenshots", this);
        this.title = new ATextField("", 20);
        this.title.setEditable(false);
        this.viewer = new ZoomableImage();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)DialogUtils.pad(this.title, 3, 3, 3, 3), "North");
        jPanel.add((Component)new JScrollPane(this.viewer), "Center");
        this.browser = DataBrowser.getScreenshotDataBrowser("object", jPanel, linkedList);
        this.browser.addDataSelectionListener(this);
        this.browser.getTable().setPopupMenu(this);
        DialogUtils.setupDateRenderer(this.browser.getTable(), "when");
        this.editor.setTable(this.browser.getTable(), this.browser.getModel());
        return this.browser;
    }

    @Override
    public void selected(Object object) {
        if (object != null && object instanceof Screenshot) {
            Screenshot screenshot = (Screenshot)object;
            this.title.setText(screenshot.getWindowTitle());
            this.viewer.setIcon(null);
            this.out = new ByteArrayOutputStream();
            new DownloadFile(this.client.getConnection(), screenshot.ID(), this.out, this).startScreenshot();
        } else {
            this.title.setText("");
            this.viewer.setIcon(null);
        }
    }

    @Override
    public void complete(String string) {
        try {
            this.viewer.setIcon(new ImageIcon(this.out.toByteArray()));
            this.out.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("ScreenshotBrowser failed to close stream", iOException, false);
        }
    }

    @Override
    public void cancel() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("ScreenshotBrowser failed to close stream", iOException, false);
        }
    }

    @Override
    public Map format(String string, Object object) {
        if (this.editor.processTranscriptFormat(string, object)) {
            return null;
        }
        Screenshot screenshot = (Screenshot)object;
        if (this.editor.isRemoved(screenshot)) {
            return null;
        }
        Map map2 = screenshot.toMap();
        map2.put("object", screenshot);
        return this.editor.decorate(screenshot, map2);
    }

    @Override
    public void result(String string, Object object) {
        if (this.editor.processTranscriptResult(string, object)) {
            return;
        }
        if ("screenshot.delete".equals(string) && object instanceof String[]) {
            for (String string2 : (String[])object) {
                this.browser.removeEntry("id", string2);
            }
        } else {
            if (this.browser == null) {
                return;
            }
            Map map2 = this.format(string, object);
            if (map2 != null) {
                this.browser.addEntry(map2);
            }
        }
    }

    @Override
    public void showPopup(MouseEvent mouseEvent) {
        Map map2 = this.browser.getSelectedRow();
        if (map2 != null) {
            Stack<Scalar> stack = new Stack<Scalar>();
            stack.push(ScriptUtils.convertAll(map2));
            this.client.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, "screenshots", stack);
        }
    }
}

