/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.browsers.Services;
import common.AObject;
import common.CommonUtils;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ServiceBrowser
extends AObject
implements ActionListener {
    protected AggressorClient client = null;
    protected Services browser = null;

    public ServiceBrowser(AggressorClient aggressorClient, String[] stringArray) {
        this.client = aggressorClient;
        this.browser = new Services(aggressorClient, stringArray);
    }

    public ActionListener cleanup() {
        return this.browser.cleanup();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Remove".equals(actionEvent.getActionCommand())) {
            if (!this.browser.hasSelectedRows()) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            Map[] mapArray = this.browser.getSelectedRows();
            for (int i = 0; i < mapArray.length; ++i) {
                this.client.getConnection().call("services.remove", CommonUtils.args(CommonUtils.ServiceKey(mapArray[i])));
            }
            this.client.getConnection().call("services.push");
        } else if ("Note...".equals(actionEvent.getActionCommand())) {
            if (!this.browser.hasSelectedRows()) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            SafeDialogs.ask("Set Note to:", "", new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    Map[] mapArray = ServiceBrowser.this.browser.getSelectedRows();
                    for (int i = 0; i < mapArray.length; ++i) {
                        mapArray[i].put("note", string);
                        ServiceBrowser.this.client.getConnection().call("services.add", CommonUtils.args(CommonUtils.ServiceKey(mapArray[i]), mapArray[i]));
                    }
                    ServiceBrowser.this.client.getConnection().call("services.push");
                }
            });
        }
    }

    public JComponent getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Remove");
        JButton jButton2 = new JButton("Note...");
        JButton jButton3 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-targets"));
        jPanel.add((Component)this.browser.getContent(), "Center");
        jPanel.add((Component)DialogUtils.center(jButton, jButton2, jButton3), "South");
        return jPanel;
    }
}

