/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.DataManager;
import aggressor.DataUtils;
import common.AObject;
import common.Callback;
import common.CommonUtils;
import common.TeamQueue;
import cortana.Cortana;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import ui.ATable;
import ui.GenericTableModel;

public class SiteManager
extends AObject
implements Callback,
ActionListener {
    protected TeamQueue conn = null;
    protected Cortana engine = null;
    protected DataManager data = null;
    protected GenericTableModel model = null;
    protected ATable table = null;
    protected String[] cols = new String[]{"URI", "Host", "Port", "Type", "Description"};

    public SiteManager(DataManager dataManager, Cortana cortana, TeamQueue teamQueue) {
        this.engine = cortana;
        this.conn = teamQueue;
        this.data = dataManager;
        this.model = DialogUtils.setupModel("URI", this.cols, DataUtils.getSites(dataManager));
        dataManager.subscribe("sites", this);
    }

    public ActionListener cleanup() {
        return this.data.unsubOnClose("sites", this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Kill".equals(actionEvent.getActionCommand())) {
            if (!this.model.hasSelectedRows(this.table)) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            Object[][] objectArray = this.model.getSelectedValuesFromColumns(this.table, CommonUtils.toArray("URI, Port"));
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i][0] + "";
                String string2 = objectArray[i][1] + "";
                this.conn.call("cloudstrike.kill_site", CommonUtils.args(string2, string));
            }
        } else if ("Copy URL".equals(actionEvent.getActionCommand())) {
            if (!this.model.hasSelectedRows(this.table)) {
                DialogUtils.showError(DialogUtils.MessageID.A_ROW_MUST_BE_SELECTED);
                return;
            }
            String string = this.model.getSelectedValue(this.table) + "";
            String string3 = this.model.getSelectedValueFromColumn(this.table, "Host") + "";
            String string4 = this.model.getSelectedValueFromColumn(this.table, "Port") + "";
            String string5 = this.model.getSelectedValueFromColumn(this.table, "Proto") + "";
            String string6 = string5 + string3 + ":" + string4 + string;
            String string7 = this.model.getSelectedValueFromColumn(this.table, "Description") + "";
            if ("PowerShell Web Delivery".equals(string7)) {
                DialogUtils.addToClipboard(CommonUtils.PowerShellOneLiner(string6));
            } else if (string7.startsWith("Scripted Web Delivery (") && string7.endsWith(")")) {
                String string8 = string7;
                string8 = CommonUtils.strrep(string8, "Scripted Web Delivery (", "");
                string8 = CommonUtils.strrep(string8, ")", "");
                DialogUtils.addToClipboard(CommonUtils.OneLiner(string6, string8));
            } else {
                DialogUtils.addToClipboard(string6);
            }
        }
    }

    public JComponent getContent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.table = DialogUtils.setupTable((TableModel)this.model, this.cols, true);
        DialogUtils.setTableColumnWidths(this.table, DialogUtils.toMap("URI: 125, Host: 125, Port: 60, Type: 60, Description: 250"));
        JButton jButton = new JButton("Kill");
        JButton jButton2 = new JButton("Copy URL");
        JButton jButton3 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-manage-sites"));
        jPanel.add((Component)DialogUtils.FilterAndScroll(this.table), "Center");
        jPanel.add((Component)DialogUtils.center(jButton2, jButton, jButton3), "South");
        return jPanel;
    }

    @Override
    public void result(String string, Object object) {
        DialogUtils.setTable(this.table, this.model, (LinkedList)object);
    }
}

