/*
 * Decompiled with CFR 0.152.
 */
package aggressor.windows;

import aggressor.AggressorClient;
import aggressor.browsers.Targets;
import aggressor.dialogs.ImportHosts;
import aggressor.dialogs.TargetDialog;
import common.AObject;
import common.CommonUtils;
import dialog.ActivityPanel;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;

public class TargetBrowser
extends AObject
implements ActionListener {
    protected AggressorClient client = null;
    protected Targets browser = null;
    protected ActivityPanel dialog = null;

    public TargetBrowser(AggressorClient aggressorClient) {
        this.client = aggressorClient;
        this.browser = new Targets(aggressorClient);
    }

    public ActionListener cleanup() {
        return this.browser.cleanup();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Add".equals(actionEvent.getActionCommand())) {
            new TargetDialog(this.client).show();
        } else if ("Import".equals(actionEvent.getActionCommand())) {
            SafeDialogs.openFile("Choose a file", null, null, true, false, new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    String[] stringArray = CommonUtils.toArray(string);
                    new ImportHosts(TargetBrowser.this.client, stringArray);
                }
            });
        } else if ("Remove".equals(actionEvent.getActionCommand())) {
            if (!this.browser.hasSelectedRows()) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            Map[] mapArray = this.browser.getSelectedRows();
            for (int i = 0; i < mapArray.length; ++i) {
                this.client.getConnection().call("targets.remove", CommonUtils.args(CommonUtils.TargetKey(mapArray[i])));
            }
            this.client.getConnection().call("targets.push");
        } else if ("Note...".equals(actionEvent.getActionCommand())) {
            if (!this.browser.hasSelectedRows()) {
                DialogUtils.showError(DialogUtils.MessageID.ROWS_MUST_BE_SELECTED);
                return;
            }
            SafeDialogs.ask("Set Note to:", "", new SafeDialogCallback(){

                @Override
                public void dialogResult(String string) {
                    Map[] mapArray = TargetBrowser.this.browser.getSelectedRows();
                    for (int i = 0; i < mapArray.length; ++i) {
                        HashMap<String, String> hashMap = new HashMap<String, String>(mapArray[i]);
                        hashMap.put("note", string);
                        hashMap.remove("image");
                        TargetBrowser.this.client.getConnection().call("targets.add", CommonUtils.args(CommonUtils.TargetKey(hashMap), hashMap));
                    }
                    TargetBrowser.this.client.getConnection().call("targets.push");
                }
            });
        }
    }

    public JComponent getContent() {
        this.dialog = new ActivityPanel();
        this.dialog.setLayout(new BorderLayout());
        this.browser.notifyOnResult(this.dialog);
        JButton jButton = new JButton("Add");
        JButton jButton2 = new JButton("Import");
        JButton jButton3 = new JButton("Remove");
        JButton jButton4 = new JButton("Note...");
        JButton jButton5 = new JButton("Help");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jButton5.addActionListener(DialogUtils.gotoURL("https://www.cobaltstrike.com/help-targets"));
        this.dialog.add((Component)this.browser.getContent(), "Center");
        this.dialog.add((Component)DialogUtils.center(jButton, jButton2, jButton3, jButton4, jButton5), "South");
        return this.dialog;
    }
}

