/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import common.CommandParser;
import common.CommonUtils;
import common.MudgeSanity;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BeaconCommands {
    public Map descriptions = new HashMap();
    public Map details = new HashMap();

    public BeaconCommands() {
        this.loadCommands();
        this.loadDetails();
    }

    public void register(String string, String string2, String string3) {
        this.descriptions.put(string, string2);
        this.details.put(string, string3);
    }

    public String getCommandFile() {
        return "resources/bhelp.txt";
    }

    public String getDetailFile() {
        return "resources/bdetails.txt";
    }

    protected void loadCommands() {
        try {
            InputStream inputStream = CommonUtils.resource(this.getCommandFile());
            byte[] byArray = CommonUtils.readAll(inputStream);
            inputStream.close();
            String[] stringArray = CommonUtils.bString(byArray).split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\t+");
                if (stringArray2.length == 2) {
                    this.descriptions.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                CommonUtils.print_error("bhelp, line: " + i + " '" + stringArray[i] + "'");
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("Load Commands", iOException, false);
        }
    }

    protected void loadDetails() {
        try {
            InputStream inputStream = CommonUtils.resource(this.getDetailFile());
            byte[] byArray = CommonUtils.readAll(inputStream);
            inputStream.close();
            String[] stringArray = CommonUtils.bString(byArray).split("\n");
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                CommandParser commandParser = new CommandParser(stringArray[i]);
                if (commandParser.is("beacon>")) {
                    if (!commandParser.verify("AZ")) continue;
                    if (string != null) {
                        this.details.put(string, stringBuffer.toString().trim());
                    }
                    string = commandParser.popString();
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(stringArray[i] + "\n");
            }
            this.details.put(string, stringBuffer.toString().trim());
        }
        catch (IOException iOException) {
            MudgeSanity.logException("Load Details", iOException, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List commands() {
        BeaconCommands beaconCommands = this;
        synchronized (beaconCommands) {
            return new LinkedList(this.descriptions.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetails(String string) {
        BeaconCommands beaconCommands = this;
        synchronized (beaconCommands) {
            return this.details.get(string) + "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(String string) {
        BeaconCommands beaconCommands = this;
        synchronized (beaconCommands) {
            return this.descriptions.get(string) + "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHelpAvailable(String string) {
        BeaconCommands beaconCommands = this;
        synchronized (beaconCommands) {
            return this.details.containsKey(string);
        }
    }
}

