/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import beacon.pivots.BrowserPivotPortForward;
import beacon.pivots.PortForwardPivot;
import beacon.pivots.ReversePortForwardPivot;
import beacon.pivots.SOCKSPivot;
import dialog.DialogUtils;
import java.util.Map;

public abstract class BeaconPivot {
    protected AggressorClient client = null;
    protected String bid = null;
    protected int port = 0;

    public static BeaconPivot resolve(AggressorClient aggressorClient, Map map2) {
        BeaconPivot beaconPivot = null;
        String string = DialogUtils.string(map2, "type");
        String string2 = DialogUtils.string(map2, "bid");
        int n = DialogUtils.number(map2, "port");
        beaconPivot = string.equals("reverse port forward") ? new ReversePortForwardPivot() : (string.equals("reverse port forward (local)") ? new ReversePortForwardPivot() : (string.equals("port forward") ? new PortForwardPivot() : (string.equals("browser pivot http proxy") ? new BrowserPivotPortForward() : new SOCKSPivot(string))));
        beaconPivot.client = aggressorClient;
        beaconPivot.bid = string2;
        beaconPivot.port = n;
        return beaconPivot;
    }

    public static BeaconPivot[] resolve(AggressorClient aggressorClient, Map[] mapArray) {
        BeaconPivot[] beaconPivotArray = new BeaconPivot[mapArray.length];
        for (int i = 0; i < beaconPivotArray.length; ++i) {
            beaconPivotArray[i] = BeaconPivot.resolve(aggressorClient, mapArray[i]);
        }
        return beaconPivotArray;
    }

    public abstract void die();

    public abstract void tunnel();
}

