/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.BeaconStoreItemType;
import beacon.BeaconSyscallMethod;
import common.BeaconEntry;
import common.CommonUtils;
import common.ListenerUtils;
import common.StringStack;
import console.Console;
import console.GenericTabCompletion;
import cortana.Cortana;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BeaconTabCompletion
extends GenericTabCompletion {
    protected AggressorClient client;
    protected String bid;

    public BeaconTabCompletion(String string, AggressorClient aggressorClient, Console console) {
        super(console);
        this.client = aggressorClient;
        this.bid = string;
    }

    public static void filterList(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next() + "";
            if (string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    @Override
    public String transformText(String string) {
        return string.replace(" ~", " " + System.getProperty("user.home"));
    }

    public Collection getOptionsFromList(String string, List list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringStack stringStack = new StringStack(string, " ");
        stringStack.pop();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(stringStack.toString() + " " + iterator.next());
        }
        Collections.sort(linkedList);
        BeaconTabCompletion.filterList(linkedList, string);
        return linkedList;
    }

    public boolean isFoo(String string) {
        return string.matches("elevate .*? .*") || string.matches("spawn x.. .*") || string.matches("spawnu \\d+ .*") || string.matches("inject \\d+ .*");
    }

    public boolean isBar(String string) {
        return string.matches("spawnas .*? .*? .*") || string.matches("jump .*? .*? .*");
    }

    public boolean isLink(String string) {
        return string.matches("link .*? .*");
    }

    public boolean isConnect(String string) {
        return string.matches("connect .*? .*");
    }

    @Override
    public Collection getOptions(String string) {
        LinkedList<String> linkedList = DataUtils.getBeaconCommands(this.client.getData()).commands();
        linkedList.addAll(this.client.getAliases().commands());
        Collections.sort(linkedList);
        Cortana.filterList(linkedList, string);
        if (linkedList != null && linkedList.size() == 0 && string.matches("inject \\d+ x.. .*")) {
            List list = ListenerUtils.getListenerNames(this.client);
            if (list.size() == 0) {
                linkedList.add(string);
            } else {
                int n = string.indexOf(" ");
                int n2 = string.indexOf(" ", n + 1);
                linkedList = new LinkedList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(string.substring(0, string.indexOf(" ", n2 + 1)) + " " + iterator.next());
                }
            }
            Collections.sort((LinkedList)linkedList);
            BeaconTabCompletion.filterList(linkedList, string);
        } else if (linkedList != null && linkedList.size() == 0 && this.isFoo(string)) {
            List list = ListenerUtils.getListenerNames(this.client);
            if (list.size() == 0) {
                linkedList.add(string);
            } else {
                int n = string.indexOf(" ");
                linkedList = new LinkedList<String>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(string.substring(0, string.indexOf(" ", n + 1)) + " " + iterator.next());
                }
            }
            Collections.sort((LinkedList)linkedList);
            BeaconTabCompletion.filterList(linkedList, string);
        } else if (linkedList != null && linkedList.size() == 0 && this.isBar(string)) {
            List list = ListenerUtils.getListenerNames(this.client);
            if (list.size() == 0) {
                linkedList.add(string);
            } else {
                int n = string.indexOf(" ");
                int n3 = string.indexOf(" ", n + 1);
                linkedList = new LinkedList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(string.substring(0, string.indexOf(" ", n3 + 1)) + " " + iterator.next());
                }
            }
            Collections.sort(linkedList);
            BeaconTabCompletion.filterList(linkedList, string);
        } else if (linkedList != null && linkedList.size() == 0 && string.startsWith("spawn ")) {
            List list = ListenerUtils.getListenerNames(this.client);
            if (list.size() == 0) {
                linkedList.add(string);
            } else {
                linkedList = new LinkedList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(string.substring(0, string.indexOf(" ")) + " " + iterator.next());
                }
            }
            Collections.sort(linkedList);
            BeaconTabCompletion.filterList(linkedList, string);
        } else {
            if (linkedList != null && linkedList.size() == 0 && string.startsWith("elevate ")) {
                List list = DataUtils.getBeaconExploits(this.client.getData()).exploits();
                return this.getOptionsFromList(string, list);
            }
            if (linkedList != null && linkedList.size() == 0 && string.startsWith("runasadmin ")) {
                List list = DataUtils.getBeaconElevators(this.client.getData()).elevators();
                return this.getOptionsFromList(string, list);
            }
            if (linkedList != null && linkedList.size() == 0 && (string.startsWith("kerberos_ticket_use ") || string.startsWith("kerberos_ccache_use ") || string.startsWith("upload ") || string.startsWith("powershell-import "))) {
                String string2 = string.substring(string.indexOf(" ") + 1);
                File file = new File(string2);
                if (!file.exists() || !file.isDirectory()) {
                    file = file.getParentFile();
                }
                linkedList = new LinkedList();
                if (file == null) {
                    linkedList.add(string);
                    return linkedList;
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory() && string.startsWith("powershell-import") && !fileArray[i].getName().endsWith(".ps1")) continue;
                    linkedList.add(string.substring(0, string.indexOf(" ")) + " " + fileArray[i].getAbsolutePath());
                }
                Collections.sort(linkedList);
                BeaconTabCompletion.filterList(linkedList, string);
            } else if (linkedList != null && linkedList.size() == 0 && (string.matches("execute-assembly .*") || string.matches("inline-execute .*") || string.matches("shspawn x.. .*") || string.matches("shinject \\d+ x.. .*") || string.matches("dllinject \\d+ .*") || string.matches("ssh-key .*? .*? .*") || string.matches("spunnel .*? .*? .*? .*") || string.matches("spunnel_local .*? .*? .*? .*") || string.matches("data-store load .* .*") || string.matches("data-store load .* .* .*"))) {
                StringStack stringStack = new StringStack(string, " ");
                String string3 = stringStack.pop();
                File file = new File(string3);
                if (!file.exists() || !file.isDirectory()) {
                    file = file.getParentFile();
                }
                linkedList = new LinkedList();
                if (file == null) {
                    linkedList.add(string);
                    return linkedList;
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                    linkedList.add(stringStack.toString() + " " + fileArray[i].getAbsolutePath());
                }
                Collections.sort(linkedList);
                BeaconTabCompletion.filterList(linkedList, string);
            } else {
                if (linkedList != null && linkedList.size() == 0 && (string.startsWith("help net ") || string.startsWith("? net "))) {
                    List list = CommonUtils.getNetCommands();
                    return this.getOptionsFromList(string, list);
                }
                if (linkedList != null && linkedList.size() == 0 && (string.startsWith("help ") || string.startsWith("? "))) {
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    Iterator iterator = CommonUtils.getNetCommands().iterator();
                    while (iterator.hasNext()) {
                        linkedList2.add("net " + iterator.next());
                    }
                    List list = DataUtils.getBeaconCommands(this.client.getData()).commands();
                    return this.getOptionsFromList(string, CommonUtils.combine(linkedList2, list));
                }
                if (linkedList != null && linkedList.size() == 0 && this.isLink(string)) {
                    List list = DataUtils.getNamedPipes(this.client.getData());
                    return this.getOptionsFromList(string, list);
                }
                if (linkedList != null && linkedList.size() == 0 && this.isConnect(string)) {
                    List list = DataUtils.getTCPPorts(this.client.getData());
                    return this.getOptionsFromList(string, list);
                }
                if (linkedList != null && linkedList.size() == 0 && (string.startsWith("ssh ") || string.startsWith("ssh-key ") || string.matches("jump .*? .*") || string.matches("remote-exec .*? .*"))) {
                    List list = DataUtils.getTargetNames(this.client.getData());
                    return this.getOptionsFromList(string, list);
                }
                if (linkedList != null && linkedList.size() == 0 && (string.startsWith("link ") || string.startsWith("connect "))) {
                    List list = DataUtils.getTargetNames(this.client.getData());
                    list.add("127.0.0.1");
                    return this.getOptionsFromList(string, list);
                }
                if (linkedList != null && linkedList.size() == 0 && (string.matches("spunnel .*? .*") || string.matches("spunnel_local .*? .*"))) {
                    LinkedList<String> linkedList3 = new LinkedList<String>();
                    linkedList3.add("127.0.0.1");
                    return this.getOptionsFromList(string, linkedList3);
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("jump ")) {
                    List list = DataUtils.getBeaconRemoteExploits(this.client.getData()).exploits();
                    return this.getOptionsFromList(string, list);
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("remote-exec ")) {
                    List list = DataUtils.getBeaconRemoteExecMethods(this.client.getData()).methods();
                    return this.getOptionsFromList(string, list);
                }
                if (linkedList != null && linkedList.size() == 0 && (string.startsWith("powershell ") || string.startsWith("powerpick ") || string.matches("psinject \\d+ x.. .*"))) {
                    LinkedList linkedList4 = new LinkedList(DataUtils.getBeaconPowerShellCommands(this.client.getData(), this.bid));
                    LinkedList<String> linkedList5 = new LinkedList<String>();
                    Iterator iterator = linkedList4.iterator();
                    while (iterator.hasNext()) {
                        String string4 = iterator.next() + "";
                        if (string4.length() <= 0) continue;
                        linkedList5.add(string4);
                        linkedList5.add("Get-Help " + string4 + " -full");
                    }
                    return this.getOptionsFromList(string, linkedList5);
                }
                if (linkedList != null && linkedList.size() == 0 && string.matches("reg query.*? x.. .*")) {
                    return this.getOptionsFromList(string, CommonUtils.toList("HKCC\\, HKCR\\, HKCU\\, HKLM\\, HKU\\"));
                }
                if (linkedList != null && linkedList.size() == 0 && (string.startsWith("reg query ") || string.startsWith("reg queryv "))) {
                    return this.getOptionsFromList(string, CommonUtils.toList("x64, x86"));
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("reg ")) {
                    return this.getOptionsFromList(string, CommonUtils.toList("query, queryv"));
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("net ")) {
                    return this.getOptionsFromList(string, CommonUtils.getNetCommands());
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("note ")) {
                    BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), this.bid);
                    if (beaconEntry != null) {
                        LinkedList<String> linkedList6 = new LinkedList<String>();
                        linkedList6.add(beaconEntry.getNote());
                        return this.getOptionsFromList(string, linkedList6);
                    }
                    return this.getOptionsFromList(string, new LinkedList());
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("covertvpn ")) {
                    return this.getOptionsFromList(string, DataUtils.getInterfaceList(this.client.getData()));
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("desktop ")) {
                    return this.getOptionsFromList(string, CommonUtils.toList("high, low"));
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("blockdlls ")) {
                    return this.getOptionsFromList(string, CommonUtils.toList("start, stop"));
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("unlink ")) {
                    Object object;
                    LinkedList<String> linkedList7 = new LinkedList<String>();
                    BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), this.bid);
                    if (beaconEntry != null && beaconEntry.getParentId() != null && !beaconEntry.getPivotHint().isReverse() && (object = DataUtils.getBeacon(this.client.getData(), beaconEntry.getParentId())) != null) {
                        linkedList7.add(((BeaconEntry)object).getInternal() + " " + ((BeaconEntry)object).getPid());
                    }
                    for (BeaconEntry beaconEntry2 : DataUtils.getBeaconChildren(this.client.getData(), this.bid)) {
                        if (beaconEntry2.isSSH() || beaconEntry2.getPivotHint().isReverse() || !beaconEntry2.isActive()) continue;
                        linkedList7.add(beaconEntry2.getInternal() + " " + beaconEntry2.getPid());
                    }
                    return this.getOptionsFromList(string, linkedList7);
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("mimikatz ")) {
                    LinkedList linkedList8 = new LinkedList(CommonUtils.toList(CommonUtils.readResourceAsString("resources/mimikatz.txt").trim().split("\n")));
                    LinkedList<String> linkedList9 = new LinkedList<String>();
                    Iterator iterator = linkedList8.iterator();
                    while (iterator.hasNext()) {
                        String string5 = (iterator.next() + "").trim();
                        linkedList9.add(string5);
                        linkedList9.add("!" + string5);
                        linkedList9.add("@" + string5);
                    }
                    return this.getOptionsFromList(string, linkedList9);
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("token-store ")) {
                    return this.getOptionsFromList(string, CommonUtils.getTokenStoreCommands());
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("syscall-method ")) {
                    return this.getOptionsFromList(string, Arrays.asList(BeaconSyscallMethod.validSyscalls));
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("data-store load ")) {
                    return this.getOptionsFromList(string, BeaconStoreItemType.getNames());
                }
                if (linkedList != null && linkedList.size() == 0 && string.startsWith("data-store ")) {
                    return this.getOptionsFromList(string, CommonUtils.getDataStoreCommands());
                }
            }
        }
        return linkedList;
    }
}

