/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import common.AssertUtils;
import common.CommonUtils;
import common.Packer;

public class Settings {
    public static final int PATCH_SIZE = 6144;
    public static final int MAX_SETTINGS = 128;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_SHORT = 1;
    public static final int TYPE_INT = 2;
    public static final int TYPE_PTR = 3;
    protected Packer patch;
    protected int patchSize;

    public Settings(int n) {
        this.patchSize = n;
        this.patch = new Packer();
    }

    public void addShort(int n, int n2) {
        AssertUtils.TestRange(n, 0, 128);
        this.patch.addShort(n);
        this.patch.addShort(1);
        this.patch.addShort(2);
        this.patch.addShort(n2);
    }

    public void addInt(int n, int n2) {
        AssertUtils.TestRange(n, 0, 128);
        this.patch.addShort(n);
        this.patch.addShort(2);
        this.patch.addShort(4);
        this.patch.addInt(n2);
    }

    public void addData(int n, byte[] byArray, int n2) {
        AssertUtils.TestRange(n, 0, 128);
        this.patch.addShort(n);
        this.patch.addShort(3);
        this.patch.addShort(n2);
        this.patch.addString(byArray, n2);
    }

    public void addString(int n, String string, int n2) {
        this.addData(n, CommonUtils.toBytes(string), n2);
    }

    public byte[] toPatch() {
        return this.toPatch(this.patchSize);
    }

    public byte[] toPatch(int n) {
        this.patch.addShort(0);
        byte[] byArray = this.patch.getBytes();
        AssertUtils.Test(byArray.length < n, "Patch " + byArray.length + " bytes is too large! Beacon will crash");
        byte[] byArray2 = CommonUtils.randomData(n - byArray.length);
        this.patch.addString(byArray2, byArray2.length);
        return this.patch.getBytes();
    }
}

