/*
 * Decompiled with CFR 0.152.
 */
package c2profile;

import beacon.BeaconPayload;
import c2profile.Profile;
import cloudstrike.Response;
import common.CommonUtils;
import common.License;
import common.MudgeSanity;
import common.SleevedResource;
import common.WebTransforms;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import pe.MalleablePE;
import pe.PEParser;

public class Preview
implements Serializable {
    protected Profile c2profile;
    protected Map characteristics = null;
    protected List notes = new LinkedList();

    public Preview(Profile profile) {
        this.c2profile = profile;
    }

    public String getSampleName() {
        return this.c2profile.getString(".sample_name");
    }

    public void summarize(Map map2) {
        map2.put("c2sample.client", this.getClientSample());
        map2.put("c2sample.server", this.getServerSample());
        map2.put("c2sample.name", this.getSampleName());
        map2.put("c2sample.strings", this.getStrings());
        map2.put("c2sample.pe", this.getPE());
    }

    public void note(String string) {
        this.notes.add(string);
    }

    public Map getPE() {
        if (this.characteristics != null) {
            return this.characteristics;
        }
        byte[] byArray = SleevedResource.readResource("resources/beacon.dll");
        MalleablePE malleablePE = new MalleablePE(this.c2profile);
        boolean bl = true;
        byte[] byArray2 = malleablePE.pre_process(byArray, "x86", bl, null);
        PEParser pEParser = PEParser.load(byArray2);
        this.characteristics = new LinkedHashMap();
        this.characteristics.put("Checksum", pEParser.get("CheckSum"));
        this.characteristics.put("Compilation Timestamp", pEParser.getDate("TimeDateStamp"));
        this.characteristics.put("Entry Point", pEParser.get("AddressOfEntryPoint"));
        this.characteristics.put("Name", pEParser.getString("Export.Name").replaceAll("\\P{Print}", "."));
        this.characteristics.put("Size", pEParser.get("SizeOfImage"));
        this.characteristics.put("Target Machine", "x86");
        if (License.isTrial()) {
            this.note("EICAR strings were observed within this payload and its traffic. This is a clever technique to detect and evade anti-virus products.");
        }
        if (this.c2profile.option(".stage.obfuscate") || this.c2profile.option(".stage.sleep_mask")) {
            this.characteristics.remove("Name");
            if (!this.c2profile.option(".stage.cleanup")) {
                this.note("The final payload DLL is obfuscated in memory.");
                this.note("The package that loads the payload DLL is less obfuscated.");
            } else {
                this.note("The payload DLL obfuscates itself in memory.");
            }
        } else if (this.c2profile.option(".stage.stomppe")) {
            this.note("The payload DLL clears its in-memory MZ, PE, and e_lfanew header values. This is a common obfuscation for memory injected DLLs.");
        }
        if (this.c2profile.option(".stage.userwx")) {
            if ("".equals(this.c2profile.getString(".stage.module_x86"))) {
                this.note("This payload resides in memory pages with RWX permissions. These memory pages are not backed by a file on disk.");
            } else {
                this.note("This payload resides in memory pages with RWX permissions.");
            }
        }
        if (!"".equals(this.c2profile.getString(".stage.module_x86"))) {
            this.note("This payload loads " + this.c2profile.getString(".stage.module_x86") + " and overwrites its location in memory. This hides the payload within memory backed by this legitimate file.");
        }
        if (this.notes.size() > 0) {
            this.characteristics.put("Notes", CommonUtils.join(this.notes, " "));
        }
        return this.characteristics;
    }

    public String getClientSample() {
        return this.getClientSample(".http-get");
    }

    public String getServerSample() {
        return this.getServerSample(".http-get", false);
    }

    public String getStrings() {
        return this.c2profile.getToStringLog(".stage");
    }

    public String getClientSample(String string) {
        String string2;
        Object object2;
        Response response = new Response("200 OK", null, (InputStream)null);
        byte[] byArray = CommonUtils.randomData(16);
        String string3 = "";
        String string4 = "";
        if (string.equals(".http-stager")) {
            string3 = this.c2profile.getString(string + ".uri_x86");
            if ("".equals(string3)) {
                string3 = CommonUtils.MSFURI();
            }
            string4 = "GET";
        } else {
            string3 = CommonUtils.pick(this.c2profile.getString(string + ".uri").split(" "));
            string4 = this.c2profile.getString(string + ".verb");
        }
        if (string.equals(".http-post")) {
            byArray = CommonUtils.toBytes(CommonUtils.rand(99999) + "");
        }
        this.c2profile.apply(string + ".client", response, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = response.params.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            String object3 = object2.getKey() + "";
            string2 = object2.getValue() + "";
            try {
                object2.setValue(URLEncoder.encode(object2.getValue() + "", "UTF-8"));
            }
            catch (Exception exception) {
                MudgeSanity.logException("url encoding: " + object2, exception, false);
            }
            stringBuffer.append(object3 + "=" + string2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("&");
        }
        string3 = stringBuffer.length() > 0 ? string3 + response.uri + "?" + stringBuffer : string3 + response.uri;
        object2 = new StringBuffer();
        ((StringBuffer)object2).append(string4 + " " + string3 + " HTTP/1.1\n");
        if (!response.header.containsKey("User-Agent")) {
            response.header.put("User-Agent", BeaconPayload.randua(this.c2profile));
        }
        for (Map.Entry entry : response.header.entrySet()) {
            string2 = entry.getKey() + "";
            String string5 = entry.getValue() + "";
            entry.setValue(string5.replaceAll("\\P{Graph}", ""));
            ((StringBuffer)object2).append(string2 + ": " + string5 + "\n");
        }
        if (response.data != null) {
            try {
                byte[] byArray3 = new byte[]{};
                byArray3 = new byte[response.data.available()];
                response.data.read(byArray3, 0, byArray3.length);
                ((StringBuffer)object2).append("\n" + CommonUtils.bString(byArray3).replaceAll("\\P{Print}", "."));
                ((StringBuffer)object2).append("\n");
            }
            catch (Exception exception) {
                MudgeSanity.logException("sample generate", exception, false);
            }
        }
        ((StringBuffer)object2).append("\n");
        return ((StringBuffer)object2).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getServerSample(String string, boolean bl) {
        String string2 = "---YelLoW---";
        String string3 = "--BLu3--";
        String string4 = "\u001b[01;33m";
        String string5 = "\u001b[01;34m";
        try {
            void var12_16;
            CharSequence charSequence;
            int n;
            Response response = new Response("200 OK", null, (InputStream)null);
            byte[] byArray = CommonUtils.randomData(64);
            if (".http-post".equals(string)) {
                byArray = new byte[]{};
            }
            if ((n = this.c2profile.getInt(".data_jitter")) > 0 && !".http-stager".equals(string)) {
                charSequence = "(.data_jitter:up.to." + n + ".bytes.of.random.data...)";
                if (bl) {
                    charSequence = string2 + (String)charSequence + string3;
                }
                byArray = CommonUtils.join(byArray, ((String)charSequence).getBytes());
            }
            this.c2profile.apply(string + ".server", response, byArray);
            new WebTransforms(this.c2profile).filterResponse(response);
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("HTTP/1.1 " + response.status + "\n");
            for (Map.Entry object2 : response.header.entrySet()) {
                String string6 = object2.getKey() + "";
                String string7 = object2.getValue() + "";
                object2.setValue(string7.replaceAll("\\P{Graph}", ""));
                ((StringBuffer)charSequence).append(string6 + ": " + string7 + "\n");
            }
            byte[] byArray2 = new byte[]{};
            if (response.data != null) {
                byte[] byArray3 = new byte[response.data.available()];
                response.data.read(byArray3, 0, byArray3.length);
            }
            ((StringBuffer)charSequence).append("\n" + CommonUtils.bString((byte[])var12_16).replaceAll("\\P{Print}", "."));
            return ((StringBuffer)charSequence).toString().replace(string2, string4).replace(string3, string5);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("getServerSample: " + string, iOException, false);
            return "";
        }
    }
}

