/*
 * Decompiled with CFR 0.152.
 */
package c2profile;

import beacon.BeaconPayload;
import c2profile.HostProfile;
import c2profile.Preview;
import c2profile.ProfileVariant;
import c2profile.Program;
import c2profile.SmartBuffer;
import cloudstrike.Response;
import common.CodeSigner;
import common.CommonUtils;
import common.MudgeSanity;
import common.Packer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Profile
implements Serializable {
    protected Map data = new HashMap();
    protected Preview preview = null;
    protected Map datal = new HashMap();
    protected Map variants = new HashMap();

    public String[] getVariants() {
        LinkedList linkedList = new LinkedList(this.variants.keySet());
        Collections.sort(linkedList);
        return CommonUtils.toArray(linkedList);
    }

    public List getHostProfiles() {
        List list = this.getList(".http-host-profiles");
        if (list != null) {
            return list;
        }
        return new LinkedList();
    }

    public HostProfile getHostProfile(String string) {
        List list = this.getHostProfiles();
        for (HostProfile hostProfile : list) {
            if (!string.equals(hostProfile.hostName)) continue;
            return hostProfile;
        }
        return null;
    }

    public void apply_hp_binary(String string, Packer packer) throws IOException {
        HostProfile hostProfile = this.getHostProfile(string);
        if (hostProfile != null) {
            hostProfile.hp_binary(this, packer);
        }
    }

    public Profile getVariantProfile(String string) {
        if (string == null || "".equals(string)) {
            return this;
        }
        if (!this.variants.containsKey(string)) {
            CommonUtils.print_warn("Profile variant '" + string + "' does not exist. Degrading to normal profile state.");
            return this;
        }
        ProfileVariant profileVariant = (ProfileVariant)this.variants.get("default");
        ProfileVariant profileVariant2 = (ProfileVariant)this.variants.get(string);
        Profile profile = new Profile();
        profile.data.putAll(profileVariant.data);
        profile.data.putAll(profileVariant2.data);
        profile.datal.putAll(profileVariant.datal);
        profile.datal.putAll(profileVariant2.datal);
        return profile;
    }

    public void activateVariant(String string) {
        if (!this.variants.containsKey(string)) {
            this.variants.put(string, new ProfileVariant());
        }
        ProfileVariant profileVariant = (ProfileVariant)this.variants.get(string);
        this.data = profileVariant.data;
        this.datal = profileVariant.datal;
    }

    public Profile() {
        this.activateVariant("default");
    }

    public void setList(String string, List list) {
        this.datal.put(string, list);
    }

    public void addList(String string) {
        this.datal.put(string, new LinkedList());
    }

    public void addParameter(String string, Object object) {
        this.data.put(string, object);
    }

    public void logToString(String string, String string2) {
        String string3 = string + ".log.string";
        if (!this.data.containsKey(string3)) {
            this.data.put(string3, new LinkedList());
        }
        LinkedList linkedList = (LinkedList)this.data.get(string3);
        linkedList.add(string2.trim());
    }

    public String getToStringLog(String string) {
        String string2 = string + ".log.string";
        if (!this.data.containsKey(string2)) {
            return null;
        }
        LinkedList linkedList = new LinkedList((LinkedList)this.data.get(string2));
        return CommonUtils.join(linkedList, "\n");
    }

    public void addToString(String string, byte[] byArray) {
        String string2 = string + ".string";
        if (!this.data.containsKey(string2)) {
            this.data.put(string2, new SmartBuffer());
        }
        SmartBuffer smartBuffer = (SmartBuffer)this.data.get(string2);
        smartBuffer.append(byArray);
    }

    public SmartBuffer getToString(String string) {
        String string2 = string + ".string";
        if (!this.data.containsKey(string2)) {
            return new SmartBuffer();
        }
        SmartBuffer smartBuffer = (SmartBuffer)this.data.get(string2);
        return smartBuffer;
    }

    public static boolean usesCookieBeacon(Profile profile) {
        return profile.usesCookie(".http-get.client") || profile.usesCookie(".http-post.client") || profile.usesCookie(".http-get.client.metadata") || profile.usesCookie(".http-post.client.id") || profile.usesCookie(".http-post.client.output");
    }

    public static boolean usesHostBeacon(Profile profile) {
        return profile.usesHost(".http-get.client.metadata") || profile.usesHost(".http-post.client.id") || profile.usesHost(".http-post.client.output");
    }

    public String getSSHPipeName() {
        String string = CommonUtils.pick(this.getString(".ssh_pipename"));
        return CommonUtils.replaceHashes(string);
    }

    public String getPostExPipeName(String string) {
        String string2 = CommonUtils.pick(this.getString(".post-ex.pipename"));
        if ((string2 = CommonUtils.replaceHashes(string2)).length() > string.length()) {
            string2 = string2.substring(0, string.length());
        }
        return CommonUtils.pad(string2, '\u0000', string.length());
    }

    public String getHeadersToRemove(boolean bl) {
        if (CommonUtils.isNullOrEmpty(this.getString(".headers_remove"))) {
            return "";
        }
        String[] stringArray = CommonUtils.toArray(this.getString(".headers_remove"));
        if (stringArray.length == 0) {
            return "";
        }
        if (this.exerciseCFGCaution()) {
            CommonUtils.print_error(".headers_remove is not available when module stomping is on. (Control Flow Guard becomes problematic)");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            if (CommonUtils.isNullOrEmpty(string)) continue;
            stringBuffer.append(string);
            if (bl && !string.endsWith(":")) {
                stringBuffer.append(":");
            }
            stringBuffer.append("\r\n");
        }
        String string = stringBuffer.toString().trim();
        if (string.length() > 63) {
            CommonUtils.print_error(".headers_remove is " + string.length() + " characters in final form. The max is 63 characters. Please trim!");
            return "";
        }
        return string;
    }

    public boolean usesCookie(String string) {
        Program program = this.getProgram(string);
        return program != null && program.usesCookie();
    }

    public boolean usesHost(String string) {
        Program program = this.getProgram(string);
        return program != null && program.usesHost();
    }

    public boolean isSealed(String string) {
        Program program = this.getProgram(string);
        return program != null && program.isSealed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preview getPreview() {
        Profile profile = this;
        synchronized (profile) {
            if (this.preview == null) {
                this.preview = new Preview(this);
            }
            return this.preview;
        }
    }

    public void addCommand(String string, String string2, String string3) {
        if (this.datal.containsKey(string)) {
            LinkedList linkedList = (LinkedList)this.datal.get(string);
            if (string3 == null) {
                linkedList.add(string2);
            } else {
                linkedList.add(string2 + " " + string3);
            }
            return;
        }
        if (!this.data.containsKey(string)) {
            this.data.put(string, new Program());
        }
        Program program = this.getProgram(string);
        program.addStep(string2, string3);
    }

    public void addCommand(String string, String string2, String string3, String string4) {
        if (!this.data.containsKey(string)) {
            this.data.put(string, new Program());
        }
        Program program = this.getProgram(string);
        program.addStep(string2, string3, string4);
    }

    public void addCommand(String string, String string2, String string3, String string4, String string5) {
        if (!this.data.containsKey(string)) {
            this.data.put(string, new Program());
        }
        Program program = this.getProgram(string);
        program.addStep(string2, string3, string4, string5);
    }

    public void apply(String string, Response response, byte[] byArray) {
        Program program = this.getProgram(string);
        if (program != null) {
            program.transform(this, response, byArray);
        }
    }

    public String recover(String string, Map map2, Map map3, String string2, String string3) {
        Program program = this.getProgram(string);
        return program.recover(map2, map3, string2, string3);
    }

    public Program getProgram(String string) {
        return (Program)this.data.get(string);
    }

    public byte[] apply_binary(String string) throws IOException {
        Program program = this.getProgram(string);
        return program.transform_binary(this);
    }

    public byte[] recover_binary(String string) throws IOException {
        Program program = this.getProgram(string);
        return program.recover_binary();
    }

    public int size(String string, int n) throws IOException {
        byte[] byArray = new byte[n];
        Response response = new Response("200 OK", null, (InputStream)null);
        this.apply(string, response, byArray);
        if (response.data != null) {
            return response.data.available();
        }
        return 0;
    }

    public boolean hasString(String string) {
        return this.data.containsKey(string);
    }

    public boolean isEmptyString(String string) {
        if (!this.hasString(string)) {
            return true;
        }
        return this.getString(string).length() == 0;
    }

    public List getList(String string) {
        return (LinkedList)this.datal.get(string);
    }

    public String getString(String string) {
        return this.data.get(string) + "";
    }

    public byte[] getStringAsBytes(String string) {
        String string2 = (String)this.data.get(string);
        if (string2 == null || "".equals(string2)) {
            return new byte[0];
        }
        return CommonUtils.toBytes(string2);
    }

    public SleepAndJitter getSleep(boolean bl) {
        Object object;
        SleepAndJitter sleepAndJitter = null;
        if (this.hasString(".sleep")) {
            object = this.getString(".sleep");
            if (object != null && !((String)object).isEmpty() && !((String)object).equalsIgnoreCase("null")) {
                CommonUtils.SleepValues sleepValues = CommonUtils.parseSleepArgs((String)object);
                if (sleepValues != null) {
                    sleepAndJitter = new SleepAndJitter(sleepValues);
                } else {
                    CommonUtils.print_error("Failed to parse .sleep from profile:\n");
                }
            }
        } else if (this.hasString(".sleeptime") && this.hasString(".jitter")) {
            try {
                int n = this.getInt(".sleeptime");
                int n2 = this.getInt(".jitter");
                sleepAndJitter = new SleepAndJitter(n, n2);
            }
            catch (Exception exception) {
                CommonUtils.print_error("Failed to parse .sleeptime and .jitter from profile:\n\t" + exception.getMessage());
            }
        }
        object = CommonUtils.SleepValues.DefaultSleepValue();
        if (sleepAndJitter == null) {
            if (bl) {
                sleepAndJitter = new SleepAndJitter((CommonUtils.SleepValues)object);
                CommonUtils.print_warn("Using default sleep and jitter. " + sleepAndJitter.SleepInMilliseconds + " milliseconds " + sleepAndJitter.Jitter + "%");
            } else {
                CommonUtils.print_error("Failed to parse '.sleep', '.sleeptime' and '.jitter' from profile");
            }
        } else {
            if (sleepAndJitter.SleepInMilliseconds < 0) {
                CommonUtils.print_error("Invalid sleep value of " + sleepAndJitter.SleepInMilliseconds + " milliseconds. Using default sleep value of " + ((CommonUtils.SleepValues)object).getSleepInMilliseconds() + " milliseconds.");
                sleepAndJitter.SleepInMilliseconds = ((CommonUtils.SleepValues)object).getSleepInMilliseconds();
            }
            if (sleepAndJitter.Jitter < 0 || sleepAndJitter.Jitter > 99) {
                CommonUtils.print_error("Invalid jitter value of " + sleepAndJitter.Jitter + "%. Using default jitter value of " + ((CommonUtils.SleepValues)object).Jitter + "%.");
                sleepAndJitter.Jitter = ((CommonUtils.SleepValues)object).Jitter;
            }
        }
        return sleepAndJitter;
    }

    public boolean option(String string) {
        return this.getString(string).equals("true");
    }

    public byte[] getByteArray(String string) {
        return (byte[])this.data.get(string);
    }

    public File getFile(String string) {
        return new File(this.getString(string));
    }

    public CodeSigner getCodeSigner() {
        return new CodeSigner(this);
    }

    public boolean isFile(String string) {
        if ("".equals(this.getString(string))) {
            return false;
        }
        return this.getFile(string).exists();
    }

    public boolean posts(String string) {
        Program program = this.getProgram(string);
        if (program == null) {
            return false;
        }
        return program.postsData();
    }

    public boolean shouldChunkPosts() {
        return !this.posts(".http-post.client.output");
    }

    public boolean exerciseCFGCaution() {
        return !"".equals(this.getString(".stage.module_x86")) || !"".equals(this.getString(".stage.module_x64"));
    }

    public int getInt(String string) {
        return Integer.parseInt(this.getString(string));
    }

    protected String certDescription() {
        return "CN=" + this.getString(".https-certificate.CN") + ", OU=" + this.getString(".https-certificate.OU") + ", O=" + this.getString(".https-certificate.O") + ", L=" + this.getString(".https-certificate.L") + ", ST=" + this.getString(".https-certificate.ST") + ", C=" + this.getString(".https-certificate.C");
    }

    public boolean regenerateKeystore() {
        return !"CN=, OU=, O=, L=, ST=, C=".equals(this.certDescription()) || this.getInt(".https-certificate.validity") != 3650;
    }

    public String getSSLPassword() {
        return this.getString(".https-certificate.password");
    }

    public boolean hasValidSSL() {
        return this.isFile(".https-certificate.keystore");
    }

    public InputStream getSSLKeystore() {
        try {
            if (this.isFile(".https-certificate.keystore")) {
                return new FileInputStream(this.getFile(".https-certificate.keystore"));
            }
            if (!this.regenerateKeystore()) {
                return null;
            }
            File file = new File("./ssl" + System.currentTimeMillis() + ".store");
            file.deleteOnExit();
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("keytool");
            linkedList.add("-keystore");
            linkedList.add(file.getAbsolutePath());
            linkedList.add("-storepass");
            linkedList.add("123456");
            linkedList.add("-keypass");
            linkedList.add("123456");
            linkedList.add("-genkey");
            linkedList.add("-keyalg");
            linkedList.add("RSA");
            linkedList.add("-alias");
            linkedList.add("cobaltstrike");
            linkedList.add("-dname");
            linkedList.add(this.certDescription());
            linkedList.add("-validity");
            linkedList.add(this.getString(".https-certificate.validity"));
            ProcessBuilder processBuilder = new ProcessBuilder(linkedList);
            processBuilder.inheritIO();
            Process process = processBuilder.start();
            process.waitFor();
            return new FileInputStream(file);
        }
        catch (Exception exception) {
            CommonUtils.print_error("SSL certificate generation failed:\n\t" + exception.getMessage());
            return null;
        }
    }

    public byte[] getPrependedData(String string) {
        Program program = this.getProgram(string);
        if (program == null) {
            return new byte[0];
        }
        return program.getPrependedData();
    }

    public byte[] getAppendedData(String string) {
        Program program = this.getProgram(string);
        if (program == null) {
            return new byte[0];
        }
        return program.getAppendedData();
    }

    public long getHTTPContentOffset(String string) {
        Response response = new Response("200 OK", null, (InputStream)null);
        byte[] byArray = CommonUtils.randomData(16);
        this.apply(string, response, byArray);
        return response.offset;
    }

    public Map getHeadersAsMap(String string) {
        Response response = new Response("200 OK", null, (InputStream)null);
        this.apply(string, response, new byte[0]);
        return response.header;
    }

    protected boolean hasHeader(Map map2, String string) {
        for (String string2 : map2.keySet()) {
            if (!string.toLowerCase().equals(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String getHeaders(String string, String string2) {
        Response response = new Response("200 OK", null, (InputStream)null);
        byte[] byArray = CommonUtils.randomData(16);
        this.apply(string, response, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.hasHeader(response.header, "User-Agent")) {
            response.header.put("User-Agent", BeaconPayload.randua(this));
        }
        if (!"".equals(string2) && !this.hasHeader(response.header, "Host")) {
            response.header.put("Host", string2);
        }
        for (Map.Entry entry : response.header.entrySet()) {
            String string3 = entry.getKey() + "";
            String string4 = entry.getValue() + "";
            if (!"".equals(string2) && string3.toLowerCase().equals("host")) {
                stringBuffer.append(string3 + ": " + string2 + "\r\n");
                continue;
            }
            stringBuffer.append(string3 + ": " + string4 + "\r\n");
        }
        return stringBuffer.toString();
    }

    public String getQueryString(String string) {
        Response response = new Response("200 OK", null, (InputStream)null);
        byte[] byArray = CommonUtils.randomData(16);
        this.apply(string, response, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = response.params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = entry.getKey() + "";
            String string3 = entry.getValue() + "";
            try {
                entry.setValue(URLEncoder.encode(entry.getValue() + "", "UTF-8"));
            }
            catch (Exception exception) {
                MudgeSanity.logException("url encoding: " + entry, exception, false);
            }
            stringBuffer.append(string2 + "=" + string3);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("&");
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return "?" + stringBuffer;
    }

    public class SleepAndJitter {
        public int SleepInMilliseconds;
        public int Jitter;

        public SleepAndJitter(int n, int n2) {
            this.SleepInMilliseconds = n;
            this.Jitter = n2;
        }

        public SleepAndJitter(CommonUtils.SleepValues sleepValues) {
            this.SleepInMilliseconds = sleepValues.getSleepInMilliseconds();
            this.Jitter = sleepValues.Jitter;
        }
    }
}

