/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.state;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.rfb.protocol.auth.AuthHandler;
import com.glavsoft.rfb.protocol.state.AuthenticationState;
import com.glavsoft.rfb.protocol.state.SecurityType37State;

public class SecurityType33State
extends SecurityType37State {
    public SecurityType33State(ProtocolContext context) {
        super(context);
    }

    @Override
    protected void negotiateAboutSecurityType() throws TransportException, UnsupportedSecurityTypeException {
        this.logger.info("Get Security Type");
        int type = this.reader.readInt32();
        this.logger.info("Type received: " + type);
        if (0 == type) {
            throw new UnsupportedSecurityTypeException(this.reader.readString());
        }
        AuthHandler typeSelected = SecurityType33State.selectAuthHandler(new byte[]{(byte)(0xFF & type)}, this.context.getSettings().authCapabilities);
        if (typeSelected == null) {
            throw new UnsupportedSecurityTypeException("No security types supported. Server sent '" + type + "' security type, but we do not support it.");
        }
        this.setUseSecurityResult(typeSelected);
        this.logger.info("Type accepted: " + typeSelected.getName());
        this.changeStateTo(new AuthenticationState(this.context, typeSelected));
    }
}

