/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public class Utils {
    private static List<Image> icons;

    private static List<Image> getApplicationIcons() {
        Image image;
        if (icons != null) {
            return icons;
        }
        icons = new LinkedList<Image>();
        URL resource = Utils.class.getResource("/com/glavsoft/viewer/images/tightvnc-logo-16x16.png");
        Image image2 = image = resource != null ? Toolkit.getDefaultToolkit().getImage(resource) : null;
        if (image != null) {
            icons.add(image);
        }
        Image image3 = image = (resource = Utils.class.getResource("/com/glavsoft/viewer/images/tightvnc-logo-32x32.png")) != null ? Toolkit.getDefaultToolkit().getImage(resource) : null;
        if (image != null) {
            icons.add(image);
        }
        return icons;
    }

    public static ImageIcon getButtonIcon(String name) {
        URL resource = Utils.class.getResource("/com/glavsoft/viewer/images/button-" + name + ".png");
        return resource != null ? new ImageIcon(resource) : null;
    }

    public static void decorateDialog(JDialog dialog) {
        try {
            dialog.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        dialog.pack();
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.toFront();
        Utils.setApplicationIconsForWindow(dialog);
    }

    public static void setApplicationIconsForWindow(Window window) {
        List<Image> icons = Utils.getApplicationIcons();
        if (icons.size() != 0) {
            window.setIconImages(icons);
        }
    }

    public static void centerWindow(Window window) {
        Point locationPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Rectangle bounds = window.getBounds();
        locationPoint.setLocation(locationPoint.x - bounds.width / 2, locationPoint.y - bounds.height / 2);
        window.setLocation(locationPoint);
    }
}

