/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.swing.ConnectionParams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ConnectionsHistory
implements IChangeSettingsListener {
    private static int MAX_ITEMS = 32;
    public static final String CONNECTIONS_HISTORY_ROOT_NODE = "com/glavsoft/viewer/connectionsHistory";
    public static final String NODE_HOST_NAME = "hostName";
    public static final String NODE_PORT_NUMBER = "portNumber";
    public static final String NODE_SSH_USER_NAME = "sshUserName";
    public static final String NODE_SSH_HOST_NAME = "sshHostName";
    public static final String NODE_SSH_PORT_NUMBER = "sshPortNumber";
    public static final String NODE_USE_SSH = "useSsh";
    public static final String NODE_PROTOCOL_SETTINGS = "protocolSettings";
    private Map<ConnectionParams, ProtocolSettings> settingsMap;
    LinkedList<ConnectionParams> connections;
    private ConnectionParams workingConnectionParams;

    public ConnectionsHistory(ConnectionParams workingConnectionParams) {
        this.workingConnectionParams = workingConnectionParams;
        this.settingsMap = new HashMap<ConnectionParams, ProtocolSettings>();
        this.connections = new LinkedList();
        this.retrieve();
    }

    private void retrieve() {
        Preferences root = Preferences.userRoot();
        Preferences connectionsHistoryNode = root.node(CONNECTIONS_HISTORY_ROOT_NODE);
        try {
            byte[] emptyByteArray = new byte[]{};
            String[] orderNums = connectionsHistoryNode.childrenNames();
            TreeMap<Integer, ConnectionParams> conns = new TreeMap<Integer, ConnectionParams>();
            HashSet<ConnectionParams> uniques = new HashSet<ConnectionParams>();
            for (String orderNum : orderNums) {
                ConnectionParams cp;
                int num = 0;
                try {
                    num = Integer.parseInt(orderNum);
                }
                catch (NumberFormatException skip) {
                    // empty catch block
                }
                Preferences node = connectionsHistoryNode.node(orderNum);
                String hostName = node.get(NODE_HOST_NAME, null);
                if (null == hostName || uniques.contains(cp = new ConnectionParams(hostName, node.getInt(NODE_PORT_NUMBER, 0), node.getBoolean(NODE_USE_SSH, false), node.get(NODE_SSH_HOST_NAME, ""), node.getInt(NODE_SSH_PORT_NUMBER, 0), node.get(NODE_SSH_USER_NAME, "")))) continue;
                uniques.add(cp);
                conns.put(num, cp);
                byte[] bytes = node.getByteArray(NODE_PROTOCOL_SETTINGS, emptyByteArray);
                if (bytes.length == 0) continue;
                try {
                    ProtocolSettings settings = (ProtocolSettings)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
                    settings.refine();
                    this.settingsMap.put(cp, settings);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).fine("Cannot deserialize ProtocolSettings: " + e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger(this.getClass().getName()).severe("Cannot deserialize ProtocolSettings : " + e.getMessage());
                }
            }
            int itemsCount = 0;
            for (ConnectionParams cp : conns.values()) {
                if (itemsCount < MAX_ITEMS) {
                    this.connections.add(cp);
                } else {
                    connectionsHistoryNode.node(cp.hostName).removeNode();
                }
                ++itemsCount;
            }
        }
        catch (BackingStoreException e) {
            Logger.getLogger(this.getClass().getName()).severe("Cannot retrieve connections history info: " + e.getMessage());
        }
    }

    public LinkedList<ConnectionParams> getConnectionsList() {
        return this.connections;
    }

    public ProtocolSettings getSettings(ConnectionParams cp) {
        return this.settingsMap.get(cp);
    }

    public void save() {
        Preferences root = Preferences.userRoot();
        Preferences connectionsHistoryNode = root.node(CONNECTIONS_HISTORY_ROOT_NODE);
        try {
            String[] hosts;
            for (String host : hosts = connectionsHistoryNode.childrenNames()) {
                connectionsHistoryNode.node(host).removeNode();
            }
        }
        catch (BackingStoreException e) {
            Logger.getLogger(this.getClass().getName()).severe("Cannot remove node: " + e.getMessage());
        }
        int num = 0;
        for (ConnectionParams cp : this.connections) {
            if (num >= MAX_ITEMS) break;
            if (Strings.isTrimmedEmpty(cp.hostName)) continue;
            this.addNode(cp, connectionsHistoryNode, num++);
        }
    }

    private void addNode(ConnectionParams connectionParams, Preferences connectionsHistoryNode, int orderNum) {
        ProtocolSettings settings = this.settingsMap.get(connectionParams);
        Preferences node = connectionsHistoryNode.node(String.valueOf(orderNum));
        node.put(NODE_HOST_NAME, connectionParams.hostName);
        node.putInt(NODE_PORT_NUMBER, connectionParams.getPortNumber());
        if (connectionParams.useSsh()) {
            node.putBoolean(NODE_USE_SSH, connectionParams.useSsh());
            node.put(NODE_SSH_USER_NAME, connectionParams.sshUserName != null ? connectionParams.sshUserName : "");
            node.put(NODE_SSH_HOST_NAME, connectionParams.sshHostName != null ? connectionParams.sshHostName : "");
            node.putInt(NODE_SSH_PORT_NUMBER, connectionParams.getSshPortNumber());
        }
        if (settings != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(settings);
                node.putByteArray(NODE_PROTOCOL_SETTINGS, byteArrayOutputStream.toByteArray());
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).severe("Cannot serialize ProtocolSettings: " + e.getMessage());
            }
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            Logger.getLogger(this.getClass().getName()).severe("Cannot retrieve connections history info: " + e.getMessage());
        }
    }

    void reorderConnectionsList(ConnectionParams connectionParams, ProtocolSettings settings) {
        while (this.connections.remove(connectionParams)) {
        }
        LinkedList<ConnectionParams> cpList = new LinkedList<ConnectionParams>();
        cpList.addAll(this.connections);
        this.connections.clear();
        this.connections.add(new ConnectionParams(connectionParams));
        this.connections.addAll(cpList);
        this.storeSettings(connectionParams, settings);
    }

    private void storeSettings(ConnectionParams connectionParams, ProtocolSettings settings) {
        ProtocolSettings savedSettings = this.settingsMap.get(connectionParams);
        if (savedSettings != null) {
            savedSettings.copySerializedFieldsFrom(settings);
        } else {
            this.settingsMap.put(new ConnectionParams(connectionParams), new ProtocolSettings(settings));
        }
    }

    public ConnectionParams getMostSuitableConnection(ConnectionParams orig) {
        ConnectionParams res;
        ConnectionParams connectionParams = res = this.connections.isEmpty() ? orig : this.connections.get(0);
        if (null == orig || null == orig.hostName) {
            return res;
        }
        for (ConnectionParams cp : this.connections) {
            if (orig.equals(cp)) {
                return cp;
            }
            if (this.compareTextFields(orig.hostName, res.hostName, cp.hostName)) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && this.comparePorts(orig.getPortNumber(), res.getPortNumber(), cp.getPortNumber())) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && orig.getPortNumber() == cp.getPortNumber() && orig.useSsh() == cp.useSsh() && orig.useSsh() != res.useSsh()) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && orig.getPortNumber() == cp.getPortNumber() && orig.useSsh() && cp.useSsh() && this.compareTextFields(orig.sshHostName, res.sshHostName, cp.sshHostName)) {
                res = cp;
                continue;
            }
            if (orig.hostName.equals(cp.hostName) && orig.getPortNumber() == cp.getPortNumber() && orig.useSsh() && cp.useSsh() && orig.sshHostName != null && orig.sshHostName.equals(cp.hostName) && this.comparePorts(orig.getSshPortNumber(), res.getSshPortNumber(), cp.getSshPortNumber())) {
                res = cp;
                continue;
            }
            if (!orig.hostName.equals(cp.hostName) || orig.getPortNumber() != cp.getPortNumber() || !orig.useSsh() || !cp.useSsh() || orig.sshHostName == null || !orig.sshHostName.equals(cp.hostName) || orig.getSshPortNumber() != cp.getSshPortNumber() || !this.compareTextFields(orig.sshUserName, res.sshUserName, cp.sshUserName)) continue;
            res = cp;
        }
        return res;
    }

    private boolean comparePorts(int orig, int res, int test) {
        return orig == test && orig != res;
    }

    private boolean compareTextFields(String orig, String res, String test) {
        return orig != null && test != null && res != null && orig.equals(test) && !orig.equals(res);
    }

    @Override
    public void settingsChanged(SettingsChangedEvent event) {
        this.storeSettings(this.workingConnectionParams, (ProtocolSettings)event.getSource());
        this.save();
    }
}

