/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter;

import com.xmlmind.fo.converter.Translator;
import com.xmlmind.fo.objects.Flow;
import com.xmlmind.fo.objects.Fo;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.TableCell;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Property;
import com.xmlmind.fo.properties.PropertyValues;
import com.xmlmind.fo.properties.Value;
import java.util.Hashtable;
import java.util.Vector;

public final class Context
implements Cloneable {
    public int fo = -1;
    public PropertyValues properties;
    public Value lineHeight;
    public int breakBefore;
    public Vector spaceSequence;
    public Color background;
    public TextDecoration textDecoration = new TextDecoration();
    public Translator translator;
    public int screenResolution;
    public PageSequence pageSequence;
    public Flow flow;
    public Hashtable tableColumns;
    public TableCell tableCell;
    private Vector stack = new Vector();

    public Context startElement(int n, PropertyValues propertyValues) {
        Context context;
        this.stack.addElement(this);
        try {
            context = (Context)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        context.fo = n;
        context.properties = propertyValues;
        switch (n) {
            case 10: 
            case 23: 
            case 44: 
            case 49: 
            case 54: {
                context.breakBefore = 0;
                context.spaceSequence = null;
            }
        }
        return context;
    }

    public void update() {
        Property property = Property.list[164];
        Value value = this.properties.values[164];
        if ((value = property.compute(value, this)) != null) {
            this.lineHeight = value;
        }
        if (Fo.isBlock(this.fo)) {
            int n = this.properties.breakBefore();
            if (n > this.breakBefore) {
                this.breakBefore = n;
            }
            if (this.spaceSequence == null) {
                this.spaceSequence = new Vector();
            }
            this.spaceSequence.addElement(new Space(252, this.properties.values));
        } else {
            switch (this.fo) {
                case 48: {
                    Context context = this.parent();
                    int n = context.properties.captionSide();
                    if (n == 1) {
                        context.breakBefore = 0;
                        context.spaceSequence = null;
                        break;
                    }
                    this.breakBefore = 0;
                    this.spaceSequence = null;
                }
            }
        }
        Color color = this.properties.backgroundColor();
        if (color != null) {
            this.background = color;
        }
        if (this.properties.isSpecified(292)) {
            this.textDecoration = this.textDecoration.copy();
            this.textDecoration.update(this.properties.values);
        }
    }

    public void characters(String string) {
        if (string.length() == 1 && string.charAt(0) == ' ') {
            return;
        }
        this.breakBefore = 0;
        this.spaceSequence = null;
    }

    public Context endElement() {
        Context context;
        int n = this.stack.size();
        if (n > 0) {
            context = (Context)this.stack.lastElement();
            this.stack.removeElementAt(n - 1);
            if (Fo.isBlock(this.fo)) {
                int n2 = this.properties.breakAfter();
                if (n2 > this.breakBefore) {
                    this.breakBefore = n2;
                }
                context.breakBefore = this.breakBefore;
                if (this.spaceSequence == null) {
                    this.spaceSequence = new Vector();
                }
                this.spaceSequence.addElement(new Space(246, this.properties.values));
                context.spaceSequence = this.spaceSequence;
            } else {
                switch (this.fo) {
                    case 23: 
                    case 48: {
                        break;
                    }
                    case 21: {
                        context.breakBefore = this.breakBefore;
                        context.spaceSequence = this.spaceSequence;
                        break;
                    }
                    default: {
                        context.breakBefore = 0;
                        context.spaceSequence = null;
                        break;
                    }
                }
            }
        } else {
            context = this;
        }
        return context;
    }

    public Context parent() {
        if (this.stack.size() > 0) {
            return (Context)this.stack.lastElement();
        }
        return null;
    }

    public Context ancestor(int n) {
        Context context = null;
        for (int i = this.stack.size() - 1; i > 0; --i) {
            Context context2 = (Context)this.stack.elementAt(i);
            if (context2.fo != n) continue;
            context = context2;
            break;
        }
        return context;
    }

    public Context block() {
        Context context = null;
        if (Fo.isBlock(this.fo)) {
            return this;
        }
        for (int i = this.stack.size() - 1; i > 0; --i) {
            Context context2 = (Context)this.stack.elementAt(i);
            if (!Fo.isBlock(context2.fo)) continue;
            context = context2;
            break;
        }
        return context;
    }

    public Value nearestSpecifiedValue(int n) {
        Value value = null;
        for (int i = this.stack.size() - 1; i > 0; --i) {
            Context context = (Context)this.stack.elementAt(i);
            if (!context.properties.isSpecified(n)) continue;
            if (n == 164) {
                value = context.lineHeight;
                break;
            }
            value = context.properties.values[n];
            break;
        }
        return value;
    }

    public double spaceBefore() {
        int n;
        double d = 0.0;
        boolean bl = false;
        if (this.spaceSequence == null || this.spaceSequence.size() == 0) {
            return 0.0;
        }
        Object[] objectArray = new Space[this.spaceSequence.size()];
        this.spaceSequence.copyInto(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            if (!((Space)objectArray[n]).force) continue;
            d += ((Space)objectArray[n]).optimum;
            bl = true;
        }
        if (!bl) {
            int n2;
            n = Integer.MIN_VALUE;
            double d2 = Double.NEGATIVE_INFINITY;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (((Space)objectArray[n2]).precedence <= n) continue;
                n = ((Space)objectArray[n2]).precedence;
            }
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (((Space)objectArray[n2]).precedence != n || !(((Space)objectArray[n2]).optimum > d2)) continue;
                d2 = ((Space)objectArray[n2]).optimum;
            }
            d = d2;
        }
        return d;
    }

    public double fontSize() {
        return this.properties.fontSize();
    }

    public double lineHeight() {
        double d = this.fontSize();
        Value value = this.lineHeight;
        if (value.type == 9) {
            Value[] valueArray = value.space();
            value = valueArray[1];
        }
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    public int bpDirection() {
        return this.properties.bpDirection();
    }

    public int ipDirection() {
        return this.properties.ipDirection();
    }

    public int linefeedTreatment() {
        return this.properties.linefeedTreatment();
    }

    public int whiteSpaceTreatment() {
        return this.properties.whiteSpaceTreatment();
    }

    public boolean whiteSpaceCollapse() {
        return this.properties.whiteSpaceCollapse();
    }

    public boolean charDataAllowed() {
        int n = this.fo;
        if (n < 0) {
            return false;
        }
        if (n == 55) {
            for (int i = this.stack.size() - 1; i > 0; --i) {
                Context context = (Context)this.stack.elementAt(i);
                if (context.fo == 55) continue;
                n = context.fo;
                break;
            }
        }
        return Fo.charDataAllowed(n);
    }

    public static class Space {
        public double minimum;
        public double optimum;
        public double maximum;
        public boolean retain;
        public boolean force;
        public int precedence;

        public Space(int n, Value[] valueArray) {
            String string = Property.name(n);
            Value value = valueArray[Property.index(string + ".minimum")];
            this.minimum = value.length();
            value = valueArray[Property.index(string + ".optimum")];
            this.optimum = value.length();
            value = valueArray[Property.index(string + ".maximum")];
            this.maximum = value.length();
            value = valueArray[Property.index(string + ".conditionality")];
            if (value.keyword() == 163) {
                this.retain = true;
            }
            value = valueArray[Property.index(string + ".precedence")];
            if (value.type == 1) {
                this.force = true;
            } else {
                this.precedence = value.integer();
            }
        }
    }

    public static class TextDecoration
    implements Cloneable {
        public boolean underline;
        public boolean overline;
        public boolean lineThrough;
        public boolean blink;
        public Color color;

        public void update(Value[] valueArray) {
            Value value = valueArray[292];
            Value[] valueArray2 = value.type == 27 ? value.list() : new Value[]{value};
            block11: for (int i = 0; i < valueArray2.length; ++i) {
                switch (valueArray2[i].keyword()) {
                    case 125: {
                        this.clear();
                        continue block11;
                    }
                    case 213: {
                        this.underline = true;
                        continue block11;
                    }
                    case 137: {
                        this.underline = false;
                        continue block11;
                    }
                    case 145: {
                        this.overline = true;
                        continue block11;
                    }
                    case 135: {
                        this.overline = false;
                        continue block11;
                    }
                    case 107: {
                        this.lineThrough = true;
                        continue block11;
                    }
                    case 134: {
                        this.lineThrough = false;
                        continue block11;
                    }
                    case 22: {
                        this.blink = true;
                        continue block11;
                    }
                    case 130: {
                        this.blink = false;
                    }
                }
            }
            if (this.color == null) {
                this.color = valueArray[78].color();
            }
        }

        private void clear() {
            this.underline = false;
            this.overline = false;
            this.lineThrough = false;
            this.blink = false;
        }

        public TextDecoration copy() {
            try {
                return (TextDecoration)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

