/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.ConverterGraphicEnv;
import com.xmlmind.fo.converter.ErrorHandler;
import com.xmlmind.fo.converter.GraphicLayout;
import com.xmlmind.fo.converter.OutputDestination;
import com.xmlmind.fo.converter.Product;
import com.xmlmind.fo.converter.Translator;
import com.xmlmind.fo.converter.UriResolver;
import com.xmlmind.fo.converter.docx.DocxTranslator;
import com.xmlmind.fo.converter.odt.OdtTranslator;
import com.xmlmind.fo.converter.rtf.RtfTranslator;
import com.xmlmind.fo.converter.wml.WmlTranslator;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactories;
import com.xmlmind.fo.graphic.GraphicImpl;
import com.xmlmind.fo.graphic.MissingGraphic;
import com.xmlmind.fo.objects.ExternalGraphic;
import com.xmlmind.fo.objects.Flow;
import com.xmlmind.fo.objects.Fo;
import com.xmlmind.fo.objects.PageMasterReference;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.PageSequenceMaster;
import com.xmlmind.fo.objects.Region;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.objects.TableCell;
import com.xmlmind.fo.objects.TableColumn;
import com.xmlmind.fo.properties.Keyword;
import com.xmlmind.fo.properties.Property;
import com.xmlmind.fo.properties.PropertyValues;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.properties.compound.Compound;
import com.xmlmind.fo.properties.shorthand.Shorthand;
import com.xmlmind.fo.util.URLUtil;
import com.xmlmind.fo.util.XMLWriter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Converter
extends DefaultHandler
implements ErrorHandler,
UriResolver,
Translator.UriResolver {
    private static final String DEFAULT_FORMAT = "rtf";
    private static final String FO_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Format";
    private static final String SAX_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String SAX_FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private Translator translator;
    private InputSource input;
    private OutputDestination output;
    private Properties properties = new Properties();
    private ErrorHandler errorHandler = this;
    private UriResolver uriResolver = this;
    private XMLReader reader;
    private ConverterGraphicEnv graphicEnv;
    private Locator locator;
    private Vector pageMasters;
    private Vector pageSequenceMasters;
    private Context context;
    private StringBuffer charDataBuffer;
    private Table table;
    private Vector tables;
    private boolean foreignContent;
    private int foreignContentLevel;
    private boolean skipUnknownContent;
    private XMLWriter copiedContent;
    private Value[] copiedContentProperties;

    public Converter() {
        Product.checkVersion();
    }

    public static String[] listEncodings(String string) throws IllegalArgumentException {
        if ((string = string.toLowerCase()).equals(DEFAULT_FORMAT)) {
            return RtfTranslator.listEncodings();
        }
        if (string.equals("wml")) {
            return WmlTranslator.listEncodings();
        }
        if (string.equals("docx")) {
            return DocxTranslator.listEncodings();
        }
        if (string.equals("odt")) {
            return OdtTranslator.listEncodings();
        }
        throw new IllegalArgumentException("bad output format \"" + string + "\"");
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, string2);
        }
    }

    public void setProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler != null ? errorHandler : this;
    }

    public void setUriResolver(UriResolver uriResolver) {
        this.uriResolver = uriResolver != null ? uriResolver : this;
    }

    public UriResolver getUriResolver() {
        if (this.uriResolver != this) {
            return this.uriResolver;
        }
        return null;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.reader = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.reader;
    }

    protected void setOutput(OutputDestination outputDestination) {
        this.output = outputDestination;
    }

    public void convert(InputSource inputSource, OutputDestination outputDestination) throws Exception {
        this.input = inputSource;
        this.output = outputDestination;
        try {
            if (this.reader != null) {
                this.reader.setContentHandler(this);
                this.reader.setErrorHandler(this);
                this.reader.setFeature(SAX_FEATURE_NAMESPACES, true);
                this.reader.setFeature(SAX_FEATURE_NAMESPACE_PREFIXES, false);
                this.reader.parse(inputSource);
            } else {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse(inputSource, (DefaultHandler)this);
            }
        }
        catch (Exception exception) {
            Exception exception2;
            SAXException sAXException;
            Exception exception3;
            this.abort();
            if (exception instanceof SAXException && (exception3 = (sAXException = (SAXException)exception).getException()) != null) {
                exception2 = exception3;
            }
            this.errorHandler.error(exception2);
        }
    }

    protected void abort() {
        try {
            this.translator.abort();
            this.clean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void clean() throws Exception {
        if (this.graphicEnv != null) {
            this.graphicEnv.dispose();
            this.graphicEnv = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    public void startDocument() throws SAXException {
        String string = this.properties.getProperty("outputFormat");
        string = string == null ? DEFAULT_FORMAT : string.toLowerCase();
        if (string.equals(DEFAULT_FORMAT)) {
            this.translator = new RtfTranslator();
        } else if (string.equals("wml")) {
            this.translator = new WmlTranslator();
        } else if (string.equals("docx")) {
            this.translator = new DocxTranslator();
        } else if (string.equals("odt")) {
            this.translator = new OdtTranslator();
        } else {
            throw new SAXException("bad output format \"" + string + "\"");
        }
        if (this.output == null) {
            throw new SAXException("no output specified");
        }
        if ((string.equals("odt") || string.equals("docx")) && this.output.getByteStream() == null && this.output.getFileName() == null) {
            throw new SAXException("output type not suitable for output format");
        }
        this.translator.setOutput(this.output);
        this.translator.setProperties(this.properties);
        this.translator.setErrorHandler(this.errorHandler);
        this.translator.setUriResolver(this);
        this.graphicEnv = new ConverterGraphicEnv(this.errorHandler);
        this.pageMasters = new Vector();
        this.pageSequenceMasters = new Vector();
        this.context = new Context();
        this.context.translator = this.translator;
        this.context.screenResolution = GraphicLayout.getResolutionProperty(this.properties, "screenResolution", 96);
        this.charDataBuffer = null;
        this.table = null;
        this.tables = new Vector();
        this.foreignContent = false;
        this.foreignContentLevel = 0;
        this.skipUnknownContent = false;
        this.copiedContent = null;
        this.copiedContentProperties = null;
        try {
            this.translator.startDocument();
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.translator.endDocument();
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        if (this.graphicEnv != null) {
            this.graphicEnv.dispose();
            this.graphicEnv = null;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.charDataBuffer != null) {
            this.characters(this.charDataBuffer);
            this.charDataBuffer = null;
        }
        if (this.foreignContent) {
            ++this.foreignContentLevel;
            if (!this.skipUnknownContent) {
                this.startForeignObject(string, string2, attributes);
            }
            return;
        }
        if (this.copiedContent != null) {
            Converter.startElement(string, string2, string3, attributes, this.copiedContent);
            return;
        }
        int n = Fo.index(string2);
        if (n < 0) {
            this.foreignContent = true;
            this.foreignContentLevel = 1;
            this.skipUnknownContent = false;
            if (string.equals(FO_NAMESPACE_URI)) {
                this.warning("unknown element \"" + string2 + "\"");
                this.skipUnknownContent = true;
            } else if (this.translator.supportsExtension(string)) {
                this.startForeignObject(string, string2, attributes);
            } else {
                this.skipUnknownContent = true;
            }
            return;
        }
        PropertyValues propertyValues = new PropertyValues();
        Context context = this.context;
        this.context = this.context.startElement(n, propertyValues);
        if (context.properties != null) {
            propertyValues.inherit(context.properties);
        } else {
            this.computeFontSize(propertyValues);
        }
        String string4 = attributes.getValue("", "font");
        if (string4 != null) {
            this.setFont(propertyValues, string4);
        }
        if ((string4 = attributes.getValue("", "font-size")) != null) {
            this.setFontSize(propertyValues, string4);
        }
        this.setProperties(propertyValues, attributes);
        this.setDefaultValues(propertyValues);
        if (Fo.isReference(n)) {
            this.resetIndentProperties(propertyValues);
        }
        propertyValues.setCorresponding();
        this.context.update();
        switch (n) {
            case 0: {
                this.startBasicLink(propertyValues.values);
                break;
            }
            case 1: {
                this.startBidiOverride(propertyValues.values);
                break;
            }
            case 2: {
                this.startBlock(propertyValues.values);
                break;
            }
            case 3: {
                this.startBlockContainer(propertyValues.values);
                break;
            }
            case 4: {
                this.startCharacter(propertyValues.values);
                break;
            }
            case 5: {
                this.startColorProfile(propertyValues.values);
                break;
            }
            case 6: {
                this.startConditionalPageMasterReference(propertyValues.values);
                break;
            }
            case 7: {
                this.startDeclarations(propertyValues.values);
                break;
            }
            case 8: {
                this.startExternalGraphic(propertyValues.values);
                break;
            }
            case 9: {
                this.startFloat(propertyValues.values);
                break;
            }
            case 10: {
                this.startFlow(propertyValues.values);
                break;
            }
            case 11: {
                this.startFootnote(propertyValues.values);
                break;
            }
            case 12: {
                this.startFootnoteBody(propertyValues.values);
                break;
            }
            case 13: {
                this.startInitialPropertySet(propertyValues.values);
                break;
            }
            case 14: {
                this.startInline(propertyValues.values);
                break;
            }
            case 15: {
                this.startInlineContainer(propertyValues.values);
                break;
            }
            case 16: {
                this.startInstreamForeignObject(propertyValues.values);
                break;
            }
            case 17: {
                this.startLayoutMasterSet(propertyValues.values);
                break;
            }
            case 18: {
                this.startLeader(propertyValues.values);
                break;
            }
            case 19: {
                this.startListBlock(propertyValues.values);
                break;
            }
            case 20: {
                this.startListItem(propertyValues.values);
                break;
            }
            case 21: {
                this.startListItemBody(propertyValues.values);
                break;
            }
            case 22: {
                this.startListItemLabel(propertyValues.values);
                break;
            }
            case 23: {
                this.startMarker(propertyValues.values);
                break;
            }
            case 24: {
                this.startMultiCase(propertyValues.values);
                break;
            }
            case 25: {
                this.startMultiProperties(propertyValues.values);
                break;
            }
            case 26: {
                this.startMultiPropertySet(propertyValues.values);
                break;
            }
            case 27: {
                this.startMultiSwitch(propertyValues.values);
                break;
            }
            case 28: {
                this.startMultiToggle(propertyValues.values);
                break;
            }
            case 29: {
                this.startPageNumber(propertyValues.values);
                break;
            }
            case 30: {
                this.startPageNumberCitation(propertyValues.values);
                break;
            }
            case 31: {
                this.startPageSequence(propertyValues.values);
                break;
            }
            case 32: {
                this.startPageSequenceMaster(propertyValues.values);
                break;
            }
            case 33: {
                this.startRegionAfter(propertyValues.values);
                break;
            }
            case 34: {
                this.startRegionBefore(propertyValues.values);
                break;
            }
            case 35: {
                this.startRegionBody(propertyValues.values);
                break;
            }
            case 36: {
                this.startRegionEnd(propertyValues.values);
                break;
            }
            case 37: {
                this.startRegionStart(propertyValues.values);
                break;
            }
            case 38: {
                this.startRepeatablePageMasterAlternatives(propertyValues.values);
                break;
            }
            case 39: {
                this.startRepeatablePageMasterReference(propertyValues.values);
                break;
            }
            case 40: {
                this.startRetrieveMarker(propertyValues.values);
                break;
            }
            case 41: {
                this.startRoot(propertyValues.values);
                break;
            }
            case 42: {
                this.startSimplePageMaster(propertyValues.values);
                break;
            }
            case 43: {
                this.startSinglePageMasterReference(propertyValues.values);
                break;
            }
            case 44: {
                this.startStaticContent(propertyValues.values);
                break;
            }
            case 45: {
                this.startTable(propertyValues.values);
                break;
            }
            case 46: {
                this.startTableAndCaption(propertyValues.values);
                break;
            }
            case 47: {
                this.startTableBody(propertyValues.values);
                break;
            }
            case 48: {
                this.startTableCaption(propertyValues.values);
                break;
            }
            case 49: {
                this.startTableCell(propertyValues.values);
                break;
            }
            case 50: {
                this.startTableColumn(propertyValues.values);
                break;
            }
            case 51: {
                this.startTableFooter(propertyValues.values);
                break;
            }
            case 52: {
                this.startTableHeader(propertyValues.values);
                break;
            }
            case 53: {
                this.startTableRow(propertyValues.values);
                break;
            }
            case 54: {
                this.startTitle(propertyValues.values);
                break;
            }
            case 55: {
                this.startWrapper(propertyValues.values);
                break;
            }
        }
    }

    private static void startElement(String string, String string2, String string3, Attributes attributes, XMLWriter xMLWriter) throws SAXException {
        try {
            xMLWriter.startElement(string, string2, string3, attributes);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.charDataBuffer != null) {
            this.characters(this.charDataBuffer);
            this.charDataBuffer = null;
        }
        if (this.foreignContent) {
            if (!this.skipUnknownContent) {
                this.endForeignObject(string, string2);
            }
            if (--this.foreignContentLevel == 0) {
                this.foreignContent = false;
            }
            return;
        }
        if (!(this.copiedContent == null || "instream-foreign-object".equals(string2) && FO_NAMESPACE_URI.equals(string))) {
            Converter.endElement(string, string2, string3, this.copiedContent);
            return;
        }
        int n = Fo.index(string2);
        switch (n) {
            case 0: {
                this.endBasicLink();
                break;
            }
            case 1: {
                this.endBidiOverride();
                break;
            }
            case 2: {
                this.endBlock();
                break;
            }
            case 3: {
                this.endBlockContainer();
                break;
            }
            case 4: {
                this.endCharacter();
                break;
            }
            case 5: {
                this.endColorProfile();
                break;
            }
            case 6: {
                this.endConditionalPageMasterReference();
                break;
            }
            case 7: {
                this.endDeclarations();
                break;
            }
            case 8: {
                this.endExternalGraphic();
                break;
            }
            case 9: {
                this.endFloat();
                break;
            }
            case 10: {
                this.endFlow();
                break;
            }
            case 11: {
                this.endFootnote();
                break;
            }
            case 12: {
                this.endFootnoteBody();
                break;
            }
            case 13: {
                this.endInitialPropertySet();
                break;
            }
            case 14: {
                this.endInline();
                break;
            }
            case 15: {
                this.endInlineContainer();
                break;
            }
            case 16: {
                this.endInstreamForeignObject();
                break;
            }
            case 17: {
                this.endLayoutMasterSet();
                break;
            }
            case 18: {
                this.endLeader();
                break;
            }
            case 19: {
                this.endListBlock();
                break;
            }
            case 20: {
                this.endListItem();
                break;
            }
            case 21: {
                this.endListItemBody();
                break;
            }
            case 22: {
                this.endListItemLabel();
                break;
            }
            case 23: {
                this.endMarker();
                break;
            }
            case 24: {
                this.endMultiCase();
                break;
            }
            case 25: {
                this.endMultiProperties();
                break;
            }
            case 26: {
                this.endMultiPropertySet();
                break;
            }
            case 27: {
                this.endMultiSwitch();
                break;
            }
            case 28: {
                this.endMultiToggle();
                break;
            }
            case 29: {
                this.endPageNumber();
                break;
            }
            case 30: {
                this.endPageNumberCitation();
                break;
            }
            case 31: {
                this.endPageSequence();
                break;
            }
            case 32: {
                this.endPageSequenceMaster();
                break;
            }
            case 33: {
                this.endRegionAfter();
                break;
            }
            case 34: {
                this.endRegionBefore();
                break;
            }
            case 35: {
                this.endRegionBody();
                break;
            }
            case 36: {
                this.endRegionEnd();
                break;
            }
            case 37: {
                this.endRegionStart();
                break;
            }
            case 38: {
                this.endRepeatablePageMasterAlternatives();
                break;
            }
            case 39: {
                this.endRepeatablePageMasterReference();
                break;
            }
            case 40: {
                this.endRetrieveMarker();
                break;
            }
            case 41: {
                this.endRoot();
                break;
            }
            case 42: {
                this.endSimplePageMaster();
                break;
            }
            case 43: {
                this.endSinglePageMasterReference();
                break;
            }
            case 44: {
                this.endStaticContent();
                break;
            }
            case 45: {
                this.endTable();
                break;
            }
            case 46: {
                this.endTableAndCaption();
                break;
            }
            case 47: {
                this.endTableBody();
                break;
            }
            case 48: {
                this.endTableCaption();
                break;
            }
            case 49: {
                this.endTableCell();
                break;
            }
            case 50: {
                this.endTableColumn();
                break;
            }
            case 51: {
                this.endTableFooter();
                break;
            }
            case 52: {
                this.endTableHeader();
                break;
            }
            case 53: {
                this.endTableRow();
                break;
            }
            case 54: {
                this.endTitle();
                break;
            }
            case 55: {
                this.endWrapper();
                break;
            }
        }
        this.context = this.context.endElement();
    }

    private static void endElement(String string, String string2, String string3, XMLWriter xMLWriter) throws SAXException {
        try {
            xMLWriter.endElement(string, string2, string3);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (Product.IS_MANGLED) {
            Converter.mangle(cArray, n, n2);
        }
        if (this.foreignContent) {
            if (!this.skipUnknownContent) {
                try {
                    String string = new String(cArray, n, n2);
                    this.translator.characters(string, this.context);
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
            return;
        }
        if (this.copiedContent != null) {
            Converter.characters(cArray, n, n2, this.copiedContent);
            return;
        }
        if (!this.context.charDataAllowed()) {
            return;
        }
        if (this.charDataBuffer == null) {
            this.charDataBuffer = new StringBuffer();
        }
        this.charDataBuffer.append(cArray, n, n2);
    }

    private static void mangle(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n + 10; i < n3; i += 20) {
            char c = cArray[i];
            if (!Character.isLetter(c)) continue;
            if (i + 1 < n3 && Character.isLetter(cArray[i + 1])) {
                cArray[i + 1] = c;
                continue;
            }
            if (i - 1 < n || !Character.isLetter(cArray[i - 1])) continue;
            cArray[i - 1] = c;
        }
    }

    private static void characters(char[] cArray, int n, int n2, XMLWriter xMLWriter) throws SAXException {
        try {
            xMLWriter.characters(cArray, n, n2);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void characters(StringBuffer stringBuffer) throws SAXException {
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        this.characters(cArray);
    }

    private void characters(char[] cArray) throws SAXException {
        String string = this.normalize(cArray);
        if (string.length() == 0) {
            return;
        }
        try {
            this.translator.characters(string, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.context.characters(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String normalize(char[] cArray) {
        char c;
        int n;
        char c2 = '\u200b';
        int n2 = this.context.linefeedTreatment();
        int n3 = this.context.whiteSpaceTreatment();
        boolean bl = this.context.whiteSpaceCollapse();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        StringBuffer stringBuffer2 = new StringBuffer();
        block21: for (n = 0; n < cArray.length; ++n) {
            c = cArray[n];
            switch (c) {
                case '\t': 
                case ' ': {
                    switch (n3) {
                        case 82: {
                            break;
                        }
                        case 83: 
                        case 85: {
                            if (bl2) break;
                            stringBuffer2.append(' ');
                            break;
                        }
                        default: {
                            stringBuffer2.append(' ');
                            break;
                        }
                    }
                    continue block21;
                }
                case '\n': {
                    switch (n3) {
                        case 84: 
                        case 85: {
                            stringBuffer2.setLength(0);
                            break;
                        }
                    }
                    if (stringBuffer2.length() > 0) {
                        stringBuffer.append(stringBuffer2.toString());
                        stringBuffer2 = new StringBuffer();
                    }
                    switch (n2) {
                        case 82: {
                            break;
                        }
                        case 152: {
                            stringBuffer.append('\n');
                            break;
                        }
                        case 207: {
                            stringBuffer.append(' ');
                            break;
                        }
                        case 208: {
                            stringBuffer.append(c2);
                            break;
                        }
                    }
                    bl2 = true;
                    continue block21;
                }
                default: {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer.append(stringBuffer2.toString());
                        stringBuffer2 = new StringBuffer();
                    }
                    stringBuffer.append(c);
                    bl2 = false;
                }
            }
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(stringBuffer2.toString());
        }
        if (bl && stringBuffer.length() > 0) {
            n = stringBuffer.length();
            c = '\u0000';
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
            stringBuffer.setLength(0);
            block22: for (int i = 0; i < n; ++i) {
                char c3 = cArray[i];
                switch (c3) {
                    case ' ': {
                        if (c != ' ' && c != '\n') break;
                        continue block22;
                    }
                    case '\n': {
                        if (c != ' ') break;
                        stringBuffer.setLength(stringBuffer.length() - 1);
                    }
                }
                stringBuffer.append(c3);
                c = c3;
            }
        }
        return stringBuffer.toString();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void startRoot(Value[] valueArray) throws SAXException {
        try {
            this.translator.startRoot(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRoot() throws SAXException {
        try {
            this.translator.endRoot(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startDeclarations(Value[] valueArray) throws SAXException {
        try {
            this.translator.startDeclarations(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endDeclarations() throws SAXException {
        try {
            this.translator.endDeclarations(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startColorProfile(Value[] valueArray) throws SAXException {
        try {
            this.translator.startColorProfile(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endColorProfile() throws SAXException {
        try {
            this.translator.endColorProfile(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startPageSequence(Value[] valueArray) throws SAXException {
        PageSequence pageSequence = new PageSequence(valueArray);
        if (pageSequence.masterReference == null) {
            this.error(this.requiredValue("master-reference", "page-sequence"));
        }
        pageSequence.pageMaster = this.pageMaster(pageSequence.masterReference);
        if (pageSequence.pageMaster == null) {
            pageSequence.pageSequenceMaster = this.pageSequenceMaster(pageSequence.masterReference);
            if (pageSequence.pageSequenceMaster == null) {
                this.error(this.badValue("master-reference", pageSequence.masterReference));
            }
        }
        try {
            this.translator.startPageSequence(pageSequence, valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.context.pageSequence = pageSequence;
    }

    private SimplePageMaster pageMaster(String string) {
        int n = this.pageMasters.size();
        for (int i = 0; i < n; ++i) {
            SimplePageMaster simplePageMaster = (SimplePageMaster)this.pageMasters.elementAt(i);
            if (!string.equals(simplePageMaster.masterName)) continue;
            return simplePageMaster;
        }
        return null;
    }

    private PageSequenceMaster pageSequenceMaster(String string) {
        int n = this.pageSequenceMasters.size();
        for (int i = 0; i < n; ++i) {
            PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.pageSequenceMasters.elementAt(i);
            if (!string.equals(pageSequenceMaster.masterName)) continue;
            return pageSequenceMaster;
        }
        return null;
    }

    private void endPageSequence() throws SAXException {
        try {
            this.translator.endPageSequence(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.context.pageSequence = null;
    }

    private void startLayoutMasterSet(Value[] valueArray) throws SAXException {
        try {
            this.translator.startLayoutMasterSet(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endLayoutMasterSet() throws SAXException {
        int n = this.pageSequenceMasters.size();
        for (int i = 0; i < n; ++i) {
            PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.pageSequenceMasters.elementAt(i);
            int n2 = pageSequenceMaster.subSequences.size();
            for (int j = 0; j < n2; ++j) {
                PageMasterReference pageMasterReference = pageSequenceMaster.subSequence(j);
                pageMasterReference.setPageMaster(this.pageMasters);
                this.checkReference(pageMasterReference);
            }
        }
        try {
            this.translator.endLayoutMasterSet(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void checkReference(PageMasterReference pageMasterReference) throws SAXException {
        if (pageMasterReference.type == 3) {
            int n = pageMasterReference.alternatives.size();
            for (int i = 0; i < n; ++i) {
                this.checkReference(pageMasterReference.alternative(i));
            }
        } else if (pageMasterReference.pageMaster == null) {
            this.error(this.badValue("master-reference", pageMasterReference.masterReference));
        }
    }

    private void startPageSequenceMaster(Value[] valueArray) throws SAXException {
        PageSequenceMaster pageSequenceMaster = new PageSequenceMaster(valueArray);
        if (pageSequenceMaster.masterName == null) {
            this.error(this.requiredValue("master-name", "page-sequence-master"));
        }
        this.pageSequenceMasters.addElement(pageSequenceMaster);
        try {
            this.translator.startPageSequenceMaster(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endPageSequenceMaster() throws SAXException {
        try {
            this.translator.endPageSequenceMaster(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startSinglePageMasterReference(Value[] valueArray) throws SAXException {
        int n = 1;
        PageMasterReference pageMasterReference = new PageMasterReference(n, valueArray);
        if (pageMasterReference.masterReference == null) {
            this.error(this.requiredValue("master-reference", "single-page-master-reference"));
        }
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.pageSequenceMasters.lastElement();
        pageSequenceMaster.subSequences.addElement(pageMasterReference);
        try {
            this.translator.startSinglePageMasterReference(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endSinglePageMasterReference() throws SAXException {
        try {
            this.translator.endSinglePageMasterReference(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRepeatablePageMasterReference(Value[] valueArray) throws SAXException {
        int n = 2;
        PageMasterReference pageMasterReference = new PageMasterReference(n, valueArray);
        if (pageMasterReference.masterReference == null) {
            this.error(this.requiredValue("master-reference", "repeatable-page-master-reference"));
        }
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.pageSequenceMasters.lastElement();
        pageSequenceMaster.subSequences.addElement(pageMasterReference);
        try {
            this.translator.startRepeatablePageMasterReference(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRepeatablePageMasterReference() throws SAXException {
        try {
            this.translator.endRepeatablePageMasterReference(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRepeatablePageMasterAlternatives(Value[] valueArray) throws SAXException {
        int n = 3;
        PageMasterReference pageMasterReference = new PageMasterReference(n, valueArray);
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.pageSequenceMasters.lastElement();
        pageSequenceMaster.subSequences.addElement(pageMasterReference);
        try {
            this.translator.startRepeatablePageMasterAlternatives(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRepeatablePageMasterAlternatives() throws SAXException {
        try {
            this.translator.endRepeatablePageMasterAlternatives(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startConditionalPageMasterReference(Value[] valueArray) throws SAXException {
        int n = 4;
        PageMasterReference pageMasterReference = new PageMasterReference(n, valueArray);
        if (pageMasterReference.masterReference == null) {
            this.error(this.requiredValue("master-reference", "conditional-page-master-reference"));
        }
        PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)this.pageSequenceMasters.lastElement();
        PageMasterReference pageMasterReference2 = (PageMasterReference)pageSequenceMaster.subSequences.lastElement();
        pageMasterReference2.alternatives.addElement(pageMasterReference);
        try {
            this.translator.startConditionalPageMasterReference(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endConditionalPageMasterReference() throws SAXException {
        try {
            this.translator.endConditionalPageMasterReference(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startSimplePageMaster(Value[] valueArray) throws SAXException {
        SimplePageMaster simplePageMaster = new SimplePageMaster(valueArray);
        if (simplePageMaster.masterName == null) {
            this.error(this.requiredValue("master-name", "simple-page-master"));
        }
        this.pageMasters.addElement(simplePageMaster);
        try {
            this.translator.startSimplePageMaster(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endSimplePageMaster() throws SAXException {
        try {
            this.translator.endSimplePageMaster(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRegionBody(Value[] valueArray) throws SAXException {
        SimplePageMaster simplePageMaster = (SimplePageMaster)this.pageMasters.lastElement();
        simplePageMaster.regions[0] = new Region(valueArray);
        try {
            this.translator.startRegionBody(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRegionBody() throws SAXException {
        try {
            this.translator.endRegionBody(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRegionBefore(Value[] valueArray) throws SAXException {
        SimplePageMaster simplePageMaster = (SimplePageMaster)this.pageMasters.lastElement();
        simplePageMaster.regions[1] = new Region(valueArray);
        try {
            this.translator.startRegionBefore(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRegionBefore() throws SAXException {
        try {
            this.translator.endRegionBefore(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRegionAfter(Value[] valueArray) throws SAXException {
        SimplePageMaster simplePageMaster = (SimplePageMaster)this.pageMasters.lastElement();
        simplePageMaster.regions[2] = new Region(valueArray);
        try {
            this.translator.startRegionAfter(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRegionAfter() throws SAXException {
        try {
            this.translator.endRegionAfter(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRegionStart(Value[] valueArray) throws SAXException {
        SimplePageMaster simplePageMaster = (SimplePageMaster)this.pageMasters.lastElement();
        simplePageMaster.regions[3] = new Region(valueArray);
        try {
            this.translator.startRegionStart(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRegionStart() throws SAXException {
        try {
            this.translator.endRegionStart(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRegionEnd(Value[] valueArray) throws SAXException {
        SimplePageMaster simplePageMaster = (SimplePageMaster)this.pageMasters.lastElement();
        simplePageMaster.regions[4] = new Region(valueArray);
        try {
            this.translator.startRegionEnd(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRegionEnd() throws SAXException {
        try {
            this.translator.endRegionEnd(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startFlow(Value[] valueArray) throws SAXException {
        Flow flow = new Flow(1, valueArray);
        if (flow.flowName == null) {
            this.error(this.requiredValue("flow-name", "flow"));
        }
        try {
            this.translator.startFlow(flow, valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.context.flow = flow;
    }

    private void endFlow() throws SAXException {
        try {
            this.translator.endFlow(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.context.flow = null;
    }

    private void startStaticContent(Value[] valueArray) throws SAXException {
        Flow flow = new Flow(2, valueArray);
        if (flow.flowName == null) {
            this.error(this.requiredValue("flow-name", "static-content"));
        }
        try {
            this.translator.startStaticContent(flow, valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.context.flow = flow;
    }

    private void endStaticContent() throws SAXException {
        try {
            this.translator.endStaticContent(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.context.flow = null;
    }

    private int region(Flow flow) {
        PageSequence pageSequence;
        int n = -1;
        Context context = this.context.parent();
        if (context != null && context.fo == 31 && (pageSequence = context.pageSequence) != null) {
            SimplePageMaster simplePageMaster = pageSequence.pageMaster;
            if (simplePageMaster != null) {
                n = flow.region(simplePageMaster);
            } else {
                Vector vector;
                PageSequenceMaster pageSequenceMaster = pageSequence.pageSequenceMaster;
                if (pageSequenceMaster != null && (vector = pageSequenceMaster.subSequences) != null) {
                    int n2 = vector.size();
                    block0: for (int i = 0; i < n2; ++i) {
                        Vector vector2;
                        PageMasterReference pageMasterReference = (PageMasterReference)vector.elementAt(i);
                        if (pageMasterReference.type == 3 && (vector2 = pageMasterReference.alternatives) != null) {
                            int n3 = vector2.size();
                            for (int j = 0; j < n3; ++j) {
                                PageMasterReference pageMasterReference2 = (PageMasterReference)vector2.elementAt(j);
                                simplePageMaster = pageMasterReference2.pageMaster;
                                if (simplePageMaster != null && (n = flow.region(simplePageMaster)) != -1) break block0;
                            }
                            continue;
                        }
                        simplePageMaster = pageMasterReference.pageMaster;
                        if (simplePageMaster != null && (n = flow.region(simplePageMaster)) != -1) break;
                    }
                }
            }
        }
        return n;
    }

    private void startTitle(Value[] valueArray) throws SAXException {
        try {
            this.translator.startTitle(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTitle() throws SAXException {
        try {
            this.translator.endTitle(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startBlock(Value[] valueArray) throws SAXException {
        try {
            this.translator.startBlock(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endBlock() throws SAXException {
        try {
            this.translator.endBlock(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startBlockContainer(Value[] valueArray) throws SAXException {
        try {
            this.translator.startBlockContainer(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endBlockContainer() throws SAXException {
        try {
            this.translator.endBlockContainer(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startBidiOverride(Value[] valueArray) throws SAXException {
        try {
            this.translator.startBidiOverride(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endBidiOverride() throws SAXException {
        try {
            this.translator.endBidiOverride(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startCharacter(Value[] valueArray) throws SAXException {
        try {
            this.translator.startCharacter(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endCharacter() throws SAXException {
        try {
            this.translator.endCharacter(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startInitialPropertySet(Value[] valueArray) throws SAXException {
        try {
            this.translator.startInitialPropertySet(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endInitialPropertySet() throws SAXException {
        try {
            this.translator.endInitialPropertySet(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startExternalGraphic(Value[] valueArray) throws SAXException {
        ExternalGraphic externalGraphic = new ExternalGraphic(valueArray);
        Graphic graphic = this.createGraphic(externalGraphic);
        if (graphic == null) {
            graphic = Converter.createMissingGraphic(externalGraphic, this.graphicEnv);
        }
        try {
            this.translator.startExternalGraphic(graphic, this.graphicEnv, valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private Graphic createGraphic(ExternalGraphic externalGraphic) throws SAXException {
        if (externalGraphic.src == null) {
            this.warning(this.requiredValue("src", "external-graphic"));
            return null;
        }
        String string = this.resolveUri(externalGraphic.src);
        if (string == null) {
            this.warning("cannot resolve URI \"" + externalGraphic.src + "\"");
            return null;
        }
        String string2 = externalGraphic.mimeType();
        if (string2 == null) {
            this.warning("unknown graphic format (src=\"" + externalGraphic.src + "\")");
            return null;
        }
        try {
            return GraphicFactories.createGraphic(string, string2, externalGraphic, this.graphicEnv);
        }
        catch (Exception exception) {
            this.warning("failed to load image \"" + string + "\": " + exception.getMessage());
            return null;
        }
    }

    private static Graphic createMissingGraphic(ExternalGraphic externalGraphic, GraphicEnv graphicEnv) {
        GraphicImpl graphicImpl = MissingGraphic.create(externalGraphic, graphicEnv);
        externalGraphic.src = graphicImpl.getLocation();
        String string = "content-type:" + graphicImpl.getFormat();
        externalGraphic.contentType = new Value(15, string);
        externalGraphic.contentWidth = Value.KEYWORD_AUTO;
        externalGraphic.contentHeight = Value.KEYWORD_AUTO;
        return graphicImpl;
    }

    private void endExternalGraphic() throws SAXException {
        try {
            this.translator.endExternalGraphic(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startInstreamForeignObject(Value[] valueArray) throws SAXException {
        try {
            File file = this.graphicEnv.createTempFile(".xml");
            this.copiedContent = new XMLWriter(file);
            this.copiedContentProperties = valueArray;
            this.translator.startInstreamForeignObject(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endInstreamForeignObject() throws SAXException {
        Object object;
        Value[] valueArray = this.copiedContentProperties;
        this.copiedContentProperties = null;
        File file = this.copiedContent.getOutputFile();
        String string = this.copiedContent.getRootElementNamespaceURI();
        try {
            this.copiedContent.close();
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        finally {
            this.copiedContent = null;
        }
        ExternalGraphic externalGraphic = new ExternalGraphic(valueArray);
        externalGraphic.src = URLUtil.fileToLocation(file);
        if (externalGraphic.contentType.type != 15 || externalGraphic.contentType.string().startsWith("namespace-prefix:")) {
            object = null;
            if ("http://www.w3.org/1998/Math/MathML".equals(string)) {
                object = "application/mathml+xml";
            } else if ("http://www.w3.org/2000/svg".equals(string)) {
                object = "image/svg+xml";
            }
            if (object != null) {
                externalGraphic.contentType = new Value(15, "content-type:" + (String)object);
            }
        }
        if ((object = this.createGraphic(externalGraphic)) == null) {
            object = Converter.createMissingGraphic(externalGraphic, this.graphicEnv);
        }
        try {
            this.translator.endInstreamForeignObject((Graphic)object, this.graphicEnv, valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startInline(Value[] valueArray) throws SAXException {
        try {
            this.translator.startInline(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endInline() throws SAXException {
        try {
            this.translator.endInline(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startInlineContainer(Value[] valueArray) throws SAXException {
        try {
            this.translator.startInlineContainer(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endInlineContainer() throws SAXException {
        try {
            this.translator.endInlineContainer(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startLeader(Value[] valueArray) throws SAXException {
        try {
            this.translator.startLeader(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endLeader() throws SAXException {
        try {
            this.translator.endLeader(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startPageNumber(Value[] valueArray) throws SAXException {
        try {
            this.translator.startPageNumber(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endPageNumber() throws SAXException {
        try {
            this.translator.endPageNumber(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startPageNumberCitation(Value[] valueArray) throws SAXException {
        try {
            this.translator.startPageNumberCitation(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endPageNumberCitation() throws SAXException {
        try {
            this.translator.endPageNumberCitation(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTableAndCaption(Value[] valueArray) throws SAXException {
        try {
            this.translator.startTableAndCaption(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableAndCaption() throws SAXException {
        try {
            this.translator.endTableAndCaption(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTable(Value[] valueArray) throws SAXException {
        if (this.table != null) {
            this.tables.addElement(this.table);
        }
        this.table = new Table();
        this.context.tableColumns = this.table.columns;
        try {
            this.translator.startTable(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTable() throws SAXException {
        int n = this.tables.size();
        try {
            this.translator.endTable(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        if (n > 0) {
            this.table = (Table)this.tables.lastElement();
            this.tables.removeElementAt(n - 1);
        } else {
            this.table = null;
        }
    }

    private void startTableColumn(Value[] valueArray) throws SAXException {
        int n;
        TableColumn tableColumn = new TableColumn(valueArray);
        int n2 = tableColumn.numberColumnsRepeated * tableColumn.numberColumnsSpanned;
        int n3 = n + n2;
        for (n = tableColumn.columnNumber; n < n3; ++n) {
            this.table.columns.put(new Integer(n), tableColumn);
        }
        this.table.column = tableColumn.columnNumber + n2;
        try {
            this.translator.startTableColumn(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableColumn() throws SAXException {
        try {
            this.translator.endTableColumn(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTableCaption(Value[] valueArray) throws SAXException {
        try {
            this.translator.startTableCaption(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableCaption() throws SAXException {
        try {
            this.translator.endTableCaption(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTableHeader(Value[] valueArray) throws SAXException {
        this.table.row = 1;
        this.table.column = 1;
        this.table.cell = null;
        this.table.cells = new HashSet();
        try {
            this.translator.startTableHeader(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableHeader() throws SAXException {
        try {
            this.translator.endTableHeader(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTableFooter(Value[] valueArray) throws SAXException {
        this.table.row = 1;
        this.table.column = 1;
        this.table.cell = null;
        this.table.cells = new HashSet();
        try {
            this.translator.startTableFooter(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableFooter() throws SAXException {
        try {
            this.translator.endTableFooter(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTableBody(Value[] valueArray) throws SAXException {
        this.table.row = 1;
        this.table.column = 1;
        this.table.cell = null;
        this.table.cells = new HashSet();
        try {
            this.translator.startTableBody(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableBody() throws SAXException {
        try {
            this.translator.endTableBody(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTableRow(Value[] valueArray) throws SAXException {
        ++this.table.row;
        this.table.column = 1;
        try {
            this.translator.startTableRow(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableRow() throws SAXException {
        try {
            this.translator.endTableRow(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startTableCell(Value[] valueArray) throws SAXException {
        this.table.cell = new TableCell(valueArray);
        if (this.table.cell.startsRow) {
            ++this.table.row;
            this.table.column = 1;
        }
        this.context.tableCell = this.table.cell;
        try {
            this.translator.startTableCell(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endTableCell() throws SAXException {
        try {
            this.translator.endTableCell(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        if (this.table.cell.numberRowsSpanned > 1) {
            for (int i = 1; i < this.table.cell.numberRowsSpanned; ++i) {
                for (int j = 0; j < this.table.cell.numberColumnsSpanned; ++j) {
                    this.table.allocate(this.table.row + i, this.table.cell.columnNumber + j);
                }
            }
        }
        this.table.column = this.table.cell.columnNumber + this.table.cell.numberColumnsSpanned;
        if (this.table.cell.endsRow) {
            ++this.table.row;
            this.table.column = 1;
        }
    }

    private void startListBlock(Value[] valueArray) throws SAXException {
        try {
            this.translator.startListBlock(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endListBlock() throws SAXException {
        try {
            this.translator.endListBlock(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startListItem(Value[] valueArray) throws SAXException {
        try {
            this.translator.startListItem(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endListItem() throws SAXException {
        try {
            this.translator.endListItem(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startListItemBody(Value[] valueArray) throws SAXException {
        try {
            this.translator.startListItemBody(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endListItemBody() throws SAXException {
        try {
            this.translator.endListItemBody(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startListItemLabel(Value[] valueArray) throws SAXException {
        try {
            this.translator.startListItemLabel(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endListItemLabel() throws SAXException {
        try {
            this.translator.endListItemLabel(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startBasicLink(Value[] valueArray) throws SAXException {
        try {
            this.translator.startBasicLink(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endBasicLink() throws SAXException {
        try {
            this.translator.endBasicLink(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startMultiSwitch(Value[] valueArray) throws SAXException {
        try {
            this.translator.startMultiSwitch(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endMultiSwitch() throws SAXException {
        try {
            this.translator.endMultiSwitch(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startMultiCase(Value[] valueArray) throws SAXException {
        try {
            this.translator.startMultiCase(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endMultiCase() throws SAXException {
        try {
            this.translator.endMultiCase(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startMultiToggle(Value[] valueArray) throws SAXException {
        try {
            this.translator.startMultiToggle(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endMultiToggle() throws SAXException {
        try {
            this.translator.endMultiToggle(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startMultiProperties(Value[] valueArray) throws SAXException {
        try {
            this.translator.startMultiProperties(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endMultiProperties() throws SAXException {
        try {
            this.translator.endMultiProperties(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startMultiPropertySet(Value[] valueArray) throws SAXException {
        try {
            this.translator.startMultiPropertySet(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endMultiPropertySet() throws SAXException {
        try {
            this.translator.endMultiPropertySet(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startFloat(Value[] valueArray) throws SAXException {
        try {
            this.translator.startFloat(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endFloat() throws SAXException {
        try {
            this.translator.endFloat(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startFootnote(Value[] valueArray) throws SAXException {
        try {
            this.translator.startFootnote(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endFootnote() throws SAXException {
        try {
            this.translator.endFootnote(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startFootnoteBody(Value[] valueArray) throws SAXException {
        try {
            this.translator.startFootnoteBody(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endFootnoteBody() throws SAXException {
        try {
            this.translator.endFootnoteBody(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startWrapper(Value[] valueArray) throws SAXException {
        try {
            this.translator.startWrapper(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endWrapper() throws SAXException {
        try {
            this.translator.endWrapper(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startMarker(Value[] valueArray) throws SAXException {
        try {
            this.translator.startMarker(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endMarker() throws SAXException {
        try {
            this.translator.endMarker(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startRetrieveMarker(Value[] valueArray) throws SAXException {
        try {
            this.translator.startRetrieveMarker(valueArray, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endRetrieveMarker() throws SAXException {
        try {
            this.translator.endRetrieveMarker(this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void startForeignObject(String string, String string2, Attributes attributes) throws SAXException {
        try {
            this.translator.startForeignObject(string, string2, attributes, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void endForeignObject(String string, String string2) throws SAXException {
        try {
            this.translator.endForeignObject(string, string2, this.context);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void setFont(PropertyValues propertyValues, String string) throws SAXException {
        Shorthand shorthand = (Shorthand)Property.list[103];
        Value value = shorthand.evaluate(string, this.context);
        if (value == null) {
            this.warning(this.badValue("font", string));
            return;
        }
        if ((value = shorthand.compute(value, this.context)) == null) {
            this.warning(this.badValue("font", string));
            return;
        }
        propertyValues.set(103, value);
        shorthand.expand(propertyValues);
    }

    private void setFontSize(PropertyValues propertyValues, String string) throws SAXException {
        Property property = Property.list[106];
        Value value = property.evaluate(string, this.context);
        if (value == null) {
            this.warning(this.badValue("font-size", string));
            return;
        }
        if ((value = property.compute(value, this.context)) == null) {
            this.warning(this.badValue("font-size", string));
            return;
        }
        propertyValues.set(106, value);
    }

    private void computeFontSize(PropertyValues propertyValues) {
        Property property = Property.list[106];
        Value value = propertyValues.values[106];
        propertyValues.values[106] = value = property.compute(value, this.context);
    }

    private void setProperties(PropertyValues propertyValues, Attributes attributes) throws SAXException {
        Value value;
        String string;
        Property property;
        int n;
        int n2;
        for (n2 = 0; n2 < Shorthand.list.length; ++n2) {
            n = Shorthand.list[n2];
            if (n == 103) continue;
            property = (Shorthand)Property.list[n];
            string = attributes.getValue("", ((Shorthand)property).name);
            if (string == null) continue;
            value = property.evaluate(string, this.context);
            if (value == null) {
                this.warning(this.badValue(((Shorthand)property).name, string));
                continue;
            }
            if ((value = ((Shorthand)property).compute(value, this.context)) == null) {
                this.warning(this.badValue(((Shorthand)property).name, string));
                continue;
            }
            propertyValues.set(n, value);
            ((Shorthand)property).expand(propertyValues);
        }
        string = attributes.getValue("xml:lang");
        if (string != null) {
            property = (Shorthand)Property.list[317];
            value = property.evaluate(string, this.context);
            if (value != null) {
                if ((value = ((Shorthand)property).compute(value, this.context)) != null) {
                    propertyValues.set(317, value);
                    ((Shorthand)property).expand(propertyValues);
                } else {
                    this.warning(this.badValue("xml:lang", string));
                }
            } else {
                this.warning(this.badValue("xml:lang", string));
            }
        }
        for (n2 = 0; n2 < Compound.list.length; ++n2) {
            n = Compound.list[n2];
            property = (Compound)Property.list[n];
            string = attributes.getValue("", ((Compound)property).name);
            if (string == null) continue;
            value = property.evaluate(string, this.context);
            if (value == null) {
                this.warning(this.badValue(((Compound)property).name, string));
                continue;
            }
            if (n != 164 && (value = property.compute(value, this.context)) == null) {
                this.warning(this.badValue(((Compound)property).name, string));
                continue;
            }
            propertyValues.set(n, value);
            ((Compound)property).expand(propertyValues);
        }
        int n3 = attributes.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            String string2 = attributes.getLocalName(n2);
            if (string2 == null) continue;
            n = Property.index(string2);
            if (n < 0) {
                String string3 = attributes.getURI(n2);
                if (string3 == null || !string3.equals("") && !string3.equals(FO_NAMESPACE_URI)) continue;
                this.warning("unknown property name \"" + string2 + "\"");
                continue;
            }
            if (n == 106) continue;
            property = Property.list[n];
            if (property.type != 0) continue;
            value = property.evaluate(attributes.getValue(n2), this.context);
            if (value == null) {
                this.warning(this.badValue(string2, attributes.getValue(n2)));
                continue;
            }
            if ((value = property.compute(value, this.context)) == null) {
                this.warning(this.badValue(string2, attributes.getValue(n2)));
                continue;
            }
            propertyValues.set(n, value);
        }
    }

    private void setDefaultValues(PropertyValues propertyValues) {
        if (!propertyValues.isSpecified(227)) {
            switch (this.context.fo) {
                case 35: {
                    propertyValues.values[227] = new Value(1, 232);
                    break;
                }
                case 34: {
                    propertyValues.values[227] = new Value(1, 231);
                    break;
                }
                case 33: {
                    propertyValues.values[227] = new Value(1, 230);
                    break;
                }
                case 37: {
                    propertyValues.values[227] = new Value(1, 234);
                    break;
                }
                case 36: {
                    propertyValues.values[227] = new Value(1, 233);
                }
            }
        }
        if (propertyValues.values[65] == null) {
            propertyValues.values[65] = propertyValues.values[78];
        }
        if (propertyValues.values[34] == null) {
            propertyValues.values[34] = propertyValues.values[78];
        }
        if (propertyValues.values[46] == null) {
            propertyValues.values[46] = propertyValues.values[78];
        }
        if (propertyValues.values[50] == null) {
            propertyValues.values[50] = propertyValues.values[78];
        }
        if (!propertyValues.isSpecified(82)) {
            switch (this.context.fo) {
                case 50: {
                    propertyValues.values[82] = new Value(3, (double)this.table.column);
                    break;
                }
                case 49: {
                    int n = this.table.row;
                    int n2 = this.table.column;
                    if (propertyValues.startsRow()) {
                        ++n;
                        n2 = 1;
                    }
                    while (this.table.isAllocated(n, n2)) {
                        ++n2;
                    }
                    propertyValues.values[82] = new Value(3, (double)n2);
                }
            }
        }
    }

    private void resetIndentProperties(PropertyValues propertyValues) {
        int[] nArray = new int[]{277, 97, 294};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (propertyValues.isSpecified(n)) continue;
            propertyValues.reset(n);
        }
    }

    private String badValue(String string, String string2) {
        return "bad property value " + string + "=\"" + string2 + "\"";
    }

    private String requiredValue(String string, String string2) {
        return "property \"" + string + "\" required for object \"" + string2 + "\"";
    }

    private void warning(String string) throws SAXException {
        String string2 = this.location();
        if (string2 != null) {
            string = string + " (" + string2 + ")";
        }
        try {
            this.errorHandler.warning(new Exception(string));
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void error(String string) throws SAXException {
        String string2 = this.location();
        if (string2 != null) {
            string = string + " (" + string2 + ")";
        }
        throw new SAXException(string);
    }

    private String location() {
        if (this.locator != null) {
            int n = this.locator.getLineNumber();
            int n2 = this.locator.getColumnNumber();
            String string = this.locator.getSystemId();
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            }
            if (n > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("line #" + n);
                if (n2 > 0) {
                    stringBuffer.append(", column #" + n2);
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void error(Exception exception) throws Exception {
        throw exception;
    }

    public void warning(Exception exception) throws Exception {
        String string = exception.getMessage();
        System.err.println("warning: " + string);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        try {
            this.errorHandler.warning(sAXParseException);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        try {
            this.errorHandler.warning(sAXParseException);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public URL resolve(String string, URL uRL) throws Exception {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = this.properties.getProperty("baseURL");
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                try {
                    URL uRL2;
                    uRL = uRL2 = new URL(string2);
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            return new URL(uRL, string);
        }
    }

    public String resolve(String string) throws Exception {
        return this.resolveUri(string);
    }

    private String resolveUri(String string) throws SAXException {
        Object object;
        if (string.startsWith("data:")) {
            return string;
        }
        URL uRL = null;
        try {
            object = null;
            if (this.locator != null) {
                object = this.locator.getSystemId();
            } else if (this.input != null) {
                object = this.input.getSystemId();
            }
            if (object != null) {
                uRL = URLUtil.urlOrFile((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = null;
        try {
            object = this.uriResolver.resolve(string, uRL);
        }
        catch (Exception exception) {
            this.warning("URI resolver error: " + exception.getMessage());
        }
        if (object == null) {
            return null;
        }
        try {
            return ((URL)object).toExternalForm();
        }
        catch (Exception exception) {
            String string2 = ((URL)object).getFile();
            if (string2 == null || string2.length() == 0) {
                string2 = "/";
            }
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            return "file:" + string2;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Converter converter = new Converter();
        InputSource inputSource = new InputSource();
        OutputDestination outputDestination = new OutputDestination();
        Fo.check();
        Property.check();
        Keyword.check();
        switch (stringArray.length) {
            case 1: {
                inputSource.setSystemId(stringArray[0]);
                break;
            }
            case 2: {
                inputSource.setSystemId(stringArray[0]);
                outputDestination.setFileName(stringArray[1]);
                break;
            }
            case 3: {
                converter.setProperty("outputFormat", stringArray[0]);
                inputSource.setSystemId(stringArray[1]);
                outputDestination.setFileName(stringArray[2]);
            }
        }
        try {
            converter.convert(inputSource, outputDestination);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(2);
        }
        System.exit(0);
    }

    private class Table {
        int row = 1;
        int column = 1;
        TableCell cell;
        Hashtable columns = new Hashtable();
        HashSet cells;

        private Table() {
        }

        void allocate(int n, int n2) {
            this.cells.add(this.cell(n, n2));
        }

        boolean isAllocated(int n, int n2) {
            return this.cells.contains(this.cell(n, n2));
        }

        String cell(int n, int n2) {
            return n + ":" + n2;
        }
    }
}

