/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter;

import com.xmlmind.fo.converter.Converter;
import com.xmlmind.fo.converter.ErrorHandler;
import com.xmlmind.fo.converter.OutputDestination;
import com.xmlmind.fo.converter.UriResolver;
import com.xmlmind.fo.util.SystemUtil;
import com.xmlmind.fo.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Driver
implements ErrorHandler {
    private static final String defaultOutputFormat = "rtf";
    private Properties properties = new Properties();
    private ErrorHandler errorHandler = this;
    private UriResolver uriResolver;
    private XMLReader reader;
    private InputSource input;
    private OutputDestination output;

    public static String[] listEncodings(String string) throws IllegalArgumentException {
        return Converter.listEncodings(string);
    }

    public void setInput(InputSource inputSource) {
        this.input = new InputSource();
        this.input.setByteStream(inputSource.getByteStream());
        this.input.setCharacterStream(inputSource.getCharacterStream());
        this.input.setEncoding(inputSource.getEncoding());
        this.input.setPublicId(inputSource.getPublicId());
        String string = inputSource.getSystemId();
        if (string != null) {
            this.input.setSystemId(URLUtil.locationOrFilename(string));
        }
    }

    public void setInput(String string) {
        this.input = new InputSource(URLUtil.locationOrFilename(string));
    }

    public void setInput(URL uRL) {
        this.input = new InputSource(uRL.toString());
    }

    public void setInput(InputStream inputStream) {
        this.input = new InputSource(inputStream);
    }

    public void setInput(Reader reader) {
        this.input = new InputSource(reader);
    }

    public void setOutput(OutputDestination outputDestination) {
        this.output = outputDestination.copy();
    }

    public void setOutput(String string) {
        this.output = new OutputDestination(string);
    }

    public void setOutput(OutputStream outputStream) {
        this.output = new OutputDestination(outputStream);
    }

    public void setOutput(Writer writer) {
        this.output = new OutputDestination(writer);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void setProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    public void loadPropertyFile(String string) throws IOException {
        this.loadPropertyFile(new File(string));
    }

    public void loadPropertyFile(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        this.properties.load(bufferedInputStream);
    }

    public void loadUserConfiguration() throws IOException {
        File file;
        File file2 = SystemUtil.userPreferencesDir();
        if (file2 != null && (file = new File(file2, "xfc.properties")).isFile() && file.canRead()) {
            this.loadPropertyFile(file);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler != null ? errorHandler : this;
    }

    public void setUriResolver(UriResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public UriResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.reader = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.reader;
    }

    public void convert() throws Exception {
        String string;
        if (this.input == null || this.output == null) {
            this.errorHandler.error(new Exception("no input/output specified"));
            return;
        }
        Converter converter = new Converter();
        converter.setProperties(this.properties);
        converter.setErrorHandler(this.errorHandler);
        converter.setUriResolver(this.uriResolver);
        converter.setXMLReader(this.reader);
        String string2 = this.properties.getProperty("outputFormat");
        if (string2 == null) {
            string2 = this.getOutputFormat(this.output);
            if (string2 == null) {
                string2 = defaultOutputFormat;
            }
            converter.setProperty("outputFormat", string2);
        }
        if (this.input.getEncoding() == null && (string = this.properties.getProperty("inputEncoding")) != null) {
            this.input.setEncoding(string);
        }
        converter.convert(this.input, this.output);
    }

    public void convert(InputSource inputSource, OutputDestination outputDestination) throws Exception {
        this.setInput(inputSource);
        this.setOutput(outputDestination);
        this.convert();
    }

    private String getOutputFormat(OutputDestination outputDestination) {
        int n;
        String string = null;
        String string2 = outputDestination.getFileName();
        if (string2 != null && (n = string2.lastIndexOf(46)) > 0) {
            String string3 = string2.substring(n + 1).toLowerCase();
            if (string3.equals(defaultOutputFormat)) {
                string = defaultOutputFormat;
            } else if (string3.equals("xml")) {
                string = "wml";
            } else if (string3.equals("odt")) {
                string = "odt";
            }
        }
        return string;
    }

    public void error(Exception exception) throws Exception {
        throw exception;
    }

    public void warning(Exception exception) throws Exception {
        String string = exception.getMessage();
        System.err.println("warning: " + string);
    }

    public static void main(String[] stringArray) {
        String string;
        Object object;
        int n;
        int n2;
        Properties properties = new Properties();
        String string2 = null;
        String string3 = null;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].charAt(0) == '-' && stringArray[n2].length() > 1) {
                n = stringArray[n2].indexOf(61);
                if (n < 2) {
                    Driver.usage("illegal argument \"" + stringArray[n2] + "\"");
                }
                object = stringArray[n2].substring(1, n);
                string = stringArray[n2].substring(n + 1);
                properties.setProperty((String)object, string);
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[n2];
                continue;
            }
            if (string3 == null) {
                string3 = stringArray[n2];
                continue;
            }
            Driver.usage("illegal argument \"" + stringArray[n2] + "\"");
        }
        n2 = string2 == null || string2.equals("-") ? 1 : 0;
        n = string3 == null || string3.equals("-") ? 1 : 0;
        try {
            object = new Driver();
            string = properties.getProperty("validation");
            if (string != null && string.equals("true")) {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                ((Driver)object).setXMLReader(sAXParser.getXMLReader());
            }
            ((Driver)object).loadUserConfiguration();
            if (!properties.isEmpty()) {
                ((Driver)object).setProperties(properties);
            }
            if (n2 != 0) {
                ((Driver)object).setInput(System.in);
            } else {
                ((Driver)object).setInput(string2);
            }
            if (n != 0) {
                ((Driver)object).setOutput(System.out);
            } else {
                ((Driver)object).setOutput(string3);
            }
            ((Driver)object).convert();
        }
        catch (Exception exception) {
            string = exception.getMessage();
            if (string == null) {
                string = exception.getClass().getName();
            }
            System.err.println("Cannot convert \"" + (n2 != 0 ? "(standard input)" : string2) + "\" to \"" + (n != 0 ? "(standard output)" : string3) + "\": " + string);
            System.exit(2);
        }
        System.exit(0);
    }

    private static void usage(String string) {
        if (string != null) {
            System.err.println("Error: " + string);
        }
        System.err.println("Usage: fo2XXX [ -property_name=property_value ]* [ in_fo_file|- [ out_file|- ] ]");
        System.exit(1);
    }
}

