/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.ErrorHandler;
import com.xmlmind.fo.converter.EventHandler;
import com.xmlmind.fo.converter.GraphicLayout;
import com.xmlmind.fo.converter.OutputDestination;
import com.xmlmind.fo.font.GenericFamilies;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.objects.Flow;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.properties.Value;
import java.util.Enumeration;
import java.util.Properties;
import org.xml.sax.Attributes;

public abstract class Translator
implements EventHandler,
ErrorHandler {
    protected OutputDestination output;
    protected Properties properties = new Properties();
    protected ErrorHandler errorHandler = this;
    protected UriResolver uriResolver;

    protected Translator() {
    }

    public void setOutput(OutputDestination outputDestination) {
        this.output = outputDestination;
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public void setProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler != null ? errorHandler : this;
    }

    public void setUriResolver(UriResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public static String[] listEncodings() {
        return new String[]{"ASCII"};
    }

    public void abort() {
    }

    protected boolean singleSided() {
        String string = this.properties.getProperty("singleSidedLayout", "");
        return string.toLowerCase().equals("true");
    }

    protected boolean prescaleImages() {
        String string = this.properties.getProperty("prescaleImages", "");
        return !string.toLowerCase().equals("false");
    }

    protected int imageResolution() {
        return GraphicLayout.getResolutionProperty(this.properties, "imageResolution", 96);
    }

    protected int imageRendererResolution() {
        return GraphicLayout.getResolutionProperty(this.properties, "imageRendererResolution", this.getImageRendererResolution());
    }

    protected boolean alwaysSaveAsPNG() {
        String string = this.properties.getProperty("alwaysSaveAsPNG", "");
        return string.toLowerCase().equals("true");
    }

    protected GenericFamilies genericFontFamilies(String string, String string2, String string3) throws Exception {
        GenericFamilies genericFamilies = new GenericFamilies();
        String string4 = this.properties.getProperty("genericFontFamilies", null);
        if (string4 != null) {
            try {
                GenericFamilies.parse(string4, genericFamilies);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorHandler.warning(illegalArgumentException);
            }
        }
        if (genericFamilies.serif == null) {
            if (string == null) {
                string = "Times New Roman";
            }
            genericFamilies.serif = string;
        }
        if (genericFamilies.sansSerif == null) {
            if (string2 == null) {
                string2 = "Arial";
            }
            genericFamilies.sansSerif = string2;
        }
        if (genericFamilies.monospace == null) {
            if (string3 == null) {
                string3 = "Courier New";
            }
            genericFamilies.monospace = string3;
        }
        return genericFamilies;
    }

    public int getImageRendererResolution() {
        return 96;
    }

    public String systemFont(int n) {
        return "10pt serif";
    }

    public double fontSize(int n, double d) {
        double d2 = 10.0;
        switch (n) {
            case 236: {
                d2 = 6.0;
                break;
            }
            case 243: {
                d2 = 8.0;
                break;
            }
            case 182: {
                d2 = 10.0;
                break;
            }
            case 118: {
                d2 = 12.0;
                break;
            }
            case 95: {
                d2 = 14.0;
                break;
            }
            case 239: {
                d2 = 16.0;
                break;
            }
            case 235: {
                d2 = 18.0;
                break;
            }
            case 96: {
                d2 = 2.0 * (double)Math.round(d / 2.0 + 1.0);
                break;
            }
            case 183: {
                d2 = 2.0 * (double)Math.round(d / 2.0 - 1.0);
                if (!(d2 < 2.0)) break;
                d2 = 2.0;
                break;
            }
        }
        return d2;
    }

    public double referenceWidth() {
        return 0.0;
    }

    public void startDocument() throws Exception {
    }

    public void endDocument() throws Exception {
    }

    public void characters(String string, Context context) throws Exception {
    }

    public void startRoot(Value[] valueArray, Context context) throws Exception {
    }

    public void endRoot(Context context) throws Exception {
    }

    public void startDeclarations(Value[] valueArray, Context context) throws Exception {
    }

    public void endDeclarations(Context context) throws Exception {
    }

    public void startColorProfile(Value[] valueArray, Context context) throws Exception {
    }

    public void endColorProfile(Context context) throws Exception {
    }

    public void startPageSequence(PageSequence pageSequence, Value[] valueArray, Context context) throws Exception {
    }

    public void endPageSequence(Context context) throws Exception {
    }

    public void startLayoutMasterSet(Value[] valueArray, Context context) throws Exception {
    }

    public void endLayoutMasterSet(Context context) throws Exception {
    }

    public void startPageSequenceMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endPageSequenceMaster(Context context) throws Exception {
    }

    public void startSinglePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endSinglePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterAlternatives(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterAlternatives(Context context) throws Exception {
    }

    public void startConditionalPageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endConditionalPageMasterReference(Context context) throws Exception {
    }

    public void startSimplePageMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endSimplePageMaster(Context context) throws Exception {
    }

    public void startRegionBody(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBody(Context context) throws Exception {
    }

    public void startRegionBefore(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBefore(Context context) throws Exception {
    }

    public void startRegionAfter(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionAfter(Context context) throws Exception {
    }

    public void startRegionStart(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionStart(Context context) throws Exception {
    }

    public void startRegionEnd(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionEnd(Context context) throws Exception {
    }

    public void startFlow(Flow flow, Value[] valueArray, Context context) throws Exception {
    }

    public void endFlow(Context context) throws Exception {
    }

    public void startStaticContent(Flow flow, Value[] valueArray, Context context) throws Exception {
    }

    public void endStaticContent(Context context) throws Exception {
    }

    public void startTitle(Value[] valueArray, Context context) throws Exception {
    }

    public void endTitle(Context context) throws Exception {
    }

    public void startBlock(Value[] valueArray, Context context) throws Exception {
    }

    public void endBlock(Context context) throws Exception {
    }

    public void startBlockContainer(Value[] valueArray, Context context) throws Exception {
    }

    public void endBlockContainer(Context context) throws Exception {
    }

    public void startBidiOverride(Value[] valueArray, Context context) throws Exception {
    }

    public void endBidiOverride(Context context) throws Exception {
    }

    public void startCharacter(Value[] valueArray, Context context) throws Exception {
    }

    public void endCharacter(Context context) throws Exception {
    }

    public void startInitialPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endInitialPropertySet(Context context) throws Exception {
    }

    public void startExternalGraphic(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
    }

    public void endExternalGraphic(Context context) throws Exception {
    }

    public void startInstreamForeignObject(Value[] valueArray, Context context) throws Exception {
    }

    public void endInstreamForeignObject(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
    }

    public void startInline(Value[] valueArray, Context context) throws Exception {
    }

    public void endInline(Context context) throws Exception {
    }

    public void startInlineContainer(Value[] valueArray, Context context) throws Exception {
    }

    public void endInlineContainer(Context context) throws Exception {
    }

    public void startLeader(Value[] valueArray, Context context) throws Exception {
    }

    public void endLeader(Context context) throws Exception {
    }

    public void startPageNumber(Value[] valueArray, Context context) throws Exception {
    }

    public void endPageNumber(Context context) throws Exception {
    }

    public void startPageNumberCitation(Value[] valueArray, Context context) throws Exception {
    }

    public void endPageNumberCitation(Context context) throws Exception {
    }

    public void startTableAndCaption(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableAndCaption(Context context) throws Exception {
    }

    public void startTable(Value[] valueArray, Context context) throws Exception {
    }

    public void endTable(Context context) throws Exception {
    }

    public void startTableColumn(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableColumn(Context context) throws Exception {
    }

    public void startTableCaption(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableCaption(Context context) throws Exception {
    }

    public void startTableHeader(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableHeader(Context context) throws Exception {
    }

    public void startTableFooter(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableFooter(Context context) throws Exception {
    }

    public void startTableBody(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableBody(Context context) throws Exception {
    }

    public void startTableRow(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableRow(Context context) throws Exception {
    }

    public void startTableCell(Value[] valueArray, Context context) throws Exception {
    }

    public void endTableCell(Context context) throws Exception {
    }

    public void startListBlock(Value[] valueArray, Context context) throws Exception {
    }

    public void endListBlock(Context context) throws Exception {
    }

    public void startListItem(Value[] valueArray, Context context) throws Exception {
    }

    public void endListItem(Context context) throws Exception {
    }

    public void startListItemBody(Value[] valueArray, Context context) throws Exception {
    }

    public void endListItemBody(Context context) throws Exception {
    }

    public void startListItemLabel(Value[] valueArray, Context context) throws Exception {
    }

    public void endListItemLabel(Context context) throws Exception {
    }

    public void startBasicLink(Value[] valueArray, Context context) throws Exception {
    }

    public void endBasicLink(Context context) throws Exception {
    }

    public void startMultiSwitch(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiSwitch(Context context) throws Exception {
    }

    public void startMultiCase(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiCase(Context context) throws Exception {
    }

    public void startMultiToggle(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiToggle(Context context) throws Exception {
    }

    public void startMultiProperties(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiProperties(Context context) throws Exception {
    }

    public void startMultiPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiPropertySet(Context context) throws Exception {
    }

    public void startFloat(Value[] valueArray, Context context) throws Exception {
    }

    public void endFloat(Context context) throws Exception {
    }

    public void startFootnote(Value[] valueArray, Context context) throws Exception {
    }

    public void endFootnote(Context context) throws Exception {
    }

    public void startFootnoteBody(Value[] valueArray, Context context) throws Exception {
    }

    public void endFootnoteBody(Context context) throws Exception {
    }

    public void startWrapper(Value[] valueArray, Context context) throws Exception {
    }

    public void endWrapper(Context context) throws Exception {
    }

    public void startMarker(Value[] valueArray, Context context) throws Exception {
    }

    public void endMarker(Context context) throws Exception {
    }

    public void startRetrieveMarker(Value[] valueArray, Context context) throws Exception {
    }

    public void endRetrieveMarker(Context context) throws Exception {
    }

    public boolean supportsExtension(String string) {
        return false;
    }

    public void startForeignObject(String string, String string2, Attributes attributes, Context context) throws Exception {
    }

    public void endForeignObject(String string, String string2, Context context) throws Exception {
    }

    protected String resolve(String string) throws Exception {
        if (this.uriResolver != null) {
            String string2 = null;
            try {
                string2 = this.uriResolver.resolve(string);
            }
            catch (Exception exception) {
                this.warning("URI resolver error: " + exception.getMessage());
            }
            return string2;
        }
        return string;
    }

    protected void warning(String string) throws Exception {
        this.errorHandler.warning(new Exception(string));
    }

    public void error(Exception exception) throws Exception {
        throw exception;
    }

    public void warning(Exception exception) throws Exception {
        String string = exception.getMessage();
        System.err.println("warning: " + string);
    }

    public static interface UriResolver {
        public String resolve(String var1) throws Exception;
    }
}

