/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.GraphicLayout;
import com.xmlmind.fo.converter.MsTranslator;
import com.xmlmind.fo.converter.docx.Bookmark;
import com.xmlmind.fo.converter.docx.Caption;
import com.xmlmind.fo.converter.docx.ContentTypes;
import com.xmlmind.fo.converter.docx.DocumentSettings;
import com.xmlmind.fo.converter.docx.DocxGraphicEnv;
import com.xmlmind.fo.converter.docx.FontFace;
import com.xmlmind.fo.converter.docx.FontTable;
import com.xmlmind.fo.converter.docx.Footers;
import com.xmlmind.fo.converter.docx.Footnote;
import com.xmlmind.fo.converter.docx.Footnotes;
import com.xmlmind.fo.converter.docx.Headers;
import com.xmlmind.fo.converter.docx.Images;
import com.xmlmind.fo.converter.docx.Leader;
import com.xmlmind.fo.converter.docx.Link;
import com.xmlmind.fo.converter.docx.List;
import com.xmlmind.fo.converter.docx.ListItem;
import com.xmlmind.fo.converter.docx.NumberingDefinitions;
import com.xmlmind.fo.converter.docx.PageReference;
import com.xmlmind.fo.converter.docx.Paragraph;
import com.xmlmind.fo.converter.docx.ParagraphProperties;
import com.xmlmind.fo.converter.docx.Picture;
import com.xmlmind.fo.converter.docx.Relationships;
import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Section;
import com.xmlmind.fo.converter.docx.State;
import com.xmlmind.fo.converter.docx.StaticContent;
import com.xmlmind.fo.converter.docx.Table;
import com.xmlmind.fo.converter.docx.TableAndCaption;
import com.xmlmind.fo.converter.docx.TableColumn;
import com.xmlmind.fo.converter.docx.Text;
import com.xmlmind.fo.converter.docx.TmpGraphicEnv;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.converter.docx.sdt.CustomXml;
import com.xmlmind.fo.converter.docx.sdt.CustomXmlProperties;
import com.xmlmind.fo.converter.docx.sdt.SdtComboBox;
import com.xmlmind.fo.converter.docx.sdt.SdtDataBinding;
import com.xmlmind.fo.converter.docx.sdt.SdtDate;
import com.xmlmind.fo.converter.docx.sdt.SdtDefaultImage;
import com.xmlmind.fo.converter.docx.sdt.SdtElement;
import com.xmlmind.fo.converter.docx.sdt.SdtImageData;
import com.xmlmind.fo.converter.docx.sdt.SdtPicture;
import com.xmlmind.fo.converter.docx.sdt.SdtTextField;
import com.xmlmind.fo.font.GenericFamilies;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactories;
import com.xmlmind.fo.objects.Flow;
import com.xmlmind.fo.objects.PageMasterReference;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.PageSequenceMaster;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoding;
import com.xmlmind.fo.util.TempFile;
import com.xmlmind.fo.util.URLUtil;
import com.xmlmind.fo.zip.ZipFile;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;

public class DocxTranslator
extends MsTranslator {
    private static final double DEFAULT_PAGE_WIDTH = 595.275590551181;
    private static final double DEFAULT_PAGE_HEIGHT = 841.8897637795275;
    private static final String DEFAULT_ENCODING = "UTF8";
    private static final String NAME_MAIN_DOCUMENT = "document.xml";
    private static final String NAME_DOCUMENT_SETTINGS = "settings.xml";
    private static final String NAME_FONT_TABLE = "fonts.xml";
    private static final String NAME_NUMBERING_DEFINITIONS = "numbering.xml";
    private static final String NAME_FOOTNOTES = "footnotes.xml";
    private static final String CUSTOMXML_DIR = "customXml";
    private static final String CUSTOMXML_FILE = "item1.xml";
    private static final String CUSTOMXML_PROPS = "itemProps1.xml";
    private static final String NAME_CUSTOMXML = "customXml/item1.xml";
    private static final String NAME_CUSTOMXML_PROPERTIES = "customXml/itemProps1.xml";
    private static final String SDT_NAMESPACE_URI = "http://www.xmlmind.com/foconverter/xsl/extensions/docx/sdt";
    private static final int SDT_TEXT_FIELD = 1;
    private static final int SDT_DROP_DOWN_LIST = 2;
    private static final int SDT_LIST_ENTRY = 3;
    private static final int SDT_COMBO_BOX = 4;
    private static final int SDT_DATE = 5;
    private static final int SDT_PICTURE = 6;
    private static final int SDT_IMAGE_DATA = 7;
    private static final int SDT_CONFIGURATION = 8;
    private static final Hashtable SDT_LOOKUP = new Hashtable();
    private ContentTypes contentTypes;
    private Relationships pkgRelationships = new Relationships();
    private Relationships docRelationships;
    private Vector tmpFiles;
    private String encoding;
    private String documentPath;
    private PrintWriter documentWriter;
    private int bookmarkId;
    private DocumentSettings settings;
    private FontTable fontTable;
    private NumberingDefinitions numberings;
    private Footnotes footnotes;
    private Images images;
    private boolean prescaleImages;
    private int imageResolution;
    private int imageRendererResolution;
    private boolean alwaysSaveAsPNG;
    private Headers headers;
    private Footers footers;
    private SimplePageMaster oddPageMaster;
    private SimplePageMaster evenPageMaster;
    private SimplePageMaster firstPageMaster;
    private State state;
    private Section section;
    private StaticContent staticContent;
    private Paragraph paragraph;
    private Vector bookmarks;
    private boolean sdtExtension;
    private Vector sdtStack;
    private SdtElement sdtElement;
    private String sdtBinding;
    private int sdtPictureId;
    private File sdtDefaultImage;
    private SdtImageData sdtImageData;
    private String sdtImageFormat;
    private String customXmlTemplate;
    private String prefixMappings;
    private CustomXml customXml;
    private CustomXmlProperties customXmlProperties;

    public DocxTranslator() {
        this.pkgRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument", NAME_MAIN_DOCUMENT);
        this.settings = new DocumentSettings();
    }

    public static String[] listEncodings() {
        return new String[]{"UTF-8", "UTF-16"};
    }

    public void abort() {
        try {
            this.clean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String systemFont(int n) {
        return "10pt serif";
    }

    public double fontSize(int n, double d) {
        double d2 = 10.0;
        switch (n) {
            case 236: {
                d2 = 6.0;
                break;
            }
            case 243: {
                d2 = 8.0;
                break;
            }
            case 182: {
                d2 = 10.0;
                break;
            }
            case 118: {
                d2 = 12.0;
                break;
            }
            case 95: {
                d2 = 14.0;
                break;
            }
            case 239: {
                d2 = 16.0;
                break;
            }
            case 235: {
                d2 = 18.0;
                break;
            }
            case 96: {
                d2 = 2.0 * (double)Math.round(d / 2.0 + 1.0);
                break;
            }
            case 183: {
                d2 = 2.0 * (double)Math.round(d / 2.0 - 1.0);
                if (!(d2 < 2.0)) break;
                d2 = 2.0;
                break;
            }
        }
        return d2;
    }

    public double referenceWidth() {
        if (this.state != null) {
            return this.state.referenceWidth;
        }
        return 0.0;
    }

    private void clean() throws Exception {
        if (this.documentWriter != null) {
            this.documentWriter.close();
            this.documentWriter = null;
        }
        this.deleteTmpFiles();
    }

    private void deleteTmpFiles() {
        if (this.tmpFiles != null) {
            int n = this.tmpFiles.size();
            for (int i = 0; i < n; ++i) {
                File file = (File)this.tmpFiles.elementAt(i);
                file.delete();
            }
            this.tmpFiles = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    public void startDocument() throws Exception {
        String string;
        this.contentTypes = new ContentTypes();
        this.contentTypes.addOverride("/document.xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml");
        this.contentTypes.addOverride("/settings.xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml");
        this.contentTypes.addOverride("/fonts.xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml");
        this.contentTypes.addOverride("/numbering.xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml");
        this.contentTypes.addOverride("/footnotes.xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml");
        this.docRelationships = new Relationships();
        this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings", NAME_DOCUMENT_SETTINGS);
        this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable", NAME_FONT_TABLE);
        this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering", NAME_NUMBERING_DEFINITIONS);
        this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes", NAME_FOOTNOTES);
        this.tmpFiles = new Vector();
        this.encoding = this.properties.getProperty("outputEncoding");
        if (this.encoding == null) {
            this.encoding = DEFAULT_ENCODING;
        }
        if ((string = Encoding.internalName(this.encoding)) == null || !string.equals(DEFAULT_ENCODING) && !string.equals("UTF16")) {
            throw new Exception("unsupported encoding \"" + this.encoding + "\"");
        }
        this.encoding = string;
        File file = TempFile.create("xfc", null);
        this.tmpFiles.addElement(file);
        this.documentPath = file.getPath();
        FileOutputStream fileOutputStream = new FileOutputStream(this.documentPath);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fileOutputStream), this.encoding);
        this.documentWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        this.bookmarkId = 0;
        this.settings.singleSided = this.singleSided();
        this.settings.mirrorMargins = true;
        this.fontTable = new FontTable();
        GenericFamilies genericFamilies = this.genericFontFamilies(null, null, null);
        this.fontTable.add(new FontFace(genericFamilies.serif, "roman"));
        this.fontTable.aliasFontFamily("serif", genericFamilies.serif);
        this.fontTable.add(new FontFace(genericFamilies.sansSerif, "swiss"));
        this.fontTable.aliasFontFamily("sans-serif", genericFamilies.sansSerif);
        this.fontTable.add(new FontFace(genericFamilies.monospace, "modern"));
        this.fontTable.aliasFontFamily("monospace", genericFamilies.monospace);
        if (genericFamilies.fantasy != null) {
            this.fontTable.add(new FontFace(genericFamilies.fantasy, "decorative"));
            this.fontTable.aliasFontFamily("fantasy", genericFamilies.fantasy);
        }
        if (genericFamilies.cursive != null) {
            this.fontTable.add(new FontFace(genericFamilies.cursive, "script"));
            this.fontTable.aliasFontFamily("cursive", genericFamilies.cursive);
        }
        this.numberings = new NumberingDefinitions();
        this.footnotes = new Footnotes();
        this.images = new Images();
        this.prescaleImages = this.prescaleImages();
        this.imageResolution = this.imageResolution();
        this.imageRendererResolution = this.imageRendererResolution();
        this.alwaysSaveAsPNG = this.alwaysSaveAsPNG();
        this.headers = new Headers();
        this.footers = new Footers();
        this.sdtExtension = false;
        this.sdtStack = new Vector();
        this.sdtElement = null;
        this.sdtBinding = null;
        this.sdtPictureId = 0;
        this.sdtDefaultImage = null;
        this.sdtImageData = null;
        this.customXmlTemplate = null;
        this.prefixMappings = null;
        this.customXml = null;
        this.customXmlProperties = null;
        this.documentWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(this.encoding) + "\"?>");
        this.documentWriter.println("<w:document xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:p=\"http://schemas.openxmlformats.org/drawingml/2006/picture\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:v=\"urn:schemas-microsoft-com:vml\">");
        this.documentWriter.println("<w:body>");
    }

    public void endDocument() throws Exception {
        Object object;
        if (this.section != null) {
            this.section.isLast = true;
            this.section.end(this.documentWriter);
        }
        this.documentWriter.println("</w:body>");
        this.documentWriter.println("</w:document>");
        this.documentWriter.flush();
        this.documentWriter.close();
        this.documentWriter = null;
        if (this.customXmlProperties != null) {
            this.contentTypes.addOverride("/customXml/itemProps1.xml", "application/vnd.openxmlformats-officedocument.customXmlProperties+xml");
            this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml", NAME_CUSTOMXML);
        }
        ZipFile zipFile = new ZipFile();
        zipFile.add("[Content_Types].xml", this.contentTypes.getBytes(this.encoding));
        zipFile.add("_rels/.rels", this.pkgRelationships.getBytes(this.encoding));
        zipFile.add("_rels/document.xml.rels", this.docRelationships.getBytes(this.encoding));
        zipFile.add(NAME_MAIN_DOCUMENT, this.documentPath);
        zipFile.add(NAME_DOCUMENT_SETTINGS, this.settings.getBytes(this.encoding));
        zipFile.add(NAME_FONT_TABLE, this.fontTable.getBytes(this.encoding));
        zipFile.add(NAME_NUMBERING_DEFINITIONS, this.numberings.getBytes(this.encoding));
        this.footnotes.store(zipFile, NAME_FOOTNOTES, this.encoding);
        this.headers.store(zipFile, this.encoding);
        this.footers.store(zipFile, this.encoding);
        this.images.store(zipFile);
        if (this.customXmlProperties != null) {
            if (this.customXmlTemplate != null) {
                zipFile.add(NAME_CUSTOMXML, this.customXmlTemplate);
            } else {
                zipFile.add(NAME_CUSTOMXML, this.customXml.getBytes(this.encoding));
            }
            zipFile.add(NAME_CUSTOMXML_PROPERTIES, this.customXmlProperties.getBytes(this.encoding));
            object = new Relationships();
            ((Relationships)object).add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps", CUSTOMXML_PROPS);
            zipFile.add("customXml/_rels/item1.xml.rels", ((Relationships)object).getBytes(this.encoding));
        }
        if (this.output != null) {
            Object object2;
            object = this.output.getByteStream();
            boolean bl = false;
            if (object == null) {
                object2 = this.output.getFileName();
                if (object2 != null) {
                    object = new FileOutputStream((String)object2);
                    bl = true;
                } else {
                    object = System.out;
                }
            }
            object2 = new BufferedOutputStream((OutputStream)object);
            zipFile.write((OutputStream)object2);
            ((OutputStream)object2).flush();
            if (bl) {
                ((OutputStream)object2).close();
            }
        }
        this.deleteTmpFiles();
    }

    public void characters(String string, Context context) throws Exception {
        if (this.state.skipContent) {
            return;
        }
        if (this.sdtExtension) {
            this.sdtCharacters(string);
            return;
        }
        if (this.state.runProperties == null) {
            this.state.runProperties = this.runProperties(context);
        }
        boolean bl = false;
        if (context.whiteSpaceTreatment() == 152) {
            bl = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        if (this.paragraph == null) {
            this.startParagraph(context);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                this.paragraph.addBreak(this.state.runProperties);
                continue;
            }
            Text text = new Text(string2, this.state.runProperties, bl);
            this.paragraph.add(text);
        }
    }

    private RunProperties runProperties(Context context) {
        return new RunProperties(context, this.fontTable);
    }

    private void startParagraph(Context context) {
        this.paragraph = new Paragraph(new ParagraphProperties(context));
        if (this.bookmarks != null && this.state.context != 2) {
            this.paragraph.bookmarks = this.bookmarks();
            this.bookmarks = null;
        }
    }

    private Bookmark[] bookmarks() {
        Bookmark[] bookmarkArray = new Bookmark[this.bookmarks.size()];
        for (int i = 0; i < bookmarkArray.length; ++i) {
            bookmarkArray[i] = (Bookmark)this.bookmarks.elementAt(i);
        }
        return bookmarkArray;
    }

    private void endParagraph() throws Exception {
        int n = this.state.context;
        double d = this.state.referenceWidth;
        if (this.paragraph.isEmpty()) {
            this.paragraph = null;
            return;
        }
        switch (n) {
            case 4: {
                this.state.table.add(this.paragraph);
                break;
            }
            case 5: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.state.tableAndCaption.caption.add(this.paragraph);
                break;
            }
            case 2: {
                this.state.listItem.setLabel(this.paragraph);
                break;
            }
            case 3: {
                this.state.listItem.add(this.paragraph);
                break;
            }
            case 7: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.state.footnote.add(this.paragraph);
                break;
            }
            case 8: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.staticContent.add(this.paragraph);
                break;
            }
            default: {
                if (this.paragraph.requiresLayout()) {
                    this.paragraph.layout(d);
                }
                this.paragraph.print(this.documentWriter);
            }
        }
        this.paragraph = null;
    }

    public void startRoot(Value[] valueArray, Context context) throws Exception {
    }

    public void endRoot(Context context) throws Exception {
    }

    public void startDeclarations(Value[] valueArray, Context context) throws Exception {
    }

    public void endDeclarations(Context context) throws Exception {
    }

    public void startColorProfile(Value[] valueArray, Context context) throws Exception {
    }

    public void endColorProfile(Context context) throws Exception {
    }

    public void startPageSequence(PageSequence pageSequence, Value[] valueArray, Context context) throws Exception {
        if (this.section != null) {
            this.section.end(this.documentWriter);
        }
        this.selectPageMasters(pageSequence);
        if (this.settings.singleSided) {
            this.evenPageMaster = null;
        }
        this.section = new Section();
        this.section.pageWidth = 595.275590551181;
        this.section.pageHeight = 841.8897637795275;
        this.section.initialize(this.oddPageMaster, this.evenPageMaster, this.firstPageMaster, pageSequence);
        if (!this.section.mirrorMargins) {
            this.settings.mirrorMargins = false;
        }
        this.section.start(this.documentWriter);
        this.state = new State(31);
        this.state.referenceWidth = this.section.columnWidth;
        this.staticContent = null;
        this.paragraph = null;
        this.bookmarks = null;
        if (valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    private void selectPageMasters(PageSequence pageSequence) {
        int n;
        this.oddPageMaster = null;
        this.evenPageMaster = null;
        this.firstPageMaster = null;
        if (pageSequence.pageMaster != null) {
            this.oddPageMaster = pageSequence.pageMaster;
            return;
        }
        PageSequenceMaster pageSequenceMaster = pageSequence.pageSequenceMaster;
        PageMasterReference pageMasterReference = pageSequenceMaster.subSequence(0);
        switch (pageMasterReference.type) {
            case 1: {
                this.firstPageMaster = pageMasterReference.pageMaster;
                break;
            }
            case 2: {
                if (pageMasterReference.maximumRepeats != 1) break;
                this.firstPageMaster = pageMasterReference.pageMaster;
                break;
            }
        }
        PageMasterReference pageMasterReference2 = null;
        int n2 = pageSequenceMaster.subSequences.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            pageMasterReference = pageSequenceMaster.subSequence(n);
            if (pageMasterReference.maximumRepeats < 0) {
                pageMasterReference2 = pageMasterReference;
                break;
            }
            if (pageMasterReference.maximumRepeats <= n3) continue;
            n3 = pageMasterReference.maximumRepeats;
            pageMasterReference2 = pageMasterReference;
        }
        if (pageMasterReference2.type == 3) {
            n2 = pageMasterReference2.alternatives.size();
            block12: for (n = 0; n < n2; ++n) {
                PageMasterReference pageMasterReference3 = pageMasterReference2.alternative(n);
                if (pageMasterReference3.blankOrNotBlank == 21) continue;
                switch (pageMasterReference3.pagePosition) {
                    case 97: {
                        continue block12;
                    }
                    case 66: {
                        if (this.firstPageMaster != null) continue block12;
                        this.firstPageMaster = pageMasterReference3.pageMaster;
                        continue block12;
                    }
                    default: {
                        switch (pageMasterReference3.oddOrEven) {
                            case 56: {
                                this.evenPageMaster = pageMasterReference3.pageMaster;
                                continue block12;
                            }
                        }
                        this.oddPageMaster = pageMasterReference3.pageMaster;
                    }
                }
            }
            if (this.oddPageMaster == null) {
                this.oddPageMaster = pageMasterReference2.alternative((int)0).pageMaster;
            }
        } else {
            this.oddPageMaster = pageMasterReference2.pageMaster;
        }
        if (this.firstPageMaster == this.oddPageMaster) {
            this.firstPageMaster = null;
        }
    }

    public void endPageSequence(Context context) throws Exception {
    }

    public void startLayoutMasterSet(Value[] valueArray, Context context) throws Exception {
    }

    public void endLayoutMasterSet(Context context) throws Exception {
    }

    public void startPageSequenceMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endPageSequenceMaster(Context context) throws Exception {
    }

    public void startSinglePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endSinglePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterAlternatives(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterAlternatives(Context context) throws Exception {
    }

    public void startConditionalPageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endConditionalPageMasterReference(Context context) throws Exception {
    }

    public void startSimplePageMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endSimplePageMaster(Context context) throws Exception {
    }

    public void startRegionBody(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBody(Context context) throws Exception {
    }

    public void startRegionBefore(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBefore(Context context) throws Exception {
    }

    public void startRegionAfter(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionAfter(Context context) throws Exception {
    }

    public void startRegionStart(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionStart(Context context) throws Exception {
    }

    public void startRegionEnd(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionEnd(Context context) throws Exception {
    }

    public void startFlow(Flow flow, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(10);
        this.state.referenceWidth = this.section.columnWidth;
        if (flow.region(this.oddPageMaster) != 0) {
            this.state.skipContent = true;
            return;
        }
        if (valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endFlow(Context context) throws Exception {
        if (!this.state.skipContent && this.bookmarks != null) {
            this.writeBookmarks();
            this.bookmarks = null;
        }
        this.state = this.state.restore();
    }

    public void startStaticContent(Flow flow, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(44);
        this.state.referenceWidth = this.section.contentWidth;
        String string = null;
        switch (flow.region(this.oddPageMaster)) {
            case 1: {
                this.section.oddHeaderId = string = this.createHeader();
                if (this.settings.singleSided || this.evenPageMaster != null) break;
                this.section.evenHeaderId = string;
                break;
            }
            case 2: {
                this.section.oddFooterId = string = this.createFooter();
                if (this.settings.singleSided || this.evenPageMaster != null) break;
                this.section.evenFooterId = string;
            }
        }
        if (this.evenPageMaster != null) {
            switch (flow.region(this.evenPageMaster)) {
                case 1: {
                    if (string == null) {
                        string = this.createHeader();
                    }
                    this.section.evenHeaderId = string;
                    break;
                }
                case 2: {
                    if (string == null) {
                        string = this.createFooter();
                    }
                    this.section.evenFooterId = string;
                }
            }
        }
        if (this.firstPageMaster != null) {
            switch (flow.region(this.firstPageMaster)) {
                case 1: {
                    if (string == null) {
                        string = this.createHeader();
                    }
                    this.section.firstHeaderId = string;
                    break;
                }
                case 2: {
                    if (string == null) {
                        string = this.createFooter();
                    }
                    this.section.firstFooterId = string;
                }
            }
        }
        if (string == null) {
            this.state.skipContent = true;
        }
    }

    private String createHeader() throws Exception {
        this.staticContent = new StaticContent(0);
        String string = this.headers.add(this.staticContent);
        this.contentTypes.addOverride("/" + string, "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml");
        return this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header", string);
    }

    private String createFooter() throws Exception {
        this.staticContent = new StaticContent(1);
        String string = this.footers.add(this.staticContent);
        this.contentTypes.addOverride("/" + string, "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml");
        return this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer", string);
    }

    public void endStaticContent(Context context) throws Exception {
        this.staticContent = null;
        this.state = this.state.restore();
    }

    public void startTitle(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(54);
    }

    public void endTitle(Context context) throws Exception {
        this.state = this.state.restore();
    }

    private void addBookmark(String string, Context context) {
        Bookmark bookmark = new Bookmark(this.bookmarkId++, string, context);
        if (this.bookmarks == null) {
            this.bookmarks = new Vector();
        }
        this.bookmarks.addElement(bookmark);
    }

    private void writeBookmarks() {
        int n;
        Bookmark[] bookmarkArray = this.bookmarks();
        for (n = 0; n < bookmarkArray.length; ++n) {
            bookmarkArray[n].start(this.documentWriter);
        }
        for (n = bookmarkArray.length - 1; n >= 0; --n) {
            bookmarkArray[n].end(this.documentWriter);
        }
    }

    public void startBlock(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(2);
        if (!this.state.skipContent) {
            if (this.paragraph != null) {
                this.endParagraph();
            }
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endBlock(Context context) throws Exception {
        if (!this.state.skipContent && this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.restore();
    }

    public void startBlockContainer(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(3);
    }

    public void endBlockContainer(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startBidiOverride(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(1);
    }

    public void endBidiOverride(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startCharacter(Value[] valueArray, Context context) throws Exception {
    }

    public void endCharacter(Context context) throws Exception {
    }

    public void startInitialPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endInitialPropertySet(Context context) throws Exception {
    }

    public void startExternalGraphic(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(8);
        if (!this.state.skipContent) {
            if (valueArray[125] != null) {
                this.startBookmark(valueArray[125].id(), context);
            }
            Relationships relationships = this.state.footnote != null ? this.footnotes.relationships() : (this.staticContent != null ? this.staticContent.relationships() : this.docRelationships);
            DocxGraphicEnv docxGraphicEnv = new DocxGraphicEnv(graphicEnv, this.images, relationships);
            Picture picture = new Picture(graphic, docxGraphicEnv, this.runProperties(context), this.prescaleImages, this.imageResolution, this.imageRendererResolution, this.alwaysSaveAsPNG, this.useVML());
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(picture);
        }
    }

    private boolean useVML() {
        return "true".equals(this.properties.getProperty("docx.useVML"));
    }

    public void endExternalGraphic(Context context) throws Exception {
        if (!this.state.skipContent && this.state.bookmark != null) {
            this.endBookmark();
        }
        this.state = this.state.restore();
    }

    public void startInstreamForeignObject(Value[] valueArray, Context context) throws Exception {
    }

    public void endInstreamForeignObject(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(16);
        if (!this.state.skipContent) {
            if (valueArray[125] != null) {
                this.startBookmark(valueArray[125].id(), context);
            }
            Relationships relationships = this.state.footnote != null ? this.footnotes.relationships() : (this.staticContent != null ? this.staticContent.relationships() : this.docRelationships);
            DocxGraphicEnv docxGraphicEnv = new DocxGraphicEnv(graphicEnv, this.images, relationships);
            Picture picture = new Picture(graphic, docxGraphicEnv, this.runProperties(context), this.prescaleImages, this.imageResolution, this.imageRendererResolution, this.alwaysSaveAsPNG, this.useVML());
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(picture);
            if (this.state.bookmark != null) {
                this.endBookmark();
            }
        }
        this.state = this.state.restore();
    }

    public void startInline(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(14);
        if (!this.state.skipContent && valueArray[125] != null) {
            this.startBookmark(valueArray[125].id(), context);
        }
    }

    public void endInline(Context context) throws Exception {
        if (!this.state.skipContent && this.state.bookmark != null) {
            this.endBookmark();
        }
        this.state = this.state.restore();
    }

    public void startInlineContainer(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(15);
    }

    public void endInlineContainer(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startLeader(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(18);
        if (!this.state.skipContent) {
            Leader leader = new Leader(context);
            leader.properties = this.runProperties(context);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(leader);
            this.state.skipContent = true;
        }
    }

    public void endLeader(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startPageNumber(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(29);
        if (!this.state.skipContent) {
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.addPageNumber(this.runProperties(context));
        }
    }

    public void endPageNumber(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startPageNumberCitation(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(30);
        if (!this.state.skipContent && valueArray[226] != null) {
            String string = valueArray[226].idref();
            PageReference pageReference = new PageReference(string, context);
            pageReference.properties = this.runProperties(context);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(pageReference);
        }
    }

    public void endPageNumberCitation(Context context) throws Exception {
        this.state = this.state.restore();
    }

    private void startBookmark(String string, Context context) {
        this.state.bookmark = new Bookmark(this.bookmarkId++, string, context);
        if (this.paragraph == null) {
            this.startParagraph(context);
        }
        this.paragraph.startBookmark(this.state.bookmark);
    }

    private void endBookmark() {
        this.paragraph.endBookmark(this.state.bookmark);
    }

    public void startTableAndCaption(Value[] valueArray, Context context) throws Exception {
        if (this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(46);
        if (!this.state.skipContent) {
            this.state.tableAndCaption = new TableAndCaption(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        } else {
            this.state.tableAndCaption = null;
        }
    }

    public void endTableAndCaption(Context context) throws Exception {
        TableAndCaption tableAndCaption = this.state.tableAndCaption;
        this.state = this.state.restore();
        if (tableAndCaption != null) {
            switch (this.state.context) {
                case 4: {
                    this.state.table.add(tableAndCaption);
                    break;
                }
                case 3: {
                    this.state.listItem.add(tableAndCaption);
                    break;
                }
                case 8: {
                    tableAndCaption.layout(this.state.referenceWidth, this.numberings);
                    this.staticContent.add(tableAndCaption);
                    break;
                }
                default: {
                    tableAndCaption.layout(this.state.referenceWidth, this.numberings);
                    tableAndCaption.print(this.documentWriter);
                }
            }
        }
    }

    public void startTable(Value[] valueArray, Context context) throws Exception {
        if (this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(45);
        if (!this.state.skipContent) {
            this.state.table = new Table(context);
            if (context.parent().fo == 46) {
                this.state.tableAndCaption.table = this.state.table;
            }
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        } else {
            this.state.table = null;
        }
    }

    public void endTable(Context context) throws Exception {
        Table table = null;
        if (context.parent().fo != 46) {
            table = this.state.table;
        }
        this.state = this.state.restore();
        if (table != null) {
            switch (this.state.context) {
                case 4: {
                    this.state.table.add(table);
                    break;
                }
                case 3: {
                    this.state.listItem.add(table);
                    break;
                }
                case 8: {
                    table.layout(this.state.referenceWidth, this.numberings);
                    this.staticContent.add(table);
                    break;
                }
                default: {
                    table.layout(this.state.referenceWidth, this.numberings);
                    table.print(this.documentWriter);
                }
            }
        }
    }

    public void startTableColumn(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(50);
        if (!this.state.skipContent) {
            this.state.table.add(new TableColumn(context));
        }
    }

    public void endTableColumn(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startTableCaption(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(48);
        if (!this.state.skipContent) {
            this.state.tableAndCaption.caption = new Caption(context);
            this.state.bookmarks = this.bookmarks;
            this.bookmarks = null;
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableCaption(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.bookmarks = this.state.bookmarks;
        }
        this.state = this.state.restore();
    }

    public void startTableHeader(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(52);
        if (!this.state.skipContent) {
            this.state.table.startHeader(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableHeader(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endHeader();
        }
        this.state = this.state.restore();
    }

    public void startTableFooter(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(51);
        if (!this.state.skipContent) {
            this.state.table.startFooter(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableFooter(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endFooter();
        }
        this.state = this.state.restore();
    }

    public void startTableBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(47);
        if (!this.state.skipContent) {
            this.state.table.startBody(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableBody(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endBody();
        }
        this.state = this.state.restore();
    }

    public void startTableRow(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(53);
        if (!this.state.skipContent) {
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
            if (this.bookmarks != null) {
                this.state.table.startRow(context, this.bookmarks());
                this.bookmarks = null;
            } else {
                this.state.table.startRow(context, null);
            }
        }
    }

    public void endTableRow(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endRow();
        }
        this.state = this.state.restore();
    }

    public void startTableCell(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(49);
        if (!this.state.skipContent) {
            this.state.referenceWidth = this.state.table.startCell(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
            context.background = null;
        }
    }

    public void endTableCell(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.state.table.endCell();
        }
        this.state = this.state.restore();
    }

    public void startListBlock(Value[] valueArray, Context context) throws Exception {
        if (this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(19);
        if (!this.state.skipContent) {
            this.state.list = new List(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        } else {
            this.state.list = null;
        }
    }

    public void endListBlock(Context context) throws Exception {
        List list = this.state.list;
        this.state = this.state.restore();
        if (list != null) {
            switch (this.state.context) {
                case 4: {
                    this.state.table.add(list);
                    break;
                }
                case 3: {
                    this.state.listItem.add(list);
                    break;
                }
                case 7: {
                    list.layout(this.state.referenceWidth, this.numberings);
                    this.state.footnote.add(list);
                    break;
                }
                case 8: {
                    list.layout(this.state.referenceWidth, this.numberings);
                    this.staticContent.add(list);
                    break;
                }
                default: {
                    list.layout(this.state.referenceWidth, this.numberings);
                    list.print(this.documentWriter);
                }
            }
        }
    }

    public void startListItem(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(20);
        if (!this.state.skipContent) {
            this.state.listItem = new ListItem(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        } else {
            this.state.listItem = null;
        }
    }

    public void endListItem(Context context) throws Exception {
        ListItem listItem = this.state.listItem;
        this.state = this.state.restore();
        if (listItem != null) {
            this.state.list.add(listItem);
        }
    }

    public void startListItemBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(21);
        if (!this.state.skipContent && valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endListItemBody(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startListItemLabel(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(22);
        if (!this.state.skipContent && valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endListItemLabel(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startBasicLink(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(0);
        if (!this.state.skipContent) {
            Link link = new Link(context);
            if (link.type == 1 && link.target != null) {
                Relationships relationships = this.state.footnote != null ? this.footnotes.relationships() : (this.staticContent != null ? this.staticContent.relationships() : this.docRelationships);
                link.id = relationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink", Wml.escape(link.target), 1);
            }
            this.state.link = link;
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.startLink(this.state.link);
        }
    }

    public void endBasicLink(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.paragraph.endLink(this.state.link);
        }
        this.state = this.state.restore();
    }

    public void startMultiSwitch(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiSwitch(Context context) throws Exception {
    }

    public void startMultiCase(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiCase(Context context) throws Exception {
    }

    public void startMultiToggle(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiToggle(Context context) throws Exception {
    }

    public void startMultiProperties(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiProperties(Context context) throws Exception {
    }

    public void startMultiPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiPropertySet(Context context) throws Exception {
    }

    public void startFloat(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(9);
    }

    public void endFloat(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startFootnote(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(11);
    }

    public void endFootnote(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startFootnoteBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(12);
        if (!this.state.skipContent) {
            this.state.footnote = new Footnote();
            this.state.referenceWidth = this.section.contentWidth;
            this.state.paragraph = this.paragraph;
            this.state.bookmarks = this.bookmarks;
            this.paragraph = null;
            this.bookmarks = null;
        }
    }

    public void endFootnoteBody(Context context) throws Exception {
        if (!this.state.skipContent) {
            this.footnotes.add(this.state.footnote);
            this.paragraph = this.state.paragraph;
            this.bookmarks = this.state.bookmarks;
            if (this.paragraph != null) {
                this.paragraph.addFootnote(this.state.footnote.id);
            }
        }
        this.state = this.state.restore();
    }

    public void startWrapper(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(55);
        if (!this.state.skipContent && valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endWrapper(Context context) throws Exception {
        if (!this.state.skipContent && this.bookmarks != null && this.paragraph != null) {
            if (this.paragraph.bookmarks != null) {
                for (int i = 0; i < this.paragraph.bookmarks.length; ++i) {
                    this.bookmarks.insertElementAt(this.paragraph.bookmarks[i], i);
                }
            }
            this.paragraph.bookmarks = this.bookmarks();
            this.bookmarks = null;
        }
        this.state = this.state.restore();
    }

    public void startMarker(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(23);
    }

    public void endMarker(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startRetrieveMarker(Value[] valueArray, Context context) throws Exception {
    }

    public void endRetrieveMarker(Context context) throws Exception {
    }

    public boolean supportsExtension(String string) {
        return string.equals(SDT_NAMESPACE_URI);
    }

    public void startForeignObject(String string, String string2, Attributes attributes, Context context) throws Exception {
        if (string.equals(SDT_NAMESPACE_URI)) {
            this.startSdtElement(string2, attributes, context);
        }
    }

    public void endForeignObject(String string, String string2, Context context) throws Exception {
        if (string.equals(SDT_NAMESPACE_URI)) {
            this.endSdtElement(string2, context);
        }
    }

    public void startSdtElement(String string, Attributes attributes, Context context) throws Exception {
        int n = DocxTranslator.sdtType(string);
        RunProperties runProperties = this.runProperties(context);
        this.sdtExtension = true;
        this.sdtStack.addElement(new Integer(n));
        if (n < 0) {
            this.warning("unknown element \"" + string + "\"");
            return;
        }
        switch (n) {
            case 1: {
                this.sdtElement = new SdtTextField(attributes, runProperties);
                break;
            }
            case 2: {
                this.sdtElement = new SdtComboBox(attributes, runProperties, false);
                break;
            }
            case 4: {
                this.sdtElement = new SdtComboBox(attributes, runProperties, true);
                break;
            }
            case 5: {
                this.sdtElement = new SdtDate(attributes, runProperties);
                break;
            }
            case 6: {
                this.sdtElement = new SdtPicture(attributes, runProperties);
                this.sdtImageData = null;
                break;
            }
            case 3: {
                if (this.sdtElement == null || !(this.sdtElement instanceof SdtComboBox)) break;
                SdtComboBox sdtComboBox = (SdtComboBox)this.sdtElement;
                sdtComboBox.addEntry(attributes);
                break;
            }
            case 7: {
                String string2 = attributes.getValue("", "format");
                if (string2 == null) {
                    this.warning("attribute \"format\" required for element \"" + string + "\"");
                    break;
                }
                this.sdtImageData = new SdtImageData();
                this.sdtImageFormat = string2;
                break;
            }
            case 8: {
                String string3 = attributes.getValue("", "custom-xml-template");
                if (string3 != null) {
                    this.customXmlTemplate = this.resolve(string3);
                    if (this.customXmlTemplate == null) {
                        throw new Exception("cannot resolve URI \"" + string3 + "\"");
                    }
                    this.customXmlProperties = new CustomXmlProperties();
                }
                this.prefixMappings = attributes.getValue("", "prefix-mappings");
            }
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                this.sdtBinding = attributes.getValue("", "binding");
                if (this.sdtBinding != null && this.customXmlTemplate == null) {
                    if (!DocxTranslator.checkElementName(this.sdtBinding)) {
                        this.warning("bad attribute value: binding=\"" + this.sdtBinding + "\"");
                        this.sdtBinding = null;
                    } else if (this.customXml == null) {
                        this.customXml = new CustomXml();
                        this.customXmlProperties = this.customXml.properties();
                    }
                }
                if (this.paragraph == null) {
                    this.startParagraph(context);
                }
                this.paragraph.add(this.sdtElement);
            }
        }
    }

    public void endSdtElement(String string, Context context) throws Exception {
        Object object;
        int n = DocxTranslator.sdtType(string);
        if (n == 6) {
            Object object2;
            object = (SdtPicture)this.sdtElement;
            File file = null;
            String string2 = this.sdtImageFormat;
            if (this.sdtImageData != null) {
                file = TempFile.create("xfc", null);
                this.tmpFiles.addElement(file);
                try {
                    this.sdtImageData.write(file);
                }
                catch (Exception exception) {
                    this.warning("failed to write image file: " + exception.getMessage());
                    file = null;
                }
                if (file != null) {
                    TmpGraphicEnv tmpGraphicEnv = new TmpGraphicEnv(this.tmpFiles, this.errorHandler);
                    try {
                        object2 = GraphicFactories.createGraphic(URLUtil.fileToLocation(file), string2, null, tmpGraphicEnv);
                        ((SdtPicture)object).setGeometry(GraphicLayout.intrinsicWidth((Graphic)object2, this.imageResolution), GraphicLayout.intrinsicHeight((Graphic)object2, this.imageResolution));
                    }
                    catch (Exception exception) {
                        this.warning("failed to load image: " + exception.getMessage());
                        file = null;
                    }
                }
                if (file != null) {
                    ((SdtPicture)object).setInitialValue(this.sdtImageData.data());
                }
                this.sdtImageData = null;
                this.sdtImageFormat = null;
            }
            if (file == null) {
                if (this.sdtDefaultImage == null) {
                    this.sdtDefaultImage = TempFile.create("xfc", null);
                    this.tmpFiles.addElement(this.sdtDefaultImage);
                    SdtDefaultImage.write(this.sdtDefaultImage);
                }
                file = this.sdtDefaultImage;
                string2 = SdtDefaultImage.format();
            }
            int n2 = this.sdtPictureId;
            this.sdtPictureId += 2;
            object2 = this.images.add(file.getPath(), string2);
            String string3 = this.docRelationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", (String)object2);
            ((SdtPicture)object).setImageData(n2, string3);
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if (this.sdtBinding != null) {
                    object = this.customXmlTemplate != null ? new SdtDataBinding(this.customXmlProperties.id(), this.sdtBinding, this.prefixMappings) : this.customXml.add(this.sdtBinding, this.sdtElement.initialValue(), this.sdtElement.preserveSpace());
                    this.sdtElement.setBinding((SdtDataBinding)object);
                }
                this.sdtElement = null;
            }
        }
        this.sdtStack.removeElementAt(this.sdtStack.size() - 1);
        if (this.sdtStack.size() == 0) {
            this.sdtExtension = false;
        }
    }

    private void sdtCharacters(String string) {
        Integer n = (Integer)this.sdtStack.lastElement();
        int n2 = n;
        switch (n2) {
            case 7: {
                if (this.sdtImageData == null) break;
                this.sdtImageData.append(string);
            }
        }
    }

    private static int sdtType(String string) {
        Integer n = (Integer)SDT_LOOKUP.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    private static boolean checkElementName(String string) {
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0]) && cArray[0] != '_') {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || cArray[i] == '.' || cArray[i] == '-' || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    static {
        SDT_LOOKUP.put("text-field", new Integer(1));
        SDT_LOOKUP.put("drop-down-list", new Integer(2));
        SDT_LOOKUP.put("list-entry", new Integer(3));
        SDT_LOOKUP.put("combo-box", new Integer(4));
        SDT_LOOKUP.put("date", new Integer(5));
        SDT_LOOKUP.put("picture", new Integer(6));
        SDT_LOOKUP.put("image-data", new Integer(7));
        SDT_LOOKUP.put("configuration", new Integer(8));
    }
}

