/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.FontFace;
import com.xmlmind.fo.util.Encoding;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;

public final class FontTable {
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml";
    private int charset;
    private Hashtable fonts = new Hashtable();
    private Vector fontList = new Vector();
    private Hashtable familyAliases = new Hashtable();

    public FontTable() {
        this(-1);
    }

    public FontTable(int n) {
        this.charset = n;
    }

    public void aliasFontFamily(String string, String string2) {
        this.familyAliases.put(string, string2);
    }

    public String unaliasFontFamily(String string) {
        String string2 = (String)this.familyAliases.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public FontFace add(String string) {
        return this.add(string, null);
    }

    public FontFace add(String string, String string2) {
        return this.add(string, string2, this.charset);
    }

    public FontFace add(String string, String string2, int n) {
        return this.add(new FontFace(this.unaliasFontFamily(string), string2, n));
    }

    public FontFace add(FontFace fontFace) {
        FontFace fontFace2 = (FontFace)this.fonts.get(fontFace);
        if (fontFace2 == null) {
            this.fonts.put(fontFace, fontFace);
            this.fontList.addElement(fontFace);
        } else {
            fontFace = fontFace2;
        }
        return fontFace;
    }

    public byte[] getBytes(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(string) + "\"?>");
        this.print(printWriter);
        printWriter.flush();
        return stringWriter.toString().getBytes(string);
    }

    private void print(PrintWriter printWriter) {
        printWriter.println("<w:fonts xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">");
        int n = this.fontList.size();
        for (int i = 0; i < n; ++i) {
            FontFace fontFace = (FontFace)this.fontList.elementAt(i);
            if (fontFace.family == null) continue;
            fontFace.print(printWriter);
        }
        printWriter.println("</w:fonts>");
    }
}

