/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.Footnote;
import com.xmlmind.fo.converter.docx.Relationships;
import com.xmlmind.fo.util.Encoding;
import com.xmlmind.fo.zip.ZipFile;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public final class Footnotes {
    private Vector footnotes = new Vector();
    private Relationships relationships = new Relationships();

    public void add(Footnote footnote) {
        footnote.id = this.footnotes.size() + 1;
        this.footnotes.addElement(footnote);
    }

    public Relationships relationships() {
        return this.relationships;
    }

    public byte[] getBytes(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(string) + "\"?>");
        this.print(printWriter);
        printWriter.flush();
        return stringWriter.toString().getBytes(string);
    }

    private void print(PrintWriter printWriter) {
        printWriter.println("<w:footnotes xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:p=\"http://schemas.openxmlformats.org/drawingml/2006/picture\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:v=\"urn:schemas-microsoft-com:vml\">");
        int n = this.footnotes.size();
        for (int i = 0; i < n; ++i) {
            Footnote footnote = (Footnote)this.footnotes.elementAt(i);
            footnote.print(printWriter);
        }
        printWriter.println("</w:footnotes>");
    }

    public void store(ZipFile zipFile, String string, String string2) throws Exception {
        zipFile.add(string, this.getBytes(string2));
        if (this.relationships.count() > 0) {
            zipFile.add("_rels/" + string + ".rels", this.relationships.getBytes(string2));
        }
    }
}

