/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.MsTranslator;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.properties.PropertyValues;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class Link {
    public static final int TYPE_INTERNAL = 0;
    public static final int TYPE_EXTERNAL = 1;
    public int type;
    public String target;
    public String id;

    public Link(Context context) {
        PropertyValues propertyValues = context.properties;
        if (propertyValues.isSpecified(132)) {
            this.type = 0;
            Value value = propertyValues.values[132];
            this.target = ((MsTranslator)context.translator).checkBookmark(value.idref());
        } else if (propertyValues.isSpecified(100)) {
            this.type = 1;
            Value value = propertyValues.values[100];
            this.target = Link.escape(value.uriSpecification());
        }
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u001f' || c == '\u007f') {
                stringBuffer.append(Link.escape(c));
                continue;
            }
            switch (c) {
                case ' ': 
                case '\"': 
                case '<': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuffer.append(Link.escape(c));
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String escape(char c) {
        return "%" + Integer.toHexString(c | 0x100).substring(1);
    }

    public void start(PrintWriter printWriter) {
        printWriter.print("<w:hyperlink");
        switch (this.type) {
            case 0: {
                if (this.target == null) break;
                printWriter.print(" w:anchor=\"" + Wml.escape(this.target) + "\"");
                break;
            }
            case 1: {
                if (this.id == null) break;
                printWriter.print(" r:id=\"" + this.id + "\"");
            }
        }
        printWriter.println(">");
    }

    public void end(PrintWriter printWriter) {
        printWriter.println("</w:hyperlink>");
    }
}

