/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.ListItem;
import com.xmlmind.fo.converter.docx.Numbering;
import com.xmlmind.fo.converter.docx.NumberingDefinitions;
import com.xmlmind.fo.properties.LabelFormat;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;
import java.util.Vector;

public final class List {
    public static final int TYPE_LIST = 0;
    public static final int TYPE_PLAIN = 1;
    private int type;
    private LabelFormat labelFormat;
    private Numbering numbering;
    private double startIndent;
    private Vector items = new Vector();

    public List(Context context) {
        this(0, context);
    }

    public List(int n, Context context) {
        this.type = n;
        this.initialize(context);
    }

    private void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        Value value = valueArray[321];
        if (value != null && value.type == 30) {
            this.labelFormat = value.labelFormat();
        }
    }

    public void add(ListItem listItem) {
        this.items.addElement(listItem);
    }

    public void layout(double d, NumberingDefinitions numberingDefinitions) throws Exception {
        ListItem listItem;
        int n;
        if (this.items.size() == 0) {
            return;
        }
        int n2 = this.items.size();
        for (n = 0; n < n2; ++n) {
            listItem = (ListItem)this.items.elementAt(n);
            listItem.layout(d, numberingDefinitions);
            if (this.startIndent != 0.0) continue;
            this.startIndent = listItem.labelStart;
        }
        if (this.type == 0) {
            listItem = (ListItem)this.items.elementAt(0);
            this.numbering = listItem.numbering(this.labelFormat);
            if (this.numbering != null) {
                numberingDefinitions.add(this.numbering);
            } else {
                this.type = 1;
            }
        }
        n2 = this.items.size();
        for (n = 0; n < n2; ++n) {
            listItem = (ListItem)this.items.elementAt(n);
            listItem.setup(this.numbering);
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            listItem.print(printWriter);
        }
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            double d2 = listItem.minWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            double d2 = listItem.maxWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double startIndent() {
        return this.startIndent;
    }
}

