/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.List;
import com.xmlmind.fo.converter.docx.Numbering;
import com.xmlmind.fo.converter.docx.NumberingDefinitions;
import com.xmlmind.fo.converter.docx.Paragraph;
import com.xmlmind.fo.converter.docx.ParagraphProperties;
import com.xmlmind.fo.converter.docx.TabStop;
import com.xmlmind.fo.converter.docx.TabStops;
import com.xmlmind.fo.converter.docx.Table;
import com.xmlmind.fo.converter.docx.TableAndCaption;
import com.xmlmind.fo.converter.docx.Text;
import com.xmlmind.fo.properties.LabelFormat;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;
import java.util.Vector;

public final class ListItem {
    public int breakBefore;
    public boolean keepTogether;
    public boolean keepWithNext;
    public double spaceBefore;
    public double spaceAfter;
    public double labelStart;
    public double labelWidth;
    public double labelSeparation;
    public double bodyStart;
    public boolean containsTable;
    public boolean containsList;
    private Paragraph label;
    private Vector body = new Vector();
    private double referenceWidth;

    public ListItem(Context context) {
        this.initialize(context);
    }

    private void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.breakBefore = context.breakBefore;
        this.keepTogether = ListItem.keep(valueArray[137]);
        this.keepWithNext = ListItem.keep(valueArray[141]);
        this.spaceBefore = context.spaceBefore();
        Context context2 = context.ancestor(19);
        valueArray = context2.properties.values;
        this.labelSeparation = valueArray[224].length();
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void setLabel(Paragraph paragraph) {
        if (this.label == null) {
            this.label = paragraph;
        }
    }

    public void add(Paragraph paragraph) {
        this.add(0, paragraph);
    }

    public void add(Table table) {
        this.add(1, table);
        this.containsTable = true;
    }

    public void add(TableAndCaption tableAndCaption) {
        this.add(2, tableAndCaption);
        this.containsTable = true;
    }

    public void add(List list) {
        this.add(3, list);
        this.containsList = true;
    }

    private void add(int n, Object object) {
        this.body.addElement(new Element(n, object));
    }

    public void layout(double d, NumberingDefinitions numberingDefinitions) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (this.body.size() == 0) {
            return;
        }
        if (this.containsTable || this.containsList) {
            int n = this.body.size();
            block11: for (int i = 0; i < n; ++i) {
                object3 = (Element)this.body.elementAt(i);
                switch (((Element)object3).type) {
                    case 1: {
                        object2 = (Table)((Element)object3).object;
                        ((Table)object2).layout(d, numberingDefinitions);
                        continue block11;
                    }
                    case 2: {
                        object = (TableAndCaption)((Element)object3).object;
                        ((TableAndCaption)object).layout(d, numberingDefinitions);
                        continue block11;
                    }
                    case 3: {
                        List list = (List)((Element)object3).object;
                        list.layout(d, numberingDefinitions);
                    }
                }
            }
        }
        Element element = (Element)this.body.firstElement();
        switch (element.type) {
            case 0: {
                Paragraph paragraph = (Paragraph)element.object;
                this.bodyStart = paragraph.properties.startIndent;
                break;
            }
            case 1: {
                object3 = (Table)element.object;
                this.bodyStart = ((Table)object3).startIndent();
                break;
            }
            case 2: {
                object2 = (TableAndCaption)element.object;
                this.bodyStart = ((TableAndCaption)object2).table.startIndent();
                break;
            }
            case 3: {
                object = (List)element.object;
                this.bodyStart = ((List)object).startIndent();
            }
        }
        if (this.label != null) {
            double d2;
            this.labelStart = this.label.properties.startIndent;
            if (this.label.properties.endIndent > 0.0) {
                d2 = d - this.label.properties.endIndent;
                this.labelSeparation = this.bodyStart - d2;
            } else {
                d2 = this.bodyStart - this.labelSeparation;
            }
            this.labelWidth = d2 - this.labelStart;
        } else {
            this.labelSeparation = this.bodyStart;
        }
        this.referenceWidth = d;
    }

    public void setup(Numbering numbering) throws Exception {
        Object object;
        Paragraph paragraph;
        Element element = null;
        if (this.body.size() != 0) {
            element = (Element)this.body.firstElement();
        }
        if (element == null || element.type != 0) {
            paragraph = Paragraph.empty();
            paragraph.properties.startIndent = this.bodyStart;
            object = new Element(0, paragraph);
            this.body.insertElementAt(object, 0);
        } else {
            paragraph = (Paragraph)element.object;
        }
        ParagraphProperties paragraphProperties = paragraph.properties;
        paragraphProperties.breakBefore = this.breakBefore;
        paragraphProperties.spaceBefore = this.spaceBefore;
        if (paragraphProperties.alignment == 1 || paragraphProperties.alignment == 2) {
            paragraphProperties.alignment = 0;
        }
        paragraphProperties.firstLineIndent = this.labelStart - this.bodyStart;
        if (paragraphProperties.startIndent > 0.0) {
            object = new TabStops();
            ((TabStops)object).add(new TabStop(paragraphProperties.startIndent));
            ((TabStops)object).add(paragraphProperties.tabStops);
            paragraphProperties.tabStops = object;
        }
        if (numbering != null) {
            paragraphProperties.numberingId = numbering.id;
            switch (numbering.alignment) {
                case 1: {
                    paragraphProperties.firstLineIndent += this.labelWidth / 2.0;
                    break;
                }
                case 2: {
                    paragraphProperties.firstLineIndent += this.labelWidth;
                }
            }
        } else if (this.label != null) {
            if (this.label.requiresLayout()) {
                this.label.layout(this.referenceWidth);
            }
            paragraph.prepend(this.label);
            paragraph.startsListItem = true;
        }
        int n = this.body.size();
        for (int i = 0; i < n; ++i) {
            object = (Element)this.body.elementAt(i);
            if (((Element)object).type != 0 || !(paragraph = (Paragraph)((Element)object).object).requiresLayout()) continue;
            paragraph.layout(this.referenceWidth);
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.body.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.body.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    paragraph.print(printWriter);
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    table.print(printWriter);
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.print(printWriter);
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    list.print(printWriter);
                }
            }
        }
    }

    public Numbering numbering(LabelFormat labelFormat) {
        char c;
        if (this.label == null || this.label.elementCount() != 1) {
            return null;
        }
        Object object = this.label.firstElement();
        Text text = null;
        if (object instanceof Text) {
            text = (Text)object;
        }
        if (text == null) {
            return null;
        }
        Numbering numbering = null;
        if (labelFormat != null) {
            if (labelFormat.type == 0) {
                return null;
            }
            switch (labelFormat.type) {
                case 2: {
                    numbering = new Numbering(0, labelFormat.start);
                    break;
                }
                case 3: {
                    numbering = new Numbering(4, labelFormat.start);
                    break;
                }
                case 4: {
                    numbering = new Numbering(3, labelFormat.start);
                    break;
                }
                case 5: {
                    numbering = new Numbering(2, labelFormat.start);
                    break;
                }
                case 6: {
                    numbering = new Numbering(1, labelFormat.start);
                    break;
                }
                default: {
                    numbering = new Numbering(5);
                    numbering.format = labelFormat.suffix;
                }
            }
            if (labelFormat.type != 1) {
                numbering.format = "%1";
                if (labelFormat.prefix != null) {
                    numbering.format = labelFormat.prefix + numbering.format;
                }
                if (labelFormat.suffix != null) {
                    numbering.format = numbering.format + labelFormat.suffix;
                }
            }
        } else {
            String string = text.content.trim();
            switch (string.length()) {
                case 1: {
                    c = string.charAt(0);
                    numbering = this.numbering(c);
                    if (numbering == null) break;
                    if (numbering.style != 5) {
                        numbering.format = "%1";
                        break;
                    }
                    numbering.format = "" + c;
                    break;
                }
                case 2: {
                    char c2 = string.charAt(1);
                    if (c2 != '.' && c2 != ')' || (numbering = this.numbering(c = string.charAt(0))) == null) break;
                    if (numbering.style != 5) {
                        numbering.format = "%1" + c2;
                        break;
                    }
                    numbering = null;
                    break;
                }
                case 3: {
                    char c3 = string.charAt(0);
                    char c4 = string.charAt(2);
                    if (!(c3 == '(' && c4 == ')' || c3 == '<' && c4 == '>') && (c3 != '[' || c4 != ']') || (numbering = this.numbering(c = string.charAt(1))) == null) break;
                    if (numbering.style != 5) {
                        numbering.format = c3 + "%1" + c4;
                        break;
                    }
                    numbering = null;
                }
            }
        }
        if (numbering != null) {
            c = '\u0000';
            switch (this.label.properties.alignment) {
                case 1: {
                    c = '\u0001';
                    break;
                }
                case 2: {
                    c = '\u0002';
                }
            }
            numbering.alignment = c;
            numbering.properties = text.properties;
        }
        return numbering;
    }

    private Numbering numbering(char c) {
        int n;
        int n2 = 1;
        switch (c) {
            case '*': 
            case '+': 
            case '-': 
            case '\u2013': 
            case '\u2022': {
                n = 5;
                break;
            }
            case '0': {
                n = 0;
                n2 = 0;
                break;
            }
            case '1': {
                n = 0;
                break;
            }
            case 'a': {
                n = 4;
                break;
            }
            case 'A': {
                n = 3;
                break;
            }
            case 'i': {
                n = 2;
                break;
            }
            case 'I': {
                n = 1;
                break;
            }
            default: {
                return null;
            }
        }
        return new Numbering(n, n2);
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.body.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.body.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        int n = this.body.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.body.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        return d;
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 0;
        static final int TYPE_TABLE = 1;
        static final int TYPE_TABLE_AND_CAPTION = 2;
        static final int TYPE_LIST = 3;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

