/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Wml;
import java.io.PrintWriter;

public final class Numbering {
    public static final int STYLE_DECIMAL = 0;
    public static final int STYLE_UPPER_ROMAN = 1;
    public static final int STYLE_LOWER_ROMAN = 2;
    public static final int STYLE_UPPER_LETTER = 3;
    public static final int STYLE_LOWER_LETTER = 4;
    public static final int STYLE_BULLET = 5;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public int id;
    public int style;
    public int start;
    public int alignment;
    public String format;
    public RunProperties properties;

    public Numbering(int n) {
        this(n, 1);
    }

    public Numbering(int n, int n2) {
        this(n, n2, 0, null, null);
    }

    public Numbering(int n, int n2, int n3, String string, RunProperties runProperties) {
        this.style = n;
        this.start = n2;
        this.alignment = n3;
        this.format = string;
        this.properties = runProperties;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("<w:abstractNum w:abstractNumId=\"" + this.id + "\">");
        printWriter.println("<w:nsid w:val=\"" + this.nsid() + "\" />");
        printWriter.println("<w:multiLevelType w:val=\"singleLevel\" />");
        printWriter.println("<w:lvl w:ilvl=\"0\">");
        printWriter.println("<w:start w:val=\"" + this.start + "\" />");
        printWriter.println("<w:numFmt w:val=\"" + this.style() + "\" />");
        printWriter.println("<w:suff w:val=\"tab\" />");
        if (this.format != null) {
            printWriter.println("<w:lvlText w:val=\"" + Wml.escape(this.format) + "\" />");
        }
        printWriter.println("<w:lvlJc w:val=\"" + this.alignment() + "\" />");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        printWriter.println("</w:lvl>");
        printWriter.println("</w:abstractNum>");
    }

    private String nsid() {
        String string = Integer.toHexString(~this.id).toUpperCase();
        int n = string.length();
        if (n < 8) {
            string = "00000000".substring(0, 8 - n) + string;
        }
        return string;
    }

    private String style() {
        String string;
        switch (this.style) {
            default: {
                string = "decimal";
                break;
            }
            case 1: {
                string = "upperRoman";
                break;
            }
            case 2: {
                string = "lowerRoman";
                break;
            }
            case 3: {
                string = "upperLetter";
                break;
            }
            case 4: {
                string = "lowerLetter";
                break;
            }
            case 5: {
                string = "bullet";
            }
        }
        return string;
    }

    private String alignment() {
        String string;
        switch (this.alignment) {
            default: {
                string = "left";
                break;
            }
            case 1: {
                string = "center";
                break;
            }
            case 2: {
                string = "right";
            }
        }
        return string;
    }
}

