/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.Bookmark;
import com.xmlmind.fo.converter.docx.Field;
import com.xmlmind.fo.converter.docx.Leader;
import com.xmlmind.fo.converter.docx.Link;
import com.xmlmind.fo.converter.docx.ParagraphProperties;
import com.xmlmind.fo.converter.docx.Picture;
import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Text;
import com.xmlmind.fo.converter.docx.sdt.SdtElement;
import java.io.PrintWriter;
import java.util.Vector;

public final class Paragraph {
    public static final Paragraph EMPTY = Paragraph.empty();
    public ParagraphProperties properties;
    public Bookmark[] bookmarks;
    public boolean startsListItem;
    public boolean hasPicture;
    private Vector runs = new Vector();

    public Paragraph() {
        this(null);
    }

    public Paragraph(ParagraphProperties paragraphProperties) {
        this.properties = paragraphProperties;
    }

    public void add(Text text) {
        this.add(0, text);
    }

    public void add(Field field) {
        this.add(4, field);
    }

    public void add(Picture picture) {
        this.add(5, picture);
        this.hasPicture = true;
    }

    public void add(Leader leader) {
        if (this.properties != null) {
            this.properties.tabStops.add(leader.tabStop());
            this.addTab(leader.properties);
        }
    }

    public void add(SdtElement sdtElement) {
        this.add(10, sdtElement);
    }

    public void addBreak(RunProperties runProperties) {
        this.add(1, runProperties);
    }

    public void addTab(RunProperties runProperties) {
        this.add(2, runProperties);
    }

    public void addPageNumber(RunProperties runProperties) {
        this.add(3, runProperties);
    }

    public void addFootnote(int n) {
        Text text = null;
        int n2 = this.runs.size();
        if (n2 > 0) {
            Run run = (Run)this.runs.elementAt(n2 - 1);
            if (run.type == 9) {
                run = n2 > 1 ? (Run)this.runs.elementAt(n2 - 2) : null;
            }
            if (run != null && run.type == 0) {
                text = (Text)run.object;
            }
        }
        if (text == null) {
            text = new Text();
            this.add(text);
        }
        text.footnoteId = n;
    }

    public void startLink(Link link) {
        this.add(6, link);
    }

    public void endLink(Link link) {
        this.add(7, link);
    }

    public void startBookmark(Bookmark bookmark) {
        this.add(8, bookmark);
    }

    public void endBookmark(Bookmark bookmark) {
        this.add(9, bookmark);
    }

    private void add(int n, Object object) {
        this.runs.addElement(new Run(n, object));
    }

    public void layout(double d) throws Exception {
        double d2 = d;
        if (this.properties != null) {
            this.properties.tabStops.layout(d, this.properties.startIndent, this.properties.endIndent);
            d2 -= this.properties.startIndent + this.properties.endIndent;
        }
        int n = this.runs.size();
        for (int i = 0; i < n; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            if (run.type != 5) continue;
            Picture picture = (Picture)run.object;
            picture.layout(d2);
        }
    }

    public void prepend(Paragraph paragraph) {
        int n = paragraph.runs.size();
        for (int i = 0; i < n; ++i) {
            this.runs.insertElementAt(paragraph.runs.elementAt(i), i);
        }
        Run run = new Run(2, paragraph.runProperties());
        this.runs.insertElementAt(run, paragraph.runs.size());
    }

    public void print(PrintWriter printWriter) {
        Object object;
        Text text;
        int n;
        Run[] runArray = new Run[this.runs.size()];
        for (n = 0; n < runArray.length; ++n) {
            runArray[n] = (Run)this.runs.elementAt(n);
        }
        for (n = 0; n < runArray.length && runArray[n].type == 0; ++n) {
            text = (Text)runArray[n].object;
            if (!text.preserveSpace) {
                text.trimLeft();
            }
            if (text.content.length() != 0) break;
        }
        for (n = runArray.length - 1; n >= 0 && runArray[n].type == 0; --n) {
            text = (Text)runArray[n].object;
            if (!text.preserveSpace) {
                text.trimRight();
            }
            if (text.content.length() != 0) break;
        }
        if (this.startsListItem) {
            block16: for (n = 0; n < runArray.length; ++n) {
                int n2;
                if (runArray[n].type != 2) continue;
                for (n2 = n - 1; n2 >= 0 && runArray[n2].type == 0; --n2) {
                    object = (Text)runArray[n2].object;
                    if (!((Text)object).preserveSpace) {
                        ((Text)object).trimRight();
                    }
                    if (((Text)object).content.length() != 0) break;
                }
                for (n2 = n + 1; n2 < runArray.length && runArray[n2].type == 0; ++n2) {
                    object = (Text)runArray[n2].object;
                    if (!((Text)object).preserveSpace) {
                        ((Text)object).trimLeft();
                    }
                    if (((Text)object).content.length() != 0) break block16;
                }
                break;
            }
        }
        if (this.bookmarks != null) {
            for (n = 0; n < this.bookmarks.length; ++n) {
                this.bookmarks[n].start(printWriter);
            }
        }
        printWriter.println("<w:p>");
        if (this.properties != null) {
            this.properties.print(printWriter);
            if (this.properties.breakBefore == 1) {
                printWriter.println("<w:r>");
                printWriter.println("<w:br w:type=\"column\" />");
                printWriter.println("</w:r>");
            }
        }
        block20: for (n = 0; n < runArray.length; ++n) {
            Run run = runArray[n];
            switch (run.type) {
                case 0: {
                    Text text2 = (Text)run.object;
                    if (text2.isEmpty()) continue block20;
                    text2.print(printWriter);
                    continue block20;
                }
                case 4: {
                    Field field = (Field)run.object;
                    field.print(printWriter);
                    continue block20;
                }
                case 5: {
                    Picture picture = (Picture)run.object;
                    picture.print(printWriter);
                    continue block20;
                }
                case 1: {
                    printWriter.println("<w:r>");
                    object = (RunProperties)run.object;
                    if (object != null) {
                        ((RunProperties)object).print(printWriter);
                    }
                    printWriter.println("<w:br w:type=\"textWrapping\" />");
                    printWriter.println("</w:r>");
                    continue block20;
                }
                case 2: {
                    printWriter.println("<w:r>");
                    object = (RunProperties)run.object;
                    if (object != null) {
                        ((RunProperties)object).print(printWriter);
                    }
                    printWriter.println("<w:tab />");
                    printWriter.println("</w:r>");
                    continue block20;
                }
                case 3: {
                    printWriter.println("<w:r>");
                    object = (RunProperties)run.object;
                    if (object != null) {
                        ((RunProperties)object).print(printWriter);
                    }
                    printWriter.println("<w:pgNum />");
                    printWriter.println("</w:r>");
                    continue block20;
                }
                case 6: {
                    Link link = (Link)run.object;
                    link.start(printWriter);
                    continue block20;
                }
                case 7: {
                    Link link = (Link)run.object;
                    link.end(printWriter);
                    continue block20;
                }
                case 8: {
                    Bookmark bookmark = (Bookmark)run.object;
                    bookmark.start(printWriter);
                    continue block20;
                }
                case 9: {
                    Bookmark bookmark = (Bookmark)run.object;
                    bookmark.end(printWriter);
                    continue block20;
                }
                case 10: {
                    SdtElement sdtElement = (SdtElement)run.object;
                    sdtElement.print(printWriter);
                }
            }
        }
        printWriter.println("</w:p>");
        if (this.bookmarks != null) {
            for (n = this.bookmarks.length - 1; n >= 0; --n) {
                this.bookmarks[n].end(printWriter);
            }
        }
    }

    public boolean requiresLayout() {
        return this.hasPicture || this.hasTabs();
    }

    public boolean hasTabs() {
        return this.properties != null && this.properties.tabStops.count() > 0;
    }

    public boolean isEmpty() {
        if (this.bookmarks != null && this.bookmarks.length > 0) {
            return false;
        }
        int n = this.runs.size();
        for (int i = 0; i < n; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            if (run.type != 0) {
                return false;
            }
            Text text = (Text)run.object;
            if (text.isEmpty() || text.isSpace() && !text.preserveSpace) continue;
            return false;
        }
        return true;
    }

    public int elementCount() {
        return this.runs.size();
    }

    public Object firstElement() {
        if (this.runs.size() > 0) {
            Run run = (Run)this.runs.firstElement();
            return run.object;
        }
        return null;
    }

    public RunProperties runProperties() {
        RunProperties runProperties = null;
        int n = this.runs.size();
        for (int i = 0; i < n; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            if (run.type != 0) continue;
            Text text = (Text)run.object;
            if (text.properties == null) continue;
            runProperties = text.properties;
            break;
        }
        return runProperties;
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.runs.size();
        block4: for (int i = 0; i < n; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            switch (run.type) {
                case 0: {
                    Text text = (Text)run.object;
                    double d2 = text.wordWidth();
                    if (!(d2 > d)) continue block4;
                    d = d2;
                    continue block4;
                }
                case 5: {
                    Picture picture = (Picture)run.object;
                    double d2 = picture.width();
                    if (!(d2 > d)) continue block4;
                    d = d2;
                }
            }
        }
        if (this.properties != null) {
            d += this.properties.startIndent + this.properties.endIndent;
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.runs.size();
        block5: for (int i = 0; i < n; ++i) {
            Run run = (Run)this.runs.elementAt(i);
            switch (run.type) {
                case 0: {
                    Text text = (Text)run.object;
                    d += text.textWidth();
                    continue block5;
                }
                case 5: {
                    Picture picture = (Picture)run.object;
                    d += picture.width();
                    continue block5;
                }
                case 1: {
                    if (d > d2) {
                        d2 = d;
                    }
                    d = 0.0;
                }
            }
        }
        if (d > d2) {
            d2 = d;
        }
        if (this.properties != null) {
            d2 += this.properties.startIndent + this.properties.endIndent;
        }
        return d2;
    }

    public static Paragraph empty() {
        return Paragraph.empty(0.0);
    }

    public static Paragraph empty(double d) {
        Paragraph paragraph = new Paragraph(new ParagraphProperties());
        if (d > 0.0) {
            RunProperties runProperties = new RunProperties();
            runProperties.fontSize = d;
            paragraph.properties.markProperties = runProperties;
        }
        return paragraph;
    }

    private class Run {
        static final int TYPE_TEXT = 0;
        static final int TYPE_BREAK = 1;
        static final int TYPE_TAB = 2;
        static final int TYPE_PAGE_NUMBER = 3;
        static final int TYPE_FIELD = 4;
        static final int TYPE_PICTURE = 5;
        static final int TYPE_LINK_START = 6;
        static final int TYPE_LINK_END = 7;
        static final int TYPE_BOOKMARK_START = 8;
        static final int TYPE_BOOKMARK_END = 9;
        static final int TYPE_SDT_ELEMENT = 10;
        int type;
        Object object;

        Run(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

