/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.util.Encoding;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public final class Relationships {
    public static final String TYPE_BASE_URI = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/";
    public static final String TYPE_CUSTOMXML = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml";
    public static final String TYPE_CUSTOMXML_PROPERTIES = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps";
    public static final String TYPE_DOCUMENT_SETTINGS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings";
    public static final String TYPE_FONT_TABLE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable";
    public static final String TYPE_FOOTER = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer";
    public static final String TYPE_FOOTNOTES = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes";
    public static final String TYPE_HEADER = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header";
    public static final String TYPE_HYPERLINK = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink";
    public static final String TYPE_IMAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image";
    public static final String TYPE_MAIN_DOCUMENT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    public static final String TYPE_NUMBERING_DEFINITIONS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering";
    public static final int MODE_INTERNAL = 0;
    public static final int MODE_EXTERNAL = 1;
    private static final String NAMESPACE_URI = "http://schemas.openxmlformats.org/package/2006/relationships";
    private Vector relationships = new Vector();

    public String add(String string, String string2) {
        return this.add(string, string2, 0);
    }

    public String add(String string, String string2, int n) {
        String string3 = "r" + (this.relationships.size() + 1);
        this.relationships.addElement(new Relationship(string3, string, string2, n));
        return string3;
    }

    public int count() {
        return this.relationships.size();
    }

    public byte[] getBytes(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(string) + "\"?>");
        this.print(printWriter);
        printWriter.flush();
        return stringWriter.toString().getBytes(string);
    }

    private void print(PrintWriter printWriter) {
        printWriter.println("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">");
        int n = this.relationships.size();
        for (int i = 0; i < n; ++i) {
            Relationship relationship = (Relationship)this.relationships.elementAt(i);
            printWriter.println("  <Relationship Id=\"" + relationship.id + "\"");
            printWriter.println("    Type=\"" + relationship.type + "\"");
            if (relationship.mode == 1) {
                printWriter.println("    TargetMode=\"External\"");
            }
            printWriter.println("    Target=\"" + relationship.target + "\"/>");
        }
        printWriter.println("</Relationships>");
    }

    private class Relationship {
        String id;
        String type;
        String target;
        int mode;

        Relationship(String string, String string2, String string3, int n) {
            this.id = string;
            this.type = string2;
            this.target = string3;
            this.mode = n;
        }
    }
}

