/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.Bookmark;
import com.xmlmind.fo.converter.docx.Footnote;
import com.xmlmind.fo.converter.docx.Link;
import com.xmlmind.fo.converter.docx.List;
import com.xmlmind.fo.converter.docx.ListItem;
import com.xmlmind.fo.converter.docx.Paragraph;
import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Table;
import com.xmlmind.fo.converter.docx.TableAndCaption;
import com.xmlmind.fo.objects.Fo;
import java.util.Vector;

public final class State
implements Cloneable {
    public static final int CONTEXT_FLOW = 1;
    public static final int CONTEXT_LIST_ITEM_LABEL = 2;
    public static final int CONTEXT_LIST_ITEM_BODY = 3;
    public static final int CONTEXT_TABLE = 4;
    public static final int CONTEXT_CAPTION = 5;
    public static final int CONTEXT_FOOTNOTE_LABEL = 6;
    public static final int CONTEXT_FOOTNOTE_BODY = 7;
    public static final int CONTEXT_STATIC_CONTENT = 8;
    public int fo;
    public int context;
    public int listLevel;
    public double referenceWidth;
    public boolean skipContent;
    public Table table;
    public TableAndCaption tableAndCaption;
    public List list;
    public ListItem listItem;
    public Footnote footnote;
    public Link link;
    public Bookmark bookmark;
    public Paragraph paragraph;
    public Vector bookmarks;
    public RunProperties runProperties;
    private Vector stack = new Vector();

    public State(int n) {
        this.fo = n;
    }

    public State update(int n) throws CloneNotSupportedException {
        this.stack.addElement(this);
        State state = (State)this.clone();
        switch (n) {
            case 9: 
            case 15: 
            case 23: 
            case 27: 
            case 54: {
                state.skipContent = true;
                break;
            }
            case 19: {
                ++state.listLevel;
                switch (state.context) {
                    case 2: {
                        state.skipContent = true;
                    }
                }
                break;
            }
            case 45: 
            case 46: {
                switch (state.context) {
                    case 2: 
                    case 5: 
                    case 7: {
                        state.skipContent = true;
                    }
                }
                break;
            }
            case 49: {
                state.listLevel = 0;
            }
        }
        if (!state.skipContent && Fo.isBlock(n)) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                State state2 = (State)this.stack.elementAt(i);
                if (Fo.isBlock(state2.fo) || state2.fo == 12) break;
                if (!Fo.isInline(state2.fo)) continue;
                state.skipContent = true;
                break;
            }
        }
        switch (n) {
            case 10: {
                state.context = 1;
                break;
            }
            case 22: {
                state.context = 2;
                break;
            }
            case 21: {
                state.context = 3;
                break;
            }
            case 45: {
                state.context = 4;
                break;
            }
            case 48: {
                state.context = 5;
                break;
            }
            case 11: {
                state.context = 6;
                break;
            }
            case 12: {
                state.context = 7;
                break;
            }
            case 44: {
                state.context = 8;
            }
        }
        state.fo = n;
        state.runProperties = null;
        state.bookmark = null;
        return state;
    }

    public State restore() {
        State state;
        int n = this.stack.size();
        if (n > 0) {
            state = (State)this.stack.lastElement();
            this.stack.removeElementAt(n - 1);
        } else {
            state = this;
        }
        return state;
    }

    public int parentContext() {
        int n = this.context;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            State state = (State)this.stack.elementAt(i);
            if (state.context == n) continue;
            n = state.context;
            break;
        }
        return n;
    }
}

