/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import java.io.PrintWriter;

public final class TabStop {
    public static final double POSITION_UNSPECIFIED = Double.MAX_VALUE;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_DECIMAL = 3;
    public static final int LEADER_NONE = 0;
    public static final int LEADER_SOLID = 1;
    public static final int LEADER_DOTTED = 2;
    public double position;
    public int alignment;
    public int leader;

    public TabStop() {
        this(Double.MAX_VALUE);
    }

    public TabStop(double d) {
        this(d, 0);
    }

    public TabStop(double d, int n) {
        this(d, n, 0);
    }

    public TabStop(double d, int n, int n2) {
        this.position = d;
        this.alignment = n;
        this.leader = n2;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<w:tab");
        printWriter.print(" w:val=\"" + this.alignment() + "\"");
        printWriter.print(" w:pos=\"" + Math.round(20.0 * this.position) + "\"");
        if (this.leader != 0) {
            printWriter.print(" w:leader=\"" + this.leader() + "\"");
        }
        printWriter.print(" />");
    }

    private String alignment() {
        String string;
        switch (this.alignment) {
            case 1: {
                string = "center";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            case 3: {
                string = "decimal";
                break;
            }
            default: {
                string = "left";
            }
        }
        return string;
    }

    private String leader() {
        String string;
        switch (this.leader) {
            case 1: {
                string = "underscore";
                break;
            }
            case 2: {
                string = "dot";
                break;
            }
            default: {
                string = "none";
            }
        }
        return string;
    }
}

