/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.TabStop;
import java.io.PrintWriter;
import java.util.Vector;

public final class TabStops {
    private int tabCount;
    private Vector tabList = new Vector();
    private TabStop[] tabs;

    public void add(TabStop tabStop) {
        this.tabList.addElement(tabStop);
        ++this.tabCount;
    }

    public void add(TabStops tabStops) {
        for (int i = 0; i < tabStops.tabCount; ++i) {
            this.tabList.addElement(tabStops.tabList.elementAt(i));
        }
        this.tabCount += tabStops.tabCount;
    }

    public int count() {
        return this.tabCount;
    }

    public void layout(double d, double d2, double d3) {
        int n;
        if (this.tabCount == 0) {
            return;
        }
        this.tabs = new TabStop[this.tabCount];
        for (n = 0; n < this.tabs.length; ++n) {
            this.tabs[n] = (TabStop)this.tabList.elementAt(n);
            if (!(this.tabs[n].position < 0.0)) continue;
            this.tabs[n].position += d;
        }
        for (n = 0; n < this.tabs.length; ++n) {
            if (this.tabs[n].position != Double.MAX_VALUE) continue;
            double d4 = n > 0 ? this.tabs[n - 1].position : d2;
            double d5 = d - d3;
            int n2 = n + 1;
            int n3 = 1;
            while (n2 < this.tabs.length) {
                if (this.tabs[n2].position != Double.MAX_VALUE) {
                    d5 = this.tabs[n2].position;
                    break;
                }
                ++n2;
                ++n3;
            }
            double d6 = (d5 - d4) / (double)(n3 + 1);
            while (n < n2) {
                d4 = this.tabs[n].position = d4 + d6;
                ++n;
            }
        }
    }

    public void print(PrintWriter printWriter) {
        if (this.tabs == null) {
            return;
        }
        printWriter.println("<w:tabs>");
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].print(printWriter);
        }
        printWriter.print("</w:tabs>");
    }
}

