/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.Bookmark;
import com.xmlmind.fo.converter.docx.Border;
import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.converter.docx.List;
import com.xmlmind.fo.converter.docx.NumberingDefinitions;
import com.xmlmind.fo.converter.docx.Paragraph;
import com.xmlmind.fo.converter.docx.TableAndCaption;
import com.xmlmind.fo.converter.docx.TableCell;
import com.xmlmind.fo.converter.docx.TableColumn;
import com.xmlmind.fo.converter.docx.TableGroup;
import com.xmlmind.fo.converter.docx.TableRow;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class Table {
    private static final int ALIGNMENT_LEFT = 0;
    private static final int ALIGNMENT_CENTER = 1;
    private static final int ALIGNMENT_RIGHT = 2;
    private int breakBefore;
    private double spaceBefore;
    private boolean keepTogether;
    private int tableLayout;
    private int borderCollapse;
    private double rowSpacing;
    private double columnSpacing;
    private double width;
    private boolean relativeWidth;
    private double startIndent;
    private double endIndent;
    private int alignment;
    private Borders borders;
    private Color background;
    private int numColumns;
    private Vector columnList = new Vector();
    private Hashtable columnHash = new Hashtable();
    private TableColumn[] columns;
    private TableGroup header;
    private TableGroup footer;
    private Vector bodies = new Vector();
    private TableGroup[] groups;
    private TableRow[] rows;
    private TableGroup group;
    private TableRow row;
    private TableCell cell;
    private double tableWidth;
    private double maxTableWidth;
    private double[] columnWidths;
    private double tableIndent;
    private boolean isNestedTable;

    public Table(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.breakBefore = context.breakBefore;
        this.spaceBefore = context.spaceBefore();
        this.keepTogether = Table.keep(valueArray[137]);
        this.tableLayout = valueArray[283].keyword();
        this.borderCollapse = valueArray[37].keyword();
        if (this.borderCollapse == 177) {
            int n = 54;
            int n2 = 55;
            this.rowSpacing = Table.length(valueArray[n]);
            this.columnSpacing = Table.length(valueArray[n2]);
            this.columnSpacing = this.rowSpacing = Math.min(this.rowSpacing, this.columnSpacing);
        }
        Value value = valueArray[308];
        switch (value.type) {
            case 4: {
                this.width = value.length();
                break;
            }
            case 13: {
                this.width = value.percentage();
                this.relativeWidth = true;
            }
        }
        this.startIndent = Table.length(valueArray[277]);
        this.endIndent = Table.length(valueArray[97]);
        this.borders = new Borders(valueArray);
        this.borders.top.space = 0.0;
        this.borders.bottom.space = 0.0;
        this.borders.left.space = 0.0;
        this.borders.right.space = 0.0;
        this.background = context.background;
        Context context2 = context.parent();
        if (context2.fo == 46) {
            valueArray = context2.properties.values;
            switch (valueArray[289].keyword()) {
                default: {
                    this.alignment = 0;
                    break;
                }
                case 52: 
                case 165: {
                    this.alignment = 2;
                    break;
                }
                case 31: 
                case 93: {
                    this.alignment = 1;
                }
            }
        }
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void add(TableColumn tableColumn) {
        int n;
        if (tableColumn.repeat > 1) {
            n = tableColumn.number;
            for (int i = 0; i < tableColumn.repeat; ++i) {
                TableColumn tableColumn2 = tableColumn.copy();
                tableColumn2.number = n;
                tableColumn2.repeat = 1;
                this.columnList.addElement(tableColumn2);
                this.columnHash.put(new Integer(tableColumn2.number), tableColumn2);
                n += tableColumn.span;
            }
        } else {
            this.columnList.addElement(tableColumn);
            this.columnHash.put(new Integer(tableColumn.number), tableColumn);
        }
        n = tableColumn.last();
        if (n > this.numColumns) {
            this.numColumns = n;
        }
    }

    public void startHeader(Context context) {
        this.startGroup(0, context);
        this.header = this.group;
    }

    public void endHeader() {
        this.endGroup();
    }

    public void startFooter(Context context) {
        this.startGroup(2, context);
        this.footer = this.group;
    }

    public void endFooter() {
        this.endGroup();
    }

    public void startBody(Context context) {
        this.startGroup(1, context);
        this.bodies.addElement(this.group);
    }

    public void endBody() {
        this.endGroup();
    }

    private void startGroup(int n, Context context) {
        this.group = new TableGroup(n, context);
        this.row = null;
    }

    private void endGroup() {
        this.endRow();
        this.group = null;
    }

    public void startRow(Context context, Bookmark[] bookmarkArray) {
        this.row = new TableRow(context);
        this.row.bookmarks = bookmarkArray;
        if (this.group != null) {
            this.group.add(this.row);
        }
    }

    public void endRow() {
        this.row = null;
    }

    public double startCell(Context context) {
        double d = 0.0;
        this.cell = new TableCell(context);
        int n = this.cell.colNumber + this.cell.colSpan - 1;
        if (n > this.numColumns) {
            this.numColumns = n;
        }
        if (this.cell.startsRow) {
            this.endRow();
        }
        if (this.row == null) {
            this.row = new TableRow();
            if (this.group != null) {
                this.group.add(this.row);
            }
        }
        this.row.add(this.cell);
        if (this.cell.width > 0.0 && !this.cell.relativeWidth) {
            d = this.cell.width;
        } else {
            TableColumn tableColumn = (TableColumn)this.columnHash.get(new Integer(this.cell.colNumber));
            if (tableColumn != null && tableColumn.width > 0.0 && tableColumn.widthType == 0) {
                d = tableColumn.width;
            }
        }
        if (d > 0.0) {
            d -= this.cell.marginLeft + this.cell.marginRight;
        }
        return d;
    }

    public void endCell() {
        if (this.cell.endsRow) {
            this.endRow();
        }
        this.cell = null;
    }

    public void add(Paragraph paragraph) {
        if (this.cell != null) {
            this.cell.add(paragraph);
            if (paragraph.requiresLayout()) {
                this.cell.requiresLayout = true;
                this.row.requiresLayout = true;
            }
        }
    }

    public void add(Table table) {
        if (this.cell != null) {
            table.isNestedTable = true;
            this.cell.add(table);
            this.cell.requiresLayout = true;
            this.row.requiresLayout = true;
        }
    }

    public void add(TableAndCaption tableAndCaption) {
        if (this.cell != null) {
            if (tableAndCaption.table != null) {
                tableAndCaption.table.isNestedTable = true;
            }
            this.cell.add(tableAndCaption);
            this.cell.requiresLayout = true;
            this.row.requiresLayout = true;
        }
    }

    public void add(List list) {
        if (this.cell != null) {
            this.cell.add(list);
            this.cell.requiresLayout = true;
            this.row.requiresLayout = true;
        }
    }

    public void layout(double d, NumberingDefinitions numberingDefinitions) throws Exception {
        double d2;
        int n;
        int n2;
        int n3;
        if (this.columns == null) {
            this.normalize();
        }
        this.maxTableWidth = d - (this.startIndent + this.endIndent);
        if (this.relativeWidth) {
            double d3 = this.width;
            this.width = this.maxTableWidth * d3 / 100.0;
            this.relativeWidth = false;
        }
        this.tableWidth = this.width > 0.0 ? this.width : this.maxTableWidth;
        for (n3 = 0; n3 < this.numColumns; ++n3) {
            TableColumn tableColumn = this.columns[n3];
            if (tableColumn == null || tableColumn.widthType != 1) continue;
            double d4 = tableColumn.width;
            tableColumn.width = this.tableWidth * d4 / 100.0;
            tableColumn.widthType = 0;
        }
        for (n2 = 0; n2 < this.rows.length; ++n2) {
            TableRow tableRow = this.rows[n2];
            for (n = 0; n < tableRow.cells.length; ++n) {
                TableCell tableCell = tableRow.cells[n];
                if (!tableCell.relativeWidth) continue;
                d2 = tableCell.width;
                tableCell.width = this.tableWidth * d2 / 100.0;
                tableCell.relativeWidth = false;
            }
        }
        if (this.tableLayout == 69) {
            for (n3 = 0; n3 < this.columns.length; ++n3) {
                if (this.columns[n3] != null && this.columns[n3].width != 0.0) continue;
                this.tableLayout = 10;
                break;
            }
        } else {
            boolean bl = true;
            for (n3 = 0; n3 < this.columns.length; ++n3) {
                if (this.columns[n3] != null && this.columns[n3].width != 0.0) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.tableLayout = 69;
            }
        }
        this.columnWidths = this.tableLayout == 69 ? this.fixedLayout() : this.automaticLayout();
        this.tableWidth = 0.0;
        for (n3 = 0; n3 < this.numColumns; ++n3) {
            this.tableWidth += this.columnWidths[n3];
        }
        if (this.borderCollapse == 177) {
            this.tableWidth += (double)(this.numColumns + 1) * this.columnSpacing;
            this.tableWidth += this.borders.left.width + this.borders.right.width;
        }
        for (n2 = 0; n2 < this.rows.length; ++n2) {
            TableRow tableRow = this.rows[n2];
            if (!tableRow.requiresLayout) continue;
            for (n = 0; n < tableRow.cells.length; ++n) {
                TableCell tableCell = tableRow.cells[n];
                if (!tableCell.requiresLayout) continue;
                d2 = 0.0;
                int n4 = tableCell.colSpan;
                if (n4 > 1) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        d2 += this.columnWidths[n + n3];
                    }
                    d2 += (double)(n4 - 1) * this.columnSpacing;
                } else {
                    d2 = this.columnWidths[n];
                }
                d2 -= this.leftBorderWidth(tableRow, tableCell);
                tableCell.layout(d2 -= this.rightBorderWidth(tableRow, tableCell), numberingDefinitions);
            }
        }
        for (n2 = 0; n2 < this.rows.length; ++n2) {
            TableRow tableRow = this.rows[n2];
            for (n = 0; n < tableRow.cells.length; ++n) {
                TableColumn tableColumn;
                TableCell tableCell = tableRow.cells[n];
                if (tableCell.background != null) continue;
                if (tableCell.isInvisible) {
                    if (this.borderCollapse != 177) continue;
                    tableCell.background = this.background;
                    continue;
                }
                tableCell.background = tableRow.background != null ? tableRow.background : ((tableColumn = this.columns[n]) != null && tableColumn.background != null && tableColumn.number == tableCell.colNumber && tableColumn.span == tableCell.colSpan ? tableColumn.background : this.background);
            }
            tableRow.background = null;
        }
        for (n2 = 0; n2 < this.rows.length; ++n2) {
            TableRow tableRow = this.rows[n2];
            if (!(tableRow.height > 0.0)) continue;
            double d5 = 0.0;
            for (n = 0; n < tableRow.cells.length; ++n) {
                TableCell tableCell = tableRow.cells[n];
                double d6 = tableCell.marginTop + tableCell.marginBottom;
                if (!(d6 > d5)) continue;
                d5 = d6;
            }
            if (!(d5 < tableRow.height)) continue;
            tableRow.height -= d5;
        }
        if (this.keepTogether) {
            int n5 = this.rows.length - 1;
            for (n3 = 0; n3 < n5; ++n3) {
                this.rows[n3].keepTogether = true;
                this.rows[n3].keepWithNext = true;
            }
            this.rows[this.rows.length - 1].keepTogether = true;
        }
        TableRow tableRow = this.rows[0];
        if (this.breakBefore > tableRow.breakBefore) {
            tableRow.breakBefore = this.breakBefore;
        }
        for (n3 = 1; n3 < this.rows.length; ++n3) {
            TableRow tableRow2 = this.rows[n3];
            if (tableRow.breakAfter > tableRow2.breakBefore) {
                tableRow2.breakBefore = tableRow.breakAfter;
            }
            if (tableRow2.keepWithPrevious) {
                tableRow.keepWithNext = true;
            }
            tableRow = tableRow2;
        }
        for (n3 = 0; n3 < this.rows.length; ++n3) {
            TableRow tableRow3 = this.rows[n3];
            if (tableRow3.breakBefore != 0) {
                tableRow3.cells[0].breakBefore(tableRow3.breakBefore);
            }
            if (!tableRow3.keepWithNext) continue;
            tableRow3.cells[0].keepWithNext();
        }
        this.tableIndent = this.startIndent;
        if (!this.isNestedTable) {
            TableCell tableCell = this.groups[0].rows[0].cells[0];
            if (this.borderCollapse == 177) {
                this.tableIndent += this.borders.left.width / 2.0;
                this.tableIndent += this.columnSpacing;
                this.tableIndent += tableCell.borders.left.width;
            } else {
                this.tableIndent += tableCell.borders.left.width / 2.0;
            }
            this.tableIndent += tableCell.marginLeft;
        }
        switch (this.alignment) {
            case 1: {
                this.tableIndent += (this.maxTableWidth - this.tableWidth) / 2.0;
                break;
            }
            case 2: {
                this.tableIndent += this.maxTableWidth - this.tableWidth;
            }
        }
    }

    private void normalize() {
        int n;
        Object object;
        int n2;
        this.columns = new TableColumn[this.numColumns];
        int n3 = this.columnList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (TableColumn)this.columnList.elementAt(n2);
            for (n = 0; n < ((TableColumn)object).span; ++n) {
                this.columns[((TableColumn)object).number + n - 1] = object;
            }
        }
        int n4 = this.bodies.size();
        if (this.header != null) {
            ++n4;
        }
        if (this.footer != null) {
            ++n4;
        }
        this.groups = new TableGroup[n4];
        if (this.header != null) {
            this.groups[0] = this.header;
        }
        n2 = 0;
        n = this.header == null ? 0 : 1;
        n3 = this.bodies.size();
        while (n2 < n3) {
            this.groups[n] = (TableGroup)this.bodies.elementAt(n2);
            ++n2;
            ++n;
        }
        if (this.footer != null) {
            this.groups[n4 - 1] = this.footer;
        }
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            this.groups[n2].normalize(this.numColumns);
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            n5 += this.groups[n2].rows.length;
        }
        this.rows = new TableRow[n5];
        int n6 = 0;
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            object = this.groups[n2];
            n = 0;
            while (n < ((TableGroup)object).rows.length) {
                this.rows[n6] = ((TableGroup)object).rows[n];
                ++n;
                ++n6;
            }
        }
        if (this.borderCollapse == 37) {
            this.setCollapsedBorders();
        } else {
            this.setSeparateBorders();
        }
    }

    public void setCollapsedBorders() {
        int n;
        Vector<Border> vector = new Vector<Border>();
        Border border = null;
        int n2 = this.groups.length;
        for (n = 0; n < n2; ++n) {
            TableGroup tableGroup = this.groups[n];
            int n3 = tableGroup.rows.length;
            for (int i = 0; i < n3; ++i) {
                TableRow tableRow = tableGroup.rows[i];
                int n4 = tableRow.cells.length;
                for (int j = 0; j < n4; ++j) {
                    Border border2;
                    int n5;
                    int n6;
                    TableCell tableCell = tableRow.cells[j];
                    if (tableCell.isInvisible) continue;
                    if (tableCell.borders.top.style != 75) {
                        vector.setSize(0);
                        border = null;
                        vector.addElement(tableRow.borders.top);
                        if (i == 0) {
                            vector.addElement(tableGroup.borders.top);
                            if (n == 0) {
                                vector.addElement(this.borders.top);
                            }
                        }
                        n6 = vector.size();
                        for (n5 = 0; n5 < n6; ++n5) {
                            Border border3 = (Border)vector.elementAt(n5);
                            if (border3.style == 125) continue;
                            border = border3;
                            if (border3.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.borders.top = border;
                        }
                    }
                    if (tableCell.borders.bottom.style != 75) {
                        vector.setSize(0);
                        border = null;
                        n5 = i + tableCell.rowSpan - 1;
                        vector.addElement(tableGroup.rows[n5].borders.bottom);
                        if (n5 == n3 - 1) {
                            vector.addElement(tableGroup.borders.bottom);
                            if (n == n2 - 1) {
                                vector.addElement(this.borders.bottom);
                            }
                        }
                        int n7 = vector.size();
                        for (n6 = 0; n6 < n7; ++n6) {
                            border2 = (Border)vector.elementAt(n6);
                            if (border2.style == 125) continue;
                            border = border2;
                            if (border2.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.borders.bottom = border;
                        }
                    }
                    if (tableCell.borders.left.style != 75) {
                        vector.setSize(0);
                        border = null;
                        TableColumn tableColumn = this.columns[j];
                        if (tableColumn != null && tableColumn.number == j + 1) {
                            vector.addElement(tableColumn.borders.left);
                        }
                        if (j == 0) {
                            vector.addElement(this.borders.left);
                        }
                        int n8 = vector.size();
                        for (n6 = 0; n6 < n8; ++n6) {
                            border2 = (Border)vector.elementAt(n6);
                            if (border2.style == 125) continue;
                            border = border2;
                            if (border2.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.borders.left = border;
                        }
                    }
                    if (tableCell.borders.right.style == 75) continue;
                    vector.setSize(0);
                    border = null;
                    int n9 = j + tableCell.colSpan - 1;
                    TableColumn tableColumn = this.columns[n9];
                    if (tableColumn != null && tableColumn.last() == n9 + 1) {
                        vector.addElement(tableColumn.borders.right);
                    }
                    if (n9 == n4 - 1) {
                        vector.addElement(this.borders.right);
                    }
                    int n10 = vector.size();
                    for (int k = 0; k < n10; ++k) {
                        Border border4 = (Border)vector.elementAt(k);
                        if (border4.style == 125) continue;
                        border = border4;
                        if (border4.style == 75) break;
                    }
                    if (border == null) continue;
                    tableCell.borders.right = border;
                }
            }
        }
        for (n = 0; n < this.rows.length; ++n) {
            this.rows[n].borders = null;
        }
        this.borders = null;
    }

    private void setSeparateBorders() {
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].borders = null;
        }
    }

    private double[] fixedLayout() {
        int n;
        double d = this.tableWidth;
        double d2 = 0.0;
        double[] dArray = new double[this.numColumns];
        if (this.borderCollapse == 177) {
            d -= (double)(this.numColumns + 1) * this.columnSpacing;
            d -= this.borders.left.width + this.borders.right.width;
        }
        for (n = 0; n < this.numColumns; ++n) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn == null) continue;
            if (tableColumn.widthType == 2) {
                d2 += tableColumn.width;
                continue;
            }
            dArray[n] = tableColumn.width;
            d -= tableColumn.width;
        }
        if (d2 > 0.0) {
            for (n = 0; n < this.numColumns; ++n) {
                if (dArray[n] != 0.0) continue;
                dArray[n] = d * this.columns[n].width / d2;
            }
        }
        return dArray;
    }

    private double[] automaticLayout() {
        double[] dArray;
        double d;
        TableCell tableCell;
        int n;
        TableRow tableRow;
        int n2;
        int n3;
        Object object;
        int n4;
        double[] dArray2 = new double[this.numColumns];
        double[] dArray3 = new double[this.numColumns];
        for (n4 = 0; n4 < this.numColumns; ++n4) {
            object = this.columns[n4];
            if (object == null || !(((TableColumn)object).width > 0.0)) continue;
            dArray2[n4] = ((TableColumn)object).width;
            dArray3[n4] = ((TableColumn)object).width;
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            object = this.groups[n3];
            for (n2 = 0; n2 < ((TableGroup)object).rows.length; ++n2) {
                tableRow = ((TableGroup)object).rows[n2];
                for (n = 0; n < tableRow.cells.length; ++n) {
                    tableCell = tableRow.cells[n];
                    if (tableCell.hMerge != 0 || tableCell.vMerge == 2) continue;
                    double d2 = tableCell.minWidth();
                    double d3 = tableCell.maxWidth();
                    double d4 = 0.0;
                    d4 += this.leftBorderWidth(tableRow, tableCell);
                    d2 += (d4 += this.rightBorderWidth(tableRow, tableCell));
                    d3 += d4;
                    if (d2 > dArray2[n]) {
                        dArray2[n] = d2;
                    }
                    if (!(d3 > dArray3[n])) continue;
                    dArray3[n] = d3;
                }
            }
        }
        for (n3 = 0; n3 < this.groups.length; ++n3) {
            object = this.groups[n3];
            for (n2 = 0; n2 < ((TableGroup)object).rows.length; ++n2) {
                tableRow = ((TableGroup)object).rows[n2];
                for (n = 0; n < tableRow.cells.length; ++n) {
                    tableCell = tableRow.cells[n];
                    if (tableCell.hMerge != 1 || tableCell.vMerge == 2) continue;
                    int n5 = tableCell.colSpan;
                    d = tableCell.minWidth();
                    double d5 = tableCell.maxWidth();
                    double d6 = 0.0;
                    d6 += this.leftBorderWidth(tableRow, tableCell);
                    d += (d6 += this.rightBorderWidth(tableRow, tableCell));
                    d5 += d6;
                    int n6 = n4 + n5;
                    d6 = 0.0;
                    for (n4 = n; n4 < n6; ++n4) {
                        d6 += dArray2[n4];
                    }
                    if (d > d6) {
                        d6 = (d - d6) / (double)n5;
                        n4 = n;
                        n6 = n4 + n5;
                        while (n4 < n6) {
                            int n7 = n4++;
                            dArray2[n7] = dArray2[n7] + d6;
                        }
                    }
                    n6 = n4 + n5;
                    d6 = 0.0;
                    for (n4 = n; n4 < n6; ++n4) {
                        d6 += dArray3[n4];
                    }
                    if (!(d5 > d6)) continue;
                    d6 = (d5 - d6) / (double)n5;
                    n4 = n;
                    n6 = n4 + n5;
                    while (n4 < n6) {
                        int n8 = n4++;
                        dArray3[n8] = dArray3[n8] + d6;
                    }
                }
            }
        }
        double d7 = 0.0;
        double d8 = 0.0;
        for (n4 = 0; n4 < this.numColumns; ++n4) {
            d7 += dArray2[n4];
            d8 += dArray3[n4];
        }
        if (this.width > 0.0) {
            if (this.width > d7) {
                d = this.width - d7;
                dArray = this.expand(dArray2, dArray3, d);
            } else if (this.width < d7) {
                d = d7 - this.width;
                dArray = this.shrink(dArray2, d);
            } else {
                dArray = dArray2;
            }
        } else if (d8 > this.maxTableWidth) {
            if (this.maxTableWidth > d7) {
                d = this.maxTableWidth - d7;
                dArray = this.expand(dArray2, dArray3, d);
            } else if (this.maxTableWidth < d7) {
                d = d7 - this.maxTableWidth;
                dArray = this.shrink(dArray2, d);
            } else {
                dArray = dArray2;
            }
        } else {
            dArray = dArray3;
        }
        return dArray;
    }

    private double[] expand(double[] dArray, double[] dArray2, double d) {
        int n;
        double[] dArray3 = new double[this.numColumns];
        int n2 = 0;
        for (n = 0; n < this.numColumns; ++n) {
            dArray3[n] = dArray[n];
            if (!(dArray3[n] < dArray2[n])) continue;
            ++n2;
        }
        while (d > 0.0) {
            double d2;
            if (n2 == 0) {
                d2 = d / (double)this.numColumns;
                n = 0;
                while (n < this.numColumns) {
                    int n3 = n++;
                    dArray3[n3] = dArray3[n3] + d2;
                }
                d = 0.0;
                continue;
            }
            d2 = d / (double)n2;
            n2 = 0;
            d = 0.0;
            for (n = 0; n < this.numColumns; ++n) {
                if (dArray3[n] < dArray2[n]) {
                    int n4 = n;
                    dArray3[n4] = dArray3[n4] + d2;
                }
                if (dArray3[n] > dArray2[n]) {
                    d += dArray3[n] - dArray2[n];
                    dArray3[n] = dArray2[n];
                    continue;
                }
                if (!(dArray3[n] < dArray2[n])) continue;
                ++n2;
            }
        }
        return dArray3;
    }

    private double[] shrink(double[] dArray, double d) {
        int n;
        double d2 = dArray[0];
        double d3 = dArray[0];
        double d4 = 0.0;
        double[] dArray2 = new double[this.numColumns];
        for (n = 1; n < this.numColumns; ++n) {
            if (dArray[n] < d2) {
                d2 = dArray[n];
                continue;
            }
            if (!(dArray[n] > d3)) continue;
            d3 = dArray[n];
        }
        double d5 = (d2 + d3) / 2.0;
        for (n = 0; n < this.numColumns; ++n) {
            if (!(dArray[n] >= d5)) continue;
            d4 += dArray[n];
        }
        for (n = 0; n < this.numColumns; ++n) {
            if (dArray[n] >= d5) {
                dArray2[n] = dArray[n] - d * dArray[n] / d4;
                if (!(dArray2[n] <= 0.0)) continue;
                dArray2[n] = dArray[n];
                continue;
            }
            dArray2[n] = dArray[n];
        }
        return dArray2;
    }

    private double leftBorderWidth(TableRow tableRow, TableCell tableCell) {
        int n;
        double d = 0.0;
        Border border = tableCell.borders.left;
        if (border.materialized()) {
            d = border.width;
        }
        if (this.borderCollapse == 37 && (n = tableCell.colNumber) > 1) {
            border = tableRow.cells[n - 2].borders.right;
            if (border.materialized() && border.width > d) {
                d = border.width;
            }
            d /= 2.0;
        }
        return d;
    }

    private double rightBorderWidth(TableRow tableRow, TableCell tableCell) {
        Border border;
        int n;
        double d = 0.0;
        if (tableCell.colSpan > 1) {
            n = tableCell.colNumber + tableCell.colSpan - 1;
            tableCell = tableRow.cells[n - 1];
        }
        if ((border = tableCell.borders.right).materialized()) {
            d = border.width;
        }
        if (this.borderCollapse == 37 && (n = tableCell.colNumber) < tableRow.cells.length) {
            border = tableRow.cells[n].borders.left;
            if (border.materialized() && border.width > d) {
                d = border.width;
            }
            d /= 2.0;
        }
        return d;
    }

    public void print(PrintWriter printWriter) {
        int n;
        double d;
        if (this.columns == null) {
            return;
        }
        if (this.spaceBefore > 0.0) {
            d = Math.rint(2.0 * this.spaceBefore);
            if (d < 2.0) {
                d = 2.0;
            }
            Paragraph paragraph = Paragraph.empty(d / 2.0);
            paragraph.print(printWriter);
        }
        printWriter.println("<w:tbl>");
        printWriter.print("<w:tblPr>");
        if (this.columnSpacing > 0.0) {
            d = this.columnSpacing / 2.0;
            printWriter.print("<w:tblCellSpacing");
            printWriter.print(" w:w=\"" + Math.round(20.0 * d) + "\"");
            printWriter.print(" w:type=\"dxa\"");
            printWriter.print(" />");
        }
        if (this.tableIndent > 0.0) {
            printWriter.print("<w:tblInd");
            printWriter.print(" w:w=\"" + Math.round(20.0 * this.tableIndent) + "\"");
            printWriter.print(" w:type=\"dxa\"");
            printWriter.print(" />");
        }
        if (this.borderCollapse == 177 && this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:tblBorders>");
            this.borders.print(printWriter);
            printWriter.print("</w:tblBorders>");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        printWriter.print("<w:tblLayout w:type=\"fixed\" />");
        printWriter.println("</w:tblPr>");
        printWriter.print("<w:tblGrid>");
        for (n = 0; n < this.numColumns; ++n) {
            double d2 = this.columnWidths[n];
            if (this.borderCollapse == 177) {
                d2 += this.columnSpacing;
                if (n == 0 || n == this.numColumns - 1) {
                    d2 += this.columnSpacing / 2.0;
                }
            }
            printWriter.print("<w:gridCol w:w=\"" + Math.round(20.0 * d2) + "\" />");
        }
        printWriter.println("</w:tblGrid>");
        for (n = 0; n < this.groups.length; ++n) {
            this.groups[n].print(printWriter);
        }
        printWriter.println("</w:tbl>");
    }

    public double minWidth() {
        int n;
        double d = this.width;
        if (d > 0.0 && !this.relativeWidth) {
            return d + this.startIndent + this.endIndent;
        }
        if (this.columns == null) {
            this.normalize();
        }
        double[] dArray = new double[this.numColumns];
        for (n = 0; n < this.numColumns; ++n) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn == null || !(tableColumn.width > 0.0) || tableColumn.widthType != 0) continue;
            dArray[tableColumn.number - 1] = tableColumn.width;
        }
        d = 0.0;
        boolean bl = true;
        for (n = 0; n < this.numColumns; ++n) {
            if (dArray[n] == 0.0) {
                bl = false;
                break;
            }
            d += dArray[n];
        }
        if (!bl) {
            for (int i = 0; i < this.groups.length; ++i) {
                TableGroup tableGroup = this.groups[i];
                for (int j = 0; j < tableGroup.rows.length; ++j) {
                    TableRow tableRow = tableGroup.rows[j];
                    for (int k = 0; k < tableRow.cells.length; ++k) {
                        TableCell tableCell = tableRow.cells[k];
                        if (tableCell.hMerge == 2 || tableCell.vMerge == 2) continue;
                        d = tableCell.minWidth();
                        d += this.leftBorderWidth(tableRow, tableCell);
                        d += this.rightBorderWidth(tableRow, tableCell);
                        int n2 = tableCell.colSpan;
                        if (n2 > 1) {
                            d /= (double)n2;
                            int n3 = n + n2;
                            for (n = tableCell.colNumber - 1; n < n3; ++n) {
                                if (!(d > dArray[n])) continue;
                                dArray[n] = d;
                            }
                            continue;
                        }
                        if (!(d > dArray[n])) continue;
                        dArray[n] = d;
                    }
                }
            }
            d = 0.0;
            for (n = 0; n < this.numColumns; ++n) {
                d += dArray[n];
            }
        }
        return d += this.startIndent + this.endIndent;
    }

    public double maxWidth() {
        int n;
        double d = this.width;
        if (d > 0.0 && !this.relativeWidth) {
            return d + this.startIndent + this.endIndent;
        }
        if (this.columns == null) {
            this.normalize();
        }
        double[] dArray = new double[this.numColumns];
        for (n = 0; n < this.numColumns; ++n) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn == null || !(tableColumn.width > 0.0) || tableColumn.widthType != 0) continue;
            dArray[tableColumn.number - 1] = tableColumn.width;
        }
        d = 0.0;
        boolean bl = true;
        for (n = 0; n < this.numColumns; ++n) {
            if (dArray[n] == 0.0) {
                bl = false;
                break;
            }
            d += dArray[n];
        }
        if (!bl) {
            for (int i = 0; i < this.groups.length; ++i) {
                TableGroup tableGroup = this.groups[i];
                for (int j = 0; j < tableGroup.rows.length; ++j) {
                    TableRow tableRow = tableGroup.rows[j];
                    for (int k = 0; k < tableRow.cells.length; ++k) {
                        TableCell tableCell = tableRow.cells[k];
                        if (tableCell.hMerge == 2 || tableCell.vMerge == 2) continue;
                        d = tableCell.maxWidth();
                        d += this.leftBorderWidth(tableRow, tableCell);
                        d += this.rightBorderWidth(tableRow, tableCell);
                        int n2 = tableCell.colSpan;
                        if (n2 > 1) {
                            d /= (double)n2;
                            int n3 = n + n2;
                            for (n = tableCell.colNumber - 1; n < n3; ++n) {
                                if (!(d > dArray[n])) continue;
                                dArray[n] = d;
                            }
                            continue;
                        }
                        if (!(d > dArray[n])) continue;
                        dArray[n] = d;
                    }
                }
            }
            d = 0.0;
            for (n = 0; n < this.numColumns; ++n) {
                d += dArray[n];
            }
        }
        return d += this.startIndent + this.endIndent;
    }

    public double startIndent() {
        return this.startIndent;
    }
}

