/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;

public class TableColumn
implements Cloneable {
    public static final int WIDTH_TYPE_ABSOLUTE = 0;
    public static final int WIDTH_TYPE_RELATIVE = 1;
    public static final int WIDTH_TYPE_PROPORTIONAL = 2;
    public int number;
    public int span;
    public int repeat;
    public double width;
    public int widthType;
    public Borders borders;
    public Color background;

    public TableColumn(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value value;
        Value[] valueArray = context.properties.values;
        this.number = TableColumn.number(valueArray[82]);
        this.span = TableColumn.number(valueArray[187]);
        this.repeat = TableColumn.number(valueArray[186]);
        if (this.span == 1 && (value = valueArray[83]) != null) {
            switch (value.type) {
                case 4: {
                    this.width = value.length();
                    break;
                }
                case 13: {
                    this.width = value.percentage();
                    this.widthType = 1;
                    break;
                }
                case 29: {
                    this.width = value.proportionalColumnWidth();
                    this.widthType = 2;
                }
            }
        }
        this.borders = new Borders(valueArray);
        value = valueArray[8];
        if (value.type == 24) {
            this.background = value.color();
        }
    }

    private static int number(Value value) {
        int n = (int)Math.round(value.number());
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public int last() {
        return this.number + this.span * this.repeat - 1;
    }

    public TableColumn copy() {
        TableColumn tableColumn = null;
        try {
            tableColumn = (TableColumn)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tableColumn;
    }
}

