/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.font.Font;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public final class Text {
    public String content;
    public RunProperties properties;
    public boolean preserveSpace;
    public int footnoteId;

    public Text() {
        this("");
    }

    public Text(String string) {
        this(string, null);
    }

    public Text(String string, RunProperties runProperties) {
        this(string, runProperties, false);
    }

    public Text(String string, RunProperties runProperties, boolean bl) {
        this.content = string;
        this.properties = runProperties;
        this.preserveSpace = bl;
    }

    public boolean isEmpty() {
        return this.content.length() == 0 && this.footnoteId == 0;
    }

    public boolean isSpace() {
        int n = this.content.length();
        for (int i = 0; i < n; ++i) {
            if (this.content.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public void trimLeft() {
        int n = this.content.length();
        if (n == 0 || this.content.charAt(0) != ' ') {
            return;
        }
        for (int i = 1; i < n; ++i) {
            if (this.content.charAt(i) == ' ') continue;
            this.content = this.content.substring(i);
            return;
        }
        this.content = "";
    }

    public void trimRight() {
        int n = this.content.length();
        if (n == 0 || this.content.charAt(n - 1) != ' ') {
            return;
        }
        for (int i = n - 2; i >= 0; --i) {
            if (this.content.charAt(i) == ' ') continue;
            this.content = this.content.substring(0, i + 1);
            return;
        }
        this.content = "";
    }

    public void print(PrintWriter printWriter) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.content, "\u00ad\u2011", true);
        printWriter.println("<w:r>");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        if (this.footnoteId != 0) {
            printWriter.println("<w:footnoteReference w:customMarkFollows=\"true\" w:id=\"" + this.footnoteId + "\" />");
        }
        block4: while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            switch (string.charAt(0)) {
                case '\u00ad': {
                    printWriter.println("<w:softHyphen />");
                    continue block4;
                }
                case '\u2011': {
                    printWriter.println("<w:noBreakHyphen />");
                    continue block4;
                }
            }
            if (this.preserveSpace || string.startsWith(" ") || string.endsWith(" ")) {
                printWriter.println("<w:t xml:space=\"preserve\">" + Wml.escape(string) + "</w:t>");
                continue;
            }
            printWriter.println("<w:t>" + Wml.escape(string) + "</w:t>");
        }
        printWriter.println("</w:r>");
    }

    public double textWidth() {
        Font font = null;
        if (this.properties != null) {
            font = this.properties.getFont();
        }
        double d = font != null ? (double)font.getTextExtents((String)this.content).width / 20.0 : (double)this.content.length() * this.charWidth();
        return d;
    }

    public double wordWidth() {
        double d;
        Font font = null;
        if (this.properties != null) {
            font = this.properties.getFont();
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this.content);
        if (font != null) {
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = font.getTextExtents((String)stringTokenizer.nextToken()).width;
                if (n2 <= n) continue;
                n = n2;
            }
            d = (double)n / 20.0;
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                int n3 = stringTokenizer.nextToken().length();
                if (n3 <= n) continue;
                n = n3;
            }
            d = (double)n * this.charWidth();
        }
        return d;
    }

    private double charWidth() {
        double d = this.properties != null ? this.properties.fontSize : 12.0;
        return 3.0 * d / 4.0;
    }
}

