/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx.sdt;

import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.converter.docx.sdt.CustomXmlProperties;
import com.xmlmind.fo.converter.docx.sdt.SdtDataBinding;
import com.xmlmind.fo.util.Encoding;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;

public final class CustomXml {
    private static final String DEFAULT_ROOT = "root";
    private static final String NAMESPACE_PREFIX = "ns";
    private String root;
    private String namespace;
    private String prefixMapping;
    private CustomXmlProperties properties = new CustomXmlProperties();
    private Vector elements = new Vector();
    private Hashtable elementCounts = new Hashtable();

    public CustomXml() {
        this(null);
    }

    public CustomXml(String string) {
        this(string, null);
    }

    public CustomXml(String string, String string2) {
        if (string2 != null) {
            this.prefixMapping = "xmlns:ns=\"" + string2 + "\"";
        }
        this.root = string != null ? string : DEFAULT_ROOT;
        this.namespace = string2;
    }

    public String id() {
        return this.properties.id();
    }

    public CustomXmlProperties properties() {
        return this.properties;
    }

    public SdtDataBinding add(String string) {
        return this.add(string, null);
    }

    public SdtDataBinding add(String string, String string2) {
        return this.add(string, string2, false);
    }

    public SdtDataBinding add(String string, String string2, boolean bl) {
        int n = this.add(new Element(string, string2, bl));
        String string3 = this.namespace != null ? "ns:" : "";
        String string4 = "/" + string3 + this.root + "/" + string3 + string + "[" + n + "]";
        return new SdtDataBinding(this.id(), string4, this.prefixMapping);
    }

    private int add(Element element) {
        int n = 1;
        Integer n2 = (Integer)this.elementCounts.get(element.name);
        if (n2 != null) {
            n = n2 + 1;
        }
        this.elements.addElement(element);
        this.elementCounts.put(element.name, new Integer(n));
        return n;
    }

    public byte[] getBytes(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(string) + "\"?>");
        this.print(printWriter);
        printWriter.flush();
        return stringWriter.toString().getBytes(string);
    }

    private void print(PrintWriter printWriter) {
        printWriter.print("<" + this.root);
        if (this.namespace != null) {
            printWriter.print(" xmlns=\"" + this.namespace + "\"");
        }
        printWriter.println(">");
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.elements.elementAt(i);
            printWriter.print("  <" + element.name);
            if (element.preserveSpace) {
                printWriter.print(" xml:space=\"preserve\"");
            }
            printWriter.print(">");
            if (element.content != null) {
                printWriter.print(Wml.escape(element.content));
            }
            printWriter.println("</" + element.name + ">");
        }
        printWriter.println("</" + this.root + ">");
    }

    private class Element {
        String name;
        String content;
        boolean preserveSpace;

        Element(String string, String string2, boolean bl) {
            this.name = string;
            this.content = string2;
            this.preserveSpace = bl;
        }
    }
}

