/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx.sdt;

import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.converter.docx.sdt.SdtElement;
import java.io.PrintWriter;
import org.xml.sax.Attributes;

public final class SdtDate
extends SdtElement {
    private static final String DEFAULT_FORMAT = "%Y-%M-%D";
    private String format;

    public SdtDate(Attributes attributes, RunProperties runProperties) {
        super(attributes, runProperties);
        this.format = attributes.getValue("", "format");
        if (this.format == null) {
            this.format = DEFAULT_FORMAT;
        }
        if (this.title == null) {
            this.title = "Date";
        }
    }

    protected void printType(PrintWriter printWriter) {
        String string = SdtDate.dateFormat(this.format);
        if (string == null) {
            string = SdtDate.dateFormat(DEFAULT_FORMAT);
        }
        printWriter.println("<w:date>");
        if (string != null) {
            printWriter.println("<w:dateFormat w:val=\"" + Wml.escape(string) + "\" />");
        }
        printWriter.println("<w:storeMappedDataAs w:val=\"text\" />");
        printWriter.println("</w:date>");
    }

    private static String dateFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (++i < n) {
                    switch (string.charAt(i)) {
                        case 'D': {
                            stringBuffer.append("dd");
                            continue block7;
                        }
                        case 'M': {
                            stringBuffer.append("MM");
                            continue block7;
                        }
                        case 'Y': {
                            stringBuffer.append("yyyy");
                            continue block7;
                        }
                        case 'y': {
                            stringBuffer.append("yy");
                            continue block7;
                        }
                        case '%': {
                            stringBuffer.append('%');
                            continue block7;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                return null;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

