/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx.sdt;

import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Text;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.converter.docx.sdt.SdtDataBinding;
import com.xmlmind.fo.properties.Color;
import java.io.PrintWriter;
import org.xml.sax.Attributes;

public abstract class SdtElement {
    protected String title;
    protected String initialValue;
    protected String prompt;
    protected boolean editable = true;
    protected boolean locked = true;
    protected RunProperties properties;
    protected SdtDataBinding binding;

    public SdtElement(Attributes attributes, RunProperties runProperties) {
        String string;
        this.title = attributes.getValue("", "title");
        this.initialValue = attributes.getValue("", "initial-value");
        this.prompt = attributes.getValue("", "prompt");
        if (this.prompt == null) {
            this.prompt = "\u00a0\u00a0\u00a0";
        }
        if ((string = attributes.getValue("", "editable")) != null) {
            if (string.equals("true")) {
                this.editable = true;
            } else if (string.equals("false")) {
                this.editable = false;
            }
        }
        if ((string = attributes.getValue("", "locked")) != null) {
            if (string.equals("true")) {
                this.locked = true;
            } else if (string.equals("false")) {
                this.locked = false;
            }
        }
        this.properties = runProperties;
    }

    public String initialValue() {
        return this.initialValue;
    }

    public boolean preserveSpace() {
        return false;
    }

    public void setBinding(SdtDataBinding sdtDataBinding) {
        this.binding = sdtDataBinding;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("<w:sdt>");
        printWriter.println("<w:sdtPr>");
        if (this.title != null) {
            printWriter.println("<w:alias w:val=\"" + Wml.escape(this.title) + "\" />");
        }
        this.printType(printWriter);
        if (this.initialValue == null) {
            printWriter.println("<w:showingPlcHdr />");
        }
        String string = this.locked ? (this.editable ? "sdtLocked" : "sdtContentLocked") : (this.editable ? "unlocked" : "contentLocked");
        printWriter.println("<w:lock w:val=\"" + string + "\" />");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        if (this.binding != null) {
            this.binding.print(printWriter);
        }
        printWriter.println("</w:sdtPr>");
        if (this.initialValue == null) {
            this.printPlaceholder(printWriter);
        } else {
            this.printContent(printWriter);
        }
        printWriter.println("</w:sdt>");
    }

    protected void printPlaceholder(PrintWriter printWriter) {
        printWriter.println("<w:sdtContent>");
        Text text = new Text(this.prompt, this.promptProperties());
        text.print(printWriter);
        printWriter.println("</w:sdtContent>");
    }

    protected void printContent(PrintWriter printWriter) {
    }

    protected RunProperties promptProperties() {
        RunProperties runProperties = null;
        if (this.properties != null) {
            runProperties = this.properties.copy();
            runProperties.fgColor = new Color(128, 128, 128);
        }
        return runProperties;
    }

    protected abstract void printType(PrintWriter var1);
}

