/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx.sdt;

import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.sdt.SdtElement;
import java.io.PrintWriter;
import org.xml.sax.Attributes;

public final class SdtPicture
extends SdtElement {
    private static final double DEFAULT_WIDTH = 144.0;
    private static final double DEFAULT_HEIGHT = 144.0;
    private int width = SdtPicture.toEmu(144.0);
    private int height = SdtPicture.toEmu(144.0);
    private int id;
    private String rId;

    public SdtPicture(Attributes attributes, RunProperties runProperties) {
        super(attributes, runProperties);
        if (this.title == null) {
            this.title = "Picture";
        }
        this.initialValue = null;
    }

    public void setImageData(int n, String string) {
        this.id = n;
        this.rId = string;
    }

    public void setGeometry(double d, double d2) {
        this.width = SdtPicture.toEmu(d);
        this.height = SdtPicture.toEmu(d2);
    }

    public void setInitialValue(String string) {
        this.initialValue = string;
    }

    private static int toEmu(double d) {
        double d2 = d * 2.54 * 360000.0 / 72.0;
        return (int)Math.round(d2 / 1000.0) * 1000;
    }

    protected void printPlaceholder(PrintWriter printWriter) {
        this.printContent(printWriter);
    }

    protected void printContent(PrintWriter printWriter) {
        if (this.rId == null) {
            return;
        }
        String string = "SDT_PICTURE_" + Integer.toString(this.id / 2 + 1);
        printWriter.println("<w:sdtContent>");
        printWriter.println("<w:r>");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        printWriter.println("<w:drawing>");
        printWriter.println("<wp:inline>");
        printWriter.print("<wp:extent");
        printWriter.print(" cx=\"" + this.width + "\"");
        printWriter.print(" cy=\"" + this.height + "\"");
        printWriter.println(" />");
        printWriter.print("<wp:docPr");
        printWriter.print(" id=\"" + (this.id + 1) + "\"");
        printWriter.print(" name=\"" + string + "\"");
        printWriter.println(" />");
        printWriter.println("<wp:cNvGraphicFramePr>");
        printWriter.println("<a:graphicFrameLocks noChangeAspect=\"1\" />");
        printWriter.println("</wp:cNvGraphicFramePr>");
        printWriter.println("<a:graphic>");
        printWriter.println("<a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">");
        printWriter.println("<p:pic>");
        printWriter.println("<p:nvPicPr>");
        printWriter.print("<p:cNvPr");
        printWriter.print(" id=\"" + this.id + "\"");
        printWriter.print(" name=\"" + string + "\"");
        printWriter.println(" />");
        printWriter.println("<p:cNvPicPr />");
        printWriter.println("</p:nvPicPr>");
        printWriter.println("<p:blipFill>");
        printWriter.println("<a:blip r:embed=\"" + this.rId + "\" />");
        printWriter.println("<a:stretch />");
        printWriter.println("</p:blipFill>");
        printWriter.println("<p:spPr>");
        printWriter.println("<a:xfrm>");
        printWriter.println("<a:off x=\"0\" y=\"0\" />");
        printWriter.print("<a:ext");
        printWriter.print(" cx=\"" + this.width + "\"");
        printWriter.print(" cy=\"" + this.height + "\"");
        printWriter.println(" />");
        printWriter.println("</a:xfrm>");
        printWriter.println("<a:prstGeom prst=\"rect\" />");
        printWriter.println("</p:spPr>");
        printWriter.println("</p:pic>");
        printWriter.println("</a:graphicData>");
        printWriter.println("</a:graphic>");
        printWriter.println("</wp:inline>");
        printWriter.println("</w:drawing>");
        printWriter.println("</w:r>");
        printWriter.println("</w:sdtContent>");
    }

    protected void printType(PrintWriter printWriter) {
        printWriter.println("<w:picture />");
    }
}

