/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.font.FontUtil;
import java.io.PrintWriter;

public final class FontFace {
    public static final String FAMILY_ROMAN = "roman";
    public static final String FAMILY_SWISS = "swiss";
    public static final String FAMILY_MODERN = "modern";
    public static final String FAMILY_SCRIPT = "script";
    public static final String FAMILY_DECORATIVE = "decorative";
    public static final String FAMILY_SYSTEM = "system";
    public String name;
    public String family;
    public String charset;
    public String id;

    public FontFace(String string) {
        this(string, null, null);
    }

    public FontFace(String string, String string2) {
        this(string, string2, null);
    }

    public FontFace(String string, String string2, String string3) {
        this.name = string;
        if (string2 == null) {
            switch (FontUtil.toGenericFamily(string, false)) {
                case 1: {
                    string2 = FAMILY_ROMAN;
                    break;
                }
                case 2: {
                    string2 = FAMILY_SWISS;
                    break;
                }
                case 3: {
                    string2 = FAMILY_MODERN;
                    break;
                }
                case 4: {
                    string2 = FAMILY_DECORATIVE;
                    break;
                }
                case 5: {
                    string2 = FAMILY_SCRIPT;
                }
            }
        }
        this.family = string2;
        this.charset = string3;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:font-face");
        printWriter.print(" style:name=\"" + this.id + "\"");
        printWriter.print(" svg:font-family=\"" + this.name + "\"");
        if (this.family != null) {
            printWriter.print(" style:font-family-generic=\"" + this.family + "\"");
        }
        if (this.charset != null) {
            printWriter.print(" style:font-charset=\"" + this.charset + "\"");
        }
        printWriter.println("/>");
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontFace)) {
            return false;
        }
        FontFace fontFace = (FontFace)object;
        return this.name.equalsIgnoreCase(fontFace.name);
    }
}

