/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.FontFace;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public final class FontTable {
    private String charset;
    private Hashtable fonts = new Hashtable();
    private Vector fontList = new Vector();
    private Hashtable familyAliases = new Hashtable();

    public FontTable() {
        this(null);
    }

    public FontTable(String string) {
        this.charset = string;
    }

    public void aliasFontFamily(String string, String string2) {
        this.familyAliases.put(string, string2);
    }

    public String unaliasFontFamily(String string) {
        String string2 = (String)this.familyAliases.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public FontFace add(String string) {
        return this.add(string, null);
    }

    public FontFace add(String string, String string2) {
        return this.add(string, string2, this.charset);
    }

    public FontFace add(String string, String string2, String string3) {
        return this.add(new FontFace(this.unaliasFontFamily(string), string2, string3));
    }

    public FontFace add(FontFace fontFace) {
        FontFace fontFace2 = (FontFace)this.fonts.get(fontFace);
        if (fontFace2 == null) {
            fontFace.id = "F" + this.fonts.size();
            this.fonts.put(fontFace, fontFace);
            this.fontList.addElement(fontFace);
        } else {
            fontFace = fontFace2;
        }
        return fontFace;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("<office:font-face-decls>");
        int n = this.fontList.size();
        for (int i = 0; i < n; ++i) {
            FontFace fontFace = (FontFace)this.fontList.elementAt(i);
            fontFace.print(printWriter);
        }
        printWriter.println("</office:font-face-decls>");
    }
}

